/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm.commons;

import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Opcodes;
import org.jetbrains.coverage.org.objectweb.asm.Type;
import org.jetbrains.coverage.org.objectweb.asm.TypePath;

public class LocalVariablesSorter
extends MethodVisitor {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private int[] remappedVariableIndices = new int[40];
    private Object[] remappedLocalTypes = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;

    /*
     * WARNING - void declaration
     */
    public LocalVariablesSorter(int access, String descriptor, MethodVisitor methodVisitor) {
        this(589824, (int)var1_1, (String)var2_2, (MethodVisitor)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.getClass() != LocalVariablesSorter.class) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected LocalVariablesSorter(int api, int access, String descriptor, MethodVisitor methodVisitor) {
        super((int)var1_1, methodVisitor);
        void var3_4;
        int n;
        void var1_1;
        this.nextLocal = (8 & n) == 0 ? 1 : 0;
        for (Type argumentType : Type.getArgumentTypes((String)var3_4)) {
            this.nextLocal += argumentType.getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int varIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        switch (opcode) {
            case 22: 
            case 55: {
                Type varType = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                Type varType = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                Type varType = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                Type varType = Type.INT_TYPE;
                break;
            }
            case 25: 
            case 58: 
            case 169: {
                Type varType = OBJECT_TYPE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid opcode " + opcode);
            }
        }
        super.visitVarInsn((int)var1_1, this.remap((int)var2_2, (Type)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int varIndex, int increment) {
        void var2_2;
        void var1_1;
        LocalVariablesSorter localVariablesSorter = this;
        super.visitIincInsn(localVariablesSorter.remap((int)var1_1, Type.INT_TYPE), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitMaxs(int maxStack, int maxLocals) {
        void var1_1;
        super.visitMaxs((int)var1_1, this.nextLocal);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        void var3_3;
        void var2_2;
        void var1_1;
        int remappedIndex = this.remap(index, Type.getType(descriptor));
        super.visitLocalVariable((String)var1_1, (String)var2_2, (String)var3_3, start, end, remappedIndex);
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        void var3_3;
        void var2_2;
        void var1_1;
        Type type = Type.getType(descriptor);
        int[] remappedIndex = new int[index.length];
        for (int i = 0; i < remappedIndex.length; ++i) {
            remappedIndex[i] = this.remap(index[i], type);
        }
        return super.visitLocalVariableAnnotation((int)var1_1, (TypePath)var2_2, (Label[])var3_3, end, remappedIndex, descriptor, visible);
    }

    /*
     * WARNING - void declaration
     */
    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        void var1_1;
        Object localType;
        if (type != -1) {
            throw new IllegalArgumentException("LocalVariablesSorter only accepts expanded frames (see ClassReader.EXPAND_FRAMES)");
        }
        Object[] oldRemappedLocals = new Object[this.remappedLocalTypes.length];
        System.arraycopy(this.remappedLocalTypes, 0, oldRemappedLocals, 0, oldRemappedLocals.length);
        LocalVariablesSorter localVariablesSorter = this;
        localVariablesSorter.updateNewLocals(localVariablesSorter.remappedLocalTypes);
        int oldVar = 0;
        for (int i = 0; i < numLocal; ++i) {
            Object localType2 = local[i];
            if (localType2 != Opcodes.TOP) {
                Type varType = OBJECT_TYPE;
                if (localType2 == Opcodes.INTEGER) {
                    varType = Type.INT_TYPE;
                } else if (localType2 == Opcodes.FLOAT) {
                    varType = Type.FLOAT_TYPE;
                } else if (localType2 == Opcodes.LONG) {
                    varType = Type.LONG_TYPE;
                } else if (localType2 == Opcodes.DOUBLE) {
                    varType = Type.DOUBLE_TYPE;
                } else if (localType2 instanceof String) {
                    varType = Type.getObjectType((String)localType2);
                }
                LocalVariablesSorter localVariablesSorter2 = this;
                localVariablesSorter2.setFrameLocal(localVariablesSorter2.remap(oldVar, varType), localType2);
            }
            oldVar += localType2 == Opcodes.LONG || localType2 == Opcodes.DOUBLE ? 2 : 1;
        }
        int newVar = 0;
        int remappedNumLocal = 0;
        for (oldVar = 0; oldVar < this.remappedLocalTypes.length; oldVar += (localType = this.remappedLocalTypes[oldVar]) == Opcodes.LONG || localType == Opcodes.DOUBLE ? 2 : 1) {
            if (localType != null && localType != Opcodes.TOP) {
                this.remappedLocalTypes[newVar++] = localType;
                remappedNumLocal = newVar;
                continue;
            }
            this.remappedLocalTypes[newVar++] = Opcodes.TOP;
        }
        super.visitFrame((int)var1_1, remappedNumLocal, this.remappedLocalTypes, numStack, stack);
        this.remappedLocalTypes = oldRemappedLocals;
    }

    /*
     * WARNING - void declaration
     */
    public int newLocal(Type type) {
        void var3_3;
        void var2_2;
        void var1_1;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                Object localType = Opcodes.INTEGER;
                break;
            }
            case 6: {
                Object localType = Opcodes.FLOAT;
                break;
            }
            case 7: {
                Object localType = Opcodes.LONG;
                break;
            }
            case 8: {
                Object localType = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                Object localType = type.getDescriptor();
                break;
            }
            case 10: {
                Object localType = type.getInternalName();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int local = this.newLocalMapping(type);
        this.setLocalType(local, (Type)var1_1);
        this.setFrameLocal(local, var2_2);
        return (int)var3_3;
    }

    protected void updateNewLocals(Object[] newLocals) {
    }

    protected void setLocalType(int local, Type type) {
    }

    /*
     * WARNING - void declaration
     */
    private void setFrameLocal(int local, Object type) {
        void var2_2;
        int numLocals = this.remappedLocalTypes.length;
        if (local >= numLocals) {
            void var3_3;
            Object[] newRemappedLocalTypes = new Object[Math.max(2 * numLocals, local + 1)];
            System.arraycopy(this.remappedLocalTypes, 0, newRemappedLocalTypes, 0, (int)var3_3);
            this.remappedLocalTypes = newRemappedLocalTypes;
        }
        this.remappedLocalTypes[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int remap(int varIndex, Type type) {
        int value;
        int size;
        if (varIndex + type.getSize() <= this.firstLocal) {
            return varIndex;
        }
        int key = 2 * varIndex + type.getSize() - 1;
        if (key >= (size = this.remappedVariableIndices.length)) {
            void var3_3;
            int[] newRemappedVariableIndices = new int[Math.max(2 * size, key + 1)];
            System.arraycopy(this.remappedVariableIndices, 0, newRemappedVariableIndices, 0, (int)var3_3);
            this.remappedVariableIndices = newRemappedVariableIndices;
        }
        if ((value = this.remappedVariableIndices[key]) == 0) {
            void var2_2;
            value = this.newLocalMapping(type);
            this.setLocalType(value, (Type)var2_2);
            this.remappedVariableIndices[var1_1] = value + 1;
        } else {
            --value;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    protected int newLocalMapping(Type type) {
        void var2_2;
        void var1_1;
        int local = this.nextLocal;
        this.nextLocal += var1_1.getSize();
        return (int)var2_2;
    }
}

