/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.CSSLexicalValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.impl.AttrUtil;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ColorMinifier;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public class LexicalValue
extends ProxyValue
implements CSSLexicalValue {
    private static final long serialVersionUID = 1L;
    private LexicalUnit lexicalUnit;

    public LexicalValue() {
        super(CSSValue.Type.LEXICAL);
    }

    protected LexicalValue(LexicalValue copied) {
        super(copied);
        this.lexicalUnit = copied.lexicalUnit.clone();
    }

    @Override
    public LexicalUnit getLexicalUnit() {
        return this.lexicalUnit;
    }

    public void setLexicalUnit(LexicalUnit lexicalUnit) {
        this.lexicalUnit = lexicalUnit;
    }

    @Override
    public CSSValue.Type getFinalType() {
        CSSValue.Type type;
        LexicalUnit nlu = this.lexicalUnit.getNextLexicalUnit();
        if (nlu != null) {
            if (nlu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH && this.isRatioCompUnit(this.lexicalUnit.getLexicalUnitType()) && (nlu = nlu.getNextLexicalUnit()) != null && this.isRatioCompUnit(nlu.getLexicalUnitType())) {
                return CSSValue.Type.RATIO;
            }
            return CSSValue.Type.UNKNOWN;
        }
        switch (this.lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                type = CSSValue.Type.IDENT;
                break;
            }
            case ATTR: {
                type = AttrUtil.finalAttrType(this.lexicalUnit);
                break;
            }
            case STRING: {
                type = CSSValue.Type.STRING;
                break;
            }
            case URI: {
                type = CSSValue.Type.URI;
                break;
            }
            case SRC: {
                type = CSSValue.Type.SRC;
                break;
            }
            case DIMENSION: 
            case PERCENTAGE: 
            case REAL: 
            case INTEGER: {
                type = CSSValue.Type.NUMERIC;
                break;
            }
            case RGBCOLOR: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: {
                type = CSSValue.Type.COLOR;
                break;
            }
            case CALC: {
                type = CSSValue.Type.EXPRESSION;
                break;
            }
            case FUNCTION: 
            case PREFIXED_FUNCTION: {
                type = CSSValue.Type.FUNCTION;
                break;
            }
            case GRADIENT: {
                type = CSSValue.Type.GRADIENT;
                break;
            }
            case MATH_FUNCTION: {
                type = CSSValue.Type.MATH_FUNCTION;
                break;
            }
            case COLOR_MIX: {
                type = CSSValue.Type.COLOR_MIX;
                break;
            }
            case CUBIC_BEZIER_FUNCTION: {
                type = CSSValue.Type.CUBIC_BEZIER;
                break;
            }
            case STEPS_FUNCTION: {
                type = CSSValue.Type.STEPS;
                break;
            }
            case RECT_FUNCTION: {
                type = CSSValue.Type.RECT;
                break;
            }
            case CIRCLE_FUNCTION: {
                type = CSSValue.Type.CIRCLE;
                break;
            }
            case ELLIPSE_FUNCTION: {
                type = CSSValue.Type.ELLIPSE;
                break;
            }
            case INSET_FUNCTION: {
                type = CSSValue.Type.INSET;
                break;
            }
            case PATH_FUNCTION: {
                type = CSSValue.Type.PATH;
                break;
            }
            case POLYGON_FUNCTION: {
                type = CSSValue.Type.POLYGON;
                break;
            }
            case SHAPE_FUNCTION: {
                type = CSSValue.Type.SHAPE;
                break;
            }
            case XYWH_FUNCTION: {
                type = CSSValue.Type.XYWH;
                break;
            }
            case COUNTER_FUNCTION: {
                type = CSSValue.Type.COUNTER;
                break;
            }
            case COUNTERS_FUNCTION: {
                type = CSSValue.Type.COUNTERS;
                break;
            }
            case ENV: {
                type = CSSValue.Type.ENV;
                break;
            }
            case ELEMENT_REFERENCE: {
                type = CSSValue.Type.ELEMENT_REFERENCE;
                break;
            }
            default: {
                type = CSSValue.Type.UNKNOWN;
            }
        }
        return type;
    }

    private boolean isRatioCompUnit(LexicalUnit.LexicalType lutype) {
        return lutype == LexicalUnit.LexicalType.INTEGER || lutype == LexicalUnit.LexicalType.REAL || lutype == LexicalUnit.LexicalType.CALC || lutype == LexicalUnit.LexicalType.MATH_FUNCTION;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        return this.lexicalUnit.matches(syntax);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        CSSValueSyntax synComp = syntax.shallowClone();
        return this.lexicalUnit.matches(synComp);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        CSSOMParser parser = new CSSOMParser();
        try {
            this.lexicalUnit = parser.parsePropertyValue(new StringReader(cssText));
        }
        catch (CSSException | IOException e) {
            throw new DOMSyntaxException(e);
        }
    }

    @Override
    public String getCssText() {
        return this.lexicalUnit.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.getCssText());
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        return LexicalValue.serializeMinifiedSequence(this.lexicalUnit, propertyName, true);
    }

    public static String serializeMinifiedSequence(LexicalUnit lexicalUnit) {
        return LexicalValue.serializeMinifiedSequence(lexicalUnit, null, true);
    }

    public static String serializeMinifiedSequence(LexicalUnit lexicalUnit, String propertyName, boolean keepZeroUnit) {
        if (lexicalUnit.getNextLexicalUnit() == null) {
            return LexicalValue.serializeMinified(lexicalUnit, propertyName, keepZeroUnit).toString();
        }
        StringBuilder buf = new StringBuilder(32);
        boolean needSpaces = false;
        for (LexicalUnit lu = lexicalUnit; lu != null; lu = lu.getNextLexicalUnit()) {
            switch (lu.getLexicalUnitType()) {
                case OPERATOR_EXP: 
                case OPERATOR_GE: 
                case OPERATOR_GT: 
                case OPERATOR_LE: 
                case OPERATOR_LT: 
                case OPERATOR_MULTIPLY: 
                case OPERATOR_SLASH: 
                case OPERATOR_TILDE: 
                case LEFT_BRACKET: 
                case OPERATOR_COMMA: 
                case OPERATOR_SEMICOLON: 
                case OPERATOR_COLON: {
                    needSpaces = false;
                    break;
                }
                case RIGHT_BRACKET: {
                    needSpaces = true;
                    break;
                }
                default: {
                    if (needSpaces) {
                        buf.append(' ');
                        break;
                    }
                    needSpaces = true;
                }
            }
            buf.append(LexicalValue.serializeMinified(lu, propertyName, keepZeroUnit));
        }
        return buf.toString();
    }

    private static CharSequence serializeMinified(LexicalUnit lexicalUnit, String propertyName, boolean keepZeroUnit) {
        if (lexicalUnit.getParameters() != null) {
            switch (lexicalUnit.getLexicalUnitType()) {
                case RGBCOLOR: {
                    String cssText = lexicalUnit.getCssText();
                    if (cssText.length() < 10) {
                        cssText = ColorMinifier.getInstance().minifyHex(cssText);
                        return cssText;
                    }
                }
                default: {
                    StringBuilder buf = new StringBuilder();
                    buf.append(lexicalUnit.getFunctionName()).append('(');
                    LexicalUnit lu = lexicalUnit.getParameters();
                    if (lu != null) {
                        buf.append(LexicalValue.serializeMinifiedSequence(lu));
                    }
                    buf.append(')');
                    return buf;
                }
                case SUB_EXPRESSION: {
                    StringBuilder buf = new StringBuilder();
                    buf.append('(');
                    LexicalUnit lu = lexicalUnit.getSubValues();
                    if (lu != null) {
                        buf.append(LexicalValue.serializeMinifiedSequence(lu));
                    }
                    buf.append(')');
                    return buf;
                }
                case EMPTY: {
                    StringList pre = lexicalUnit.getPrecedingComments();
                    if (pre != null) {
                        StringBuilder buf = new StringBuilder();
                        LexicalValue.writeComments(pre, buf);
                        return buf;
                    }
                    StringList after = lexicalUnit.getTrailingComments();
                    if (after != null) {
                        StringBuilder buf = new StringBuilder();
                        LexicalValue.writeComments(after, buf);
                        return buf;
                    }
                    return "";
                }
                case ELEMENT_REFERENCE: 
            }
        } else {
            switch (lexicalUnit.getLexicalUnitType()) {
                case URI: {
                    String s = lexicalUnit.getStringValue();
                    if (!LexicalValue.urlCanBeUnquoted(s)) break;
                    return "url(" + s + ')';
                }
                case DIMENSION: {
                    float f = lexicalUnit.getFloatValue();
                    if (f == 0.0f) {
                        if (!keepZeroUnit && !lexicalUnit.isParameter() && CSSUnit.isLengthUnitType(lexicalUnit.getCssUnit())) {
                            return "0";
                        }
                    } else if (Float.isInfinite(f)) {
                        return LexicalValue.serializeInfinite(f, lexicalUnit.getDimensionUnitText());
                    }
                    return LexicalValue.serializeNumber(f, lexicalUnit.getDimensionUnitText());
                }
                case PERCENTAGE: 
                case REAL: {
                    float f = lexicalUnit.getFloatValue();
                    if (Float.isInfinite(f)) {
                        return LexicalValue.serializeInfinite(f, lexicalUnit.getDimensionUnitText());
                    }
                    return LexicalValue.serializeNumber(f, lexicalUnit.getDimensionUnitText());
                }
                case IDENT: {
                    String s = lexicalUnit.getStringValue();
                    String color = ColorIdentifiers.getInstance().getColor(s);
                    if (color != null && color.length() < s.length()) {
                        s = color;
                    }
                    return s;
                }
                case INITIAL: {
                    StyleValue ini;
                    if (propertyName == null || propertyName.isEmpty() || lexicalUnit.isParameter() || (ini = PropertyDatabase.getInstance().getInitialValue(propertyName)) == null) break;
                    String mini = ini.getMinifiedCssText();
                    String text = lexicalUnit.getCssText();
                    if (mini.length() < text.length()) {
                        return mini;
                    }
                    return text;
                }
            }
        }
        return lexicalUnit.getCssText();
    }

    static boolean urlCanBeUnquoted(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c <= ' ' || Character.isISOControl(c)) {
                return false;
            }
            switch (c) {
                case '\"': 
                case '\'': 
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }

    private static String serializeInfinite(float realvalue, String unitText) {
        if (realvalue > 0.0f) {
            return "calc(1" + unitText + "/0)";
        }
        return "calc(-1" + unitText + "/0)";
    }

    private static CharSequence serializeNumber(float f, String unitText) {
        float rintValue = (float)Math.rint(f);
        String s = f == rintValue ? Integer.toString((int)rintValue) : Float.toString(f);
        int len = s.length();
        StringBuilder buf = new StringBuilder(len + unitText.length());
        char c = s.charAt(0);
        if (c == '-' && s.charAt(1) == '0') {
            buf.append('-');
            buf.append(s.subSequence(2, len));
        } else if (c == '0' && len > 2) {
            buf.append(s.subSequence(1, len));
        } else {
            buf.append(s);
        }
        buf.append(unitText);
        return buf;
    }

    private static void writeComments(StringList pre, StringBuilder buf) {
        for (String c : pre) {
            buf.append("/*");
            buf.append(c);
            buf.append("*/");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LexicalValue other = (LexicalValue)obj;
        LexicalUnit lu = this.lexicalUnit;
        LexicalUnit otherlu = other.lexicalUnit;
        while (lu != null) {
            if (!lu.equals(otherlu)) {
                return false;
            }
            lu = lu.getNextLexicalUnit();
            otherlu = otherlu.getNextLexicalUnit();
        }
        return otherlu == null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        for (LexicalUnit lu = this.lexicalUnit; lu != null; lu = lu.getNextLexicalUnit()) {
            result = 31 * result + lu.hashCode();
        }
        return result;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public LexicalValue clone() {
        return new LexicalValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(LexicalValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalValue.this.lexicalUnit = lunit;
        }
    }
}

