/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;

public interface DataInput {
    public boolean hasRemaining() throws IOException;

    public int getPosition() throws IOException;

    public void setPosition(int var1) throws IOException;

    public byte readByte() throws IOException;

    public int readUnsignedByte() throws IOException;

    public int peekUnsignedByte(int var1) throws IOException;

    default public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    default public int readUnsignedShort() throws IOException {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        return b1 << 8 | b2;
    }

    default public int readInt() throws IOException {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        int b4 = this.readUnsignedByte();
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public byte[] readBytes(int var1) throws IOException;

    public int length() throws IOException;

    default public int readOffset(int offSize) throws IOException {
        int value = 0;
        for (int i = 0; i < offSize; ++i) {
            value = value << 8 | this.readUnsignedByte();
        }
        return value;
    }
}

