/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNEmptyNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.SmartNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilterObjectType;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.utils.CommonUtils;

public class DatabaseBrowserView
extends NavigatorViewBase {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.databaseBrowser";
    private static final Log log = Log.getLog(DatabaseBrowserView.class);
    private DBNNode rootNode;

    @Override
    protected INavigatorFilter getNavigatorFilter() {
        return new SmartNavigatorTreeFilter();
    }

    @Override
    public DBNNode getRootNode() {
        String secondaryId;
        if (this.rootNode == null && !CommonUtils.isEmpty((String)(secondaryId = this.getViewSite().getSecondaryId()))) {
            try {
                this.rootNode = DatabaseBrowserView.getNodeFromSecondaryId(secondaryId);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Open database browser", "Can't find database navigator node", (Throwable)e);
            }
        }
        if (this.rootNode != null) {
            return this.rootNode;
        }
        return this.getDefaultRootNode();
    }

    protected DBNNode getDefaultRootNode() {
        DBNProject projectNode = DatabaseBrowserView.getGlobalNavigatorModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        return projectNode == null ? new DBNEmptyNode() : projectNode.getDatabases();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getNavigatorTree().setFilterObjectType(this.getDefaultFilterType());
        String secondaryId = this.getViewSite().getSecondaryId();
        if (!CommonUtils.isEmpty((String)secondaryId)) {
            UIExecutionQueue.queueExec(() -> {
                try {
                    DBNNode node = DatabaseBrowserView.getNodeFromSecondaryId(secondaryId);
                    this.setPartName(node.getNodeDisplayName());
                    this.setTitleImage(DBeaverIcons.getImage((DBPImage)node.getNodeIconDefault()));
                }
                catch (DBException e) {
                    log.error((Object)"Error creating DB browser view", (Throwable)e);
                }
            });
        }
    }

    @NotNull
    protected DatabaseNavigatorTreeFilterObjectType getDefaultFilterType() {
        return DatabaseNavigatorTreeFilterObjectType.table;
    }

    public static String getSecondaryIdFromNode(DBNNode node) {
        DBPProject project = null;
        DBNNode dn = node;
        while (dn != null) {
            if (dn instanceof DBNProject) {
                project = ((DBNProject)dn).getProject();
                break;
            }
            dn = dn.getParentNode();
        }
        if (project == null) {
            throw new IllegalStateException("Navigator node " + node.getNodeUri() + " doesn't belong to a project");
        }
        return project.getName() + "|" + node.getNodeUri().replace(":", "~");
    }

    public static DBNNode getNodeFromSecondaryId(String id) throws DBException {
        int divPos = id.indexOf(124);
        if (divPos == -1) {
            throw new DBException("Bad secondary ID: " + id);
        }
        String projectName = id.substring(0, divPos);
        String nodePath = id.substring(divPos + 1).replace("~", ":");
        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
        DBNNode node = null;
        DBPProject projectMeta = DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
        if (projectMeta != null) {
            navigatorModel.ensureProjectLoaded(projectMeta);
            node = (DBNNode)UIUtils.runWithMonitor(monitor -> {
                monitor.beginTask("Find navigator node", 1);
                try {
                    monitor.subTask("Find node " + nodePath);
                    DBNNode dBNNode = navigatorModel.getNodeByPath(monitor, projectMeta, nodePath);
                    return dBNNode;
                }
                finally {
                    monitor.done();
                }
            });
        }
        if (node == null) {
            log.error((Object)("Node " + nodePath + " not found for browse view"));
            node = new DBNEmptyNode();
        }
        return node;
    }
}

