/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;

class TagQuestions {
    static final NodePattern pronounBeforeQuestion = NodePattern.N.pos("PRP").noPos("NN").directlyBefore(NodePattern.N.form("\\?"));
    static final NodePattern possiblyTagQuestion = NodePattern.N.pos("VB.*").lemma("be|do|have").and(CommonPatterns.beforeSkipping(EnglishTreePatterns.negation, pronounBeforeQuestion)).noDependents("nsubj.*|aux.*|cop", NodePattern.N.beforeHead()).noDependents("advmod", Questions.whWord).andOr(NodePattern.N.afterHead().withHead("parataxis|aux|conj", EnglishTreePatterns.clause.markAs("Main")).noDependents("cc", NodePattern.N.beforeHead()), NodePattern.ROOT.withDependent("ccomp|advmod", EnglishTreePatterns.clause.beforeHead().markAs("Main"))).andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT.andNot(CommonPatterns.comma)));
    static final String MESSAGE = "Mismatched tag question verb?";

    TagQuestions() {
    }

    static NodePattern pattern() {
        return possiblyTagQuestion.noForm("ai").and(CommonPatterns.afterSkipping(CommonPatterns.comma, NodePattern.N.markAs("Prev").andNot(NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("acl:relcl"))))).and((tag, match) -> {
            List clauseCandidates = ((StreamEx)match.getMarkedNode("Prev").hierarchy().filter(c -> EnglishTreePatterns.clause.matches((Node)c) && c.isBefore(tag))).toList();
            if (clauseCandidates.stream().anyMatch(cl -> !cl.hasDependent("nsubj.*"))) {
                return null;
            }
            LinkedHashSet expectedTags = (LinkedHashSet)StreamEx.of((Collection)clauseCandidates).flatCollection(c -> TagQuestions.findExpectedQuestionTag(tag, c)).toCollection(LinkedHashSet::new);
            if (!expectedTags.contains(tag.lowForm())) {
                return match.withCorrectors(StreamEx.of((Collection)expectedTags).map(t -> NodeCorrector.replace(tag, t)).toList());
            }
            return null;
        }).message(MESSAGE);
    }

    private static List<String> findExpectedQuestionTag(Node tag, Node main) {
        boolean useAux;
        Node finite = EnglishTreePatterns.findFiniteVerb(main);
        if (finite == tag) {
            return List.of(VerbInflectionNumber.Inflector.like(main).inflectDo());
        }
        boolean bl = useAux = finite.hasLemma("be") || finite.hasPos("MD") || finite != main && finite.hasLemma("have");
        if (useAux) {
            List<String> decontracted = ToggleContraction.decontractVerb(finite);
            if (decontracted.contains("am") && EnglishTreePatterns.contractedNot.matches(tag.nextNode())) {
                return List.of("are");
            }
            return decontracted;
        }
        return List.of(VerbInflectionNumber.Inflector.like(finite).inflectDo());
    }
}

