/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.values.ValueBase;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/debugger/values/PrimitiveValue;", "Lorg/jetbrains/debugger/values/ValueBase;", "type", "Lorg/jetbrains/debugger/values/ValueType;", "valueString", "", "<init>", "(Lorg/jetbrains/debugger/values/ValueType;Ljava/lang/String;)V", "value", "", "(Lorg/jetbrains/debugger/values/ValueType;I)V", "", "(Lorg/jetbrains/debugger/values/ValueType;J)V", "getValueString", "()Ljava/lang/String;", "Companion", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
public class PrimitiveValue
extends ValueBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String valueString;
    @NotNull
    public static final String NA_N_VALUE = "NaN";
    @NotNull
    public static final String INFINITY_VALUE = "Infinity";
    @JvmField
    @NotNull
    public static final PrimitiveValue NULL = new PrimitiveValue(ValueType.NULL, "null");
    @JvmField
    @NotNull
    public static final PrimitiveValue UNDEFINED = new PrimitiveValue(ValueType.UNDEFINED, "undefined");
    @NotNull
    private static final PrimitiveValue NAN = new PrimitiveValue(ValueType.NUMBER, "NaN");
    @NotNull
    private static final PrimitiveValue INFINITY = new PrimitiveValue(ValueType.NUMBER, "Infinity");
    @NotNull
    private static final PrimitiveValue TRUE = new PrimitiveValue(ValueType.BOOLEAN, "true");
    @NotNull
    private static final PrimitiveValue FALSE = new PrimitiveValue(ValueType.BOOLEAN, "false");

    public PrimitiveValue(@NotNull ValueType type, @NotNull String valueString) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)valueString, (String)"valueString");
        super(type);
        this.valueString = valueString;
    }

    @Override
    @NotNull
    public String getValueString() {
        return this.valueString;
    }

    public PrimitiveValue(@NotNull ValueType type, int value) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, String.valueOf(value));
    }

    public PrimitiveValue(@NotNull ValueType type, long value) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this(type, String.valueOf(value));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/debugger/values/PrimitiveValue$Companion;", "", "<init>", "()V", "NA_N_VALUE", "", "INFINITY_VALUE", "NULL", "Lorg/jetbrains/debugger/values/PrimitiveValue;", "UNDEFINED", "NAN", "getNAN", "()Lorg/jetbrains/debugger/values/PrimitiveValue;", "INFINITY", "getINFINITY", "TRUE", "FALSE", "bool", "value", "intellij.platform.scriptDebugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PrimitiveValue getNAN() {
            return NAN;
        }

        @NotNull
        public final PrimitiveValue getINFINITY() {
            return INFINITY;
        }

        @NotNull
        public final PrimitiveValue bool(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)value, (Object)"true") ? TRUE : FALSE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

