/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.config;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.tasks.CommitPlaceholderProvider;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.config.TaskConfigurable;
import com.intellij.tasks.config.TaskRepositoriesConfigurable;
import com.intellij.tasks.config.TaskSettings;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\tH\u0002J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e*\b\u0012\u0004\u0012\u00020\t0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/tasks/config/TaskConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable$Parent;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "changelistNameFormat", "Lcom/intellij/ui/EditorTextField;", "branchNameFormat", "lazyConfigurables", "", "Lcom/intellij/openapi/options/Configurable;", "getLazyConfigurables", "()[Lcom/intellij/openapi/options/Configurable;", "lazyConfigurables$delegate", "Lkotlin/Lazy;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "getConfigurables", "hasOwnContent", "", "getConfig", "Lcom/intellij/tasks/impl/TaskManagerImpl$Config;", "setupAddAction", "field", "bindText", "Lcom/intellij/ui/dsl/builder/Cell;", "prop", "Lkotlin/reflect/KMutableProperty0;", "", "intellij.tasks.core"})
public final class TaskConfigurable
extends BoundSearchableConfigurable
implements SearchableConfigurable.Parent,
Configurable.NoScroll {
    @NotNull
    private final Project project;
    @NotNull
    private final EditorTextField changelistNameFormat;
    @NotNull
    private final EditorTextField branchNameFormat;
    @NotNull
    private final Lazy lazyConfigurables$delegate;

    public TaskConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = TaskBundle.message((String)"configurable.TaskConfigurable.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "reference.settings.project.tasks", "tasks");
        this.project = project;
        this.lazyConfigurables$delegate = LazyKt.lazy(() -> TaskConfigurable.lazyConfigurables_delegate$lambda$0(this));
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("VTL");
        if (fileType == null) {
            fileType = (FileType)PlainTextFileType.INSTANCE;
        }
        FileType fileType2 = fileType;
        Project project2 = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        Project defaultProject = project2;
        this.branchNameFormat = new EditorTextField(defaultProject, fileType2);
        this.setupAddAction(this.branchNameFormat);
        this.changelistNameFormat = new EditorTextField(defaultProject, fileType2);
        this.setupAddAction(this.changelistNameFormat);
    }

    private final Configurable[] getLazyConfigurables() {
        Lazy lazy = this.lazyConfigurables$delegate;
        return (Configurable[])lazy.getValue();
    }

    @NotNull
    public DialogPanel createPanel() {
        TaskSettings settings = TaskSettings.getInstance();
        TaskManagerImpl.Config config = this.getConfig();
        return BuilderKt.panel(arg_0 -> TaskConfigurable.createPanel$lambda$0(this, config, settings, arg_0));
    }

    public void apply() throws ConfigurationException {
        String string = this.changelistNameFormat.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() == 0) {
            throw new ConfigurationException(TaskBundle.message((String)"settings.change.list.name.format.should.not.be.empty", (Object[])new Object[0]));
        }
        String string2 = this.branchNameFormat.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString()).length() == 0) {
            throw new ConfigurationException(TaskBundle.message((String)"settings.Branch.name.format.should.not.be.empty", (Object[])new Object[0]));
        }
        int oldConnectionTimeout = TaskSettings.getInstance().CONNECTION_TIMEOUT;
        boolean oldUpdateEnabled = this.getConfig().updateEnabled;
        super.apply();
        if (this.project.isDefault()) {
            return;
        }
        TaskManager manager = TaskManager.getManager((Project)this.project);
        if (this.getConfig().updateEnabled && !oldUpdateEnabled) {
            manager.updateIssues(null);
        }
        if (TaskSettings.getInstance().CONNECTION_TIMEOUT != oldConnectionTimeout) {
            TaskRepository[] taskRepositoryArray = manager.getAllRepositories();
            Intrinsics.checkNotNullExpressionValue((Object)taskRepositoryArray, (String)"getAllRepositories(...)");
            for (TaskRepository repository : taskRepositoryArray) {
                if (!(repository instanceof BaseRepositoryImpl)) continue;
                ((BaseRepositoryImpl)repository).reconfigureClient();
            }
        }
    }

    @NotNull
    public Configurable[] getConfigurables() {
        return this.getLazyConfigurables();
    }

    public boolean hasOwnContent() {
        return true;
    }

    private final TaskManagerImpl.Config getConfig() {
        TaskManager taskManager = TaskManager.getManager((Project)this.project);
        Intrinsics.checkNotNull((Object)taskManager, (String)"null cannot be cast to non-null type com.intellij.tasks.impl.TaskManagerImpl");
        TaskManagerImpl.Config config = ((TaskManagerImpl)taskManager).getState();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"getState(...)");
        return config;
    }

    private final void setupAddAction(EditorTextField field) {
        field.addSettingsProvider(arg_0 -> TaskConfigurable.setupAddAction$lambda$0(field, this, arg_0));
    }

    private final Cell<EditorTextField> bindText(Cell<? extends EditorTextField> $this$bindText, KMutableProperty0<String> prop) {
        return $this$bindText.bind(TaskConfigurable::bindText$lambda$0, TaskConfigurable::bindText$lambda$1, MutablePropertyKt.toMutableProperty(prop));
    }

    private static final Configurable[] lazyConfigurables_delegate$lambda$0(TaskConfigurable this$0) {
        Configurable[] configurableArray = new Configurable[]{new TaskRepositoriesConfigurable(this$0.project)};
        return configurableArray;
    }

    private static final Unit createPanel$lambda$0(TaskConfigurable this$0, TaskManagerImpl.Config $config, TaskSettings $settings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = TaskBundle.message((String)"settings.changelist.name.format", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> TaskConfigurable.createPanel$lambda$0$0(this$0, $config, arg_0));
        String string2 = TaskBundle.message((String)"settings.feature.branch.name.format", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> TaskConfigurable.createPanel$lambda$0$1(this$0, $config, arg_0));
        $this$panel.row("", arg_0 -> TaskConfigurable.createPanel$lambda$0$2($settings, arg_0));
        String string3 = TaskBundle.message((String)"settings.task.history.length", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> TaskConfigurable.createPanel$lambda$0$3($config, arg_0));
        String string4 = TaskBundle.message((String)"settings.connection.timeout", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$panel.row(string4, arg_0 -> TaskConfigurable.createPanel$lambda$0$4($settings, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TaskConfigurable.createPanel$lambda$0$5($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> TaskConfigurable.createPanel$lambda$0$6($config, arg_0), (int)1, null);
        Panel.group$default((Panel)$this$panel, (String)TaskBundle.message((String)"settings.issue.cache", (Object[])new Object[0]), (boolean)false, arg_0 -> TaskConfigurable.createPanel$lambda$0$7($config, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(TaskConfigurable this$0, TaskManagerImpl.Config $config, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.bindText((Cell<? extends EditorTextField>)$this$row.cell((JComponent)this$0.changelistNameFormat), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl($config){

            public Object get() {
                return ((TaskManagerImpl.Config)this.receiver).changelistNameFormat;
            }

            public void set(Object value) {
                ((TaskManagerImpl.Config)this.receiver).changelistNameFormat = (String)value;
            }
        })).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(TaskConfigurable this$0, TaskManagerImpl.Config $config, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.bindText((Cell<? extends EditorTextField>)$this$row.cell((JComponent)this$0.branchNameFormat), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl($config){

            public Object get() {
                return ((TaskManagerImpl.Config)this.receiver).branchNameFormat;
            }

            public void set(Object value) {
                ((TaskManagerImpl.Config)this.receiver).branchNameFormat = (String)value;
            }
        })).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(TaskSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TaskBundle.message((String)"settings.lowercased", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((TaskSettings)this.receiver).LOWER_CASE_BRANCH;
            }

            public void set(Object value) {
                ((TaskSettings)this.receiver).LOWER_CASE_BRANCH = (Boolean)value;
            }
        })).resizableColumn();
        Cell cell2 = TextFieldKt.columns((Cell)TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((TaskSettings)this.receiver).REPLACE_SPACES;
            }

            public void set(Object value) {
                ((TaskSettings)this.receiver).REPLACE_SPACES = (String)value;
            }
        })), (int)1);
        String string2 = TaskBundle.message((String)"settings.replace.spaces.with", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Cell.label$default((Cell)cell2, (String)string2, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(TaskManagerImpl.Config $config, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindIntText((Cell)TextFieldKt.columns((Cell)Row.intTextField$default((Row)$this$row, null, null, (int)3, null), (int)6), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($config){

            public Object get() {
                return ((TaskManagerImpl.Config)this.receiver).taskHistoryLength;
            }

            public void set(Object value) {
                ((TaskManagerImpl.Config)this.receiver).taskHistoryLength = ((Number)value).intValue();
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4(TaskSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = TextFieldKt.columns((Cell)Row.intTextField$default((Row)$this$row, null, null, (int)3, null), (int)6);
        Intrinsics.checkNotNull((Object)$settings);
        TextFieldKt.bindIntText((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((TaskSettings)this.receiver).CONNECTION_TIMEOUT;
            }

            public void set(Object value) {
                ((TaskSettings)this.receiver).CONNECTION_TIMEOUT = ((Number)value).intValue();
            }
        })).gap(RightGap.SMALL);
        String string = TaskBundle.message((String)"settings.milliseconds", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5(TaskSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TaskBundle.message((String)"settings.always.display.task.combo.in.toolbar", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((TaskSettings)this.receiver).ALWAYS_DISPLAY_COMBO;
            }

            public void set(Object value) {
                ((TaskSettings)this.receiver).ALWAYS_DISPLAY_COMBO = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$6(TaskManagerImpl.Config $config, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TaskBundle.message((String)"settings.save.context.on.commit", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($config){

            public Object get() {
                return ((TaskManagerImpl.Config)this.receiver).saveContextOnCommit;
            }

            public void set(Object value) {
                ((TaskManagerImpl.Config)this.receiver).saveContextOnCommit = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$7(TaskManagerImpl.Config $config, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> TaskConfigurable.createPanel$lambda$0$7$0($config, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$7$0(TaskManagerImpl.Config $config, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = TaskBundle.message((String)"settings.enable.cache", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell updateCheckBox2 = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($config){

            public Object get() {
                return ((TaskManagerImpl.Config)this.receiver).updateEnabled;
            }

            public void set(Object value) {
                ((TaskManagerImpl.Config)this.receiver).updateEnabled = (Boolean)value;
            }
        }));
        Cell cell = TextFieldKt.bindIntText((Cell)Row.intTextField$default((Row)$this$row, null, null, (int)3, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($config){

            public Object get() {
                return ((TaskManagerImpl.Config)this.receiver).updateIssuesCount;
            }

            public void set(Object value) {
                ((TaskManagerImpl.Config)this.receiver).updateIssuesCount = ((Number)value).intValue();
            }
        })).enabledIf(ButtonKt.getSelected((Cell)updateCheckBox2));
        String string2 = TaskBundle.message((String)"settings.Update", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        TextFieldKt.columns((Cell)Cell.label$default((Cell)cell, (String)string2, null, (int)2, null), (int)4).gap(RightGap.SMALL);
        Cell cell2 = TextFieldKt.bindIntText((Cell)Row.intTextField$default((Row)$this$row, null, null, (int)3, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($config){

            public Object get() {
                return ((TaskManagerImpl.Config)this.receiver).updateInterval;
            }

            public void set(Object value) {
                ((TaskManagerImpl.Config)this.receiver).updateInterval = ((Number)value).intValue();
            }
        })).enabledIf(ButtonKt.getSelected((Cell)updateCheckBox2));
        String string3 = TaskBundle.message((String)"settings.issues.every", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        TextFieldKt.columns((Cell)Cell.label$default((Cell)cell2, (String)string3, null, (int)2, null), (int)4).gap(RightGap.SMALL);
        String string4 = TaskBundle.message((String)"settings.minutes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$row.label(string4).enabledIf(ButtonKt.getSelected((Cell)updateCheckBox2));
        return Unit.INSTANCE;
    }

    private static final void setupAddAction$lambda$0(EditorTextField $field, TaskConfigurable this$0, EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ExtendableTextComponent.Extension extension2 = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineAdd, (Icon)AllIcons.General.InlineAddHover, (String)TaskBundle.message((String)"settings.add.placeholder", (Object[])new Object[0]), () -> TaskConfigurable.setupAddAction$lambda$0$0(editor, this$0));
        ExtendableEditorSupport.setupExtension((EditorEx)editor, (Color)$field.getBackground(), (ExtendableTextComponent.Extension)extension2);
    }

    private static final void setupAddAction$lambda$0$0(EditorEx $editor, TaskConfigurable this$0) {
        HashSet placeholders = new HashSet();
        for (CommitPlaceholderProvider provider : CommitPlaceholderProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            Collection collection = placeholders;
            String[] stringArray = provider.getPlaceholders(null);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getPlaceholders(...)");
            CollectionsKt.addAll((Collection)collection, (Object[])stringArray);
        }
        String string = TaskBundle.message((String)"settings.placeholders", (Object[])new Object[0]);
        List list = CollectionsKt.toList((Iterable)placeholders);
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(this$0, $editor, string, (List<String>)list){
            final /* synthetic */ TaskConfigurable this$0;
            final /* synthetic */ EditorEx $editor;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                super($super_call_param$1, $super_call_param$2);
            }

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                WriteCommandAction.runWriteCommandAction((Project)TaskConfigurable.access$getProject$p(this.this$0), () -> setupAddAction.1.extension.1.1.onChosen$lambda$0(this.$editor, selectedValue));
                PopupStep popupStep = BaseListPopupStep.FINAL_CHOICE;
                Intrinsics.checkNotNullExpressionValue((Object)popupStep, (String)"FINAL_CHOICE");
                return popupStep;
            }

            private static final void onChosen$lambda$0(EditorEx $editor, String $selectedValue) {
                $editor.getDocument().insertString($editor.getCaretModel().getOffset(), (CharSequence)("${" + $selectedValue + "}"));
            }
        }).showInBestPositionFor((Editor)$editor);
    }

    private static final String bindText$lambda$0(EditorTextField component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        String string = component.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Unit bindText$lambda$1(EditorTextField component, String value) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        component.setText(value);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(TaskConfigurable $this) {
        return $this.project;
    }
}

