/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.JOptionPaneDriver;
import org.assertj.swing.fixture.AbstractContainerFixture;
import org.assertj.swing.fixture.JButtonFixture;

public class JOptionPaneFixture
extends AbstractContainerFixture<JOptionPaneFixture, JOptionPane, JOptionPaneDriver> {
    public JOptionPaneFixture(@Nonnull Robot robot) {
        this(robot, JOptionPaneFixture.findShowingOptionPane(robot));
    }

    @Nonnull
    private static JOptionPane findShowingOptionPane(@Nonnull Robot robot) {
        Preconditions.checkNotNull((Object)robot);
        return robot.finder().findByType(JOptionPane.class, true);
    }

    public JOptionPaneFixture(@Nonnull Robot robot, @Nonnull JOptionPane target) {
        super(JOptionPaneFixture.class, robot, target);
    }

    @Override
    @Nonnull
    protected JOptionPaneDriver createDriver(@Nonnull Robot robot) {
        return new JOptionPaneDriver(robot);
    }

    @Nullable
    public String title() {
        return ((JOptionPaneDriver)this.driver()).title((JOptionPane)this.target());
    }

    @Nonnull
    public JButtonFixture okButton() {
        return new JButtonFixture(this.robot(), ((JOptionPaneDriver)this.driver()).okButton((JOptionPane)this.target()));
    }

    @Nonnull
    public JButtonFixture cancelButton() {
        return new JButtonFixture(this.robot(), ((JOptionPaneDriver)this.driver()).cancelButton((JOptionPane)this.target()));
    }

    @Nonnull
    public JButtonFixture yesButton() {
        return new JButtonFixture(this.robot(), ((JOptionPaneDriver)this.driver()).yesButton((JOptionPane)this.target()));
    }

    @Nonnull
    public JButtonFixture noButton() {
        return new JButtonFixture(this.robot(), ((JOptionPaneDriver)this.driver()).noButton((JOptionPane)this.target()));
    }

    @Nonnull
    public JButtonFixture buttonWithText(@Nullable String text) {
        return new JButtonFixture(this.robot(), ((JOptionPaneDriver)this.driver()).buttonWithText((JOptionPane)this.target(), text));
    }

    @Nonnull
    public JButtonFixture buttonWithText(@Nonnull Pattern pattern) {
        return new JButtonFixture(this.robot(), ((JOptionPaneDriver)this.driver()).buttonWithText((JOptionPane)this.target(), pattern));
    }

    @Nonnull
    public JOptionPaneFixture requireErrorMessage() {
        ((JOptionPaneDriver)this.driver()).requireErrorMessage((JOptionPane)this.target());
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requireInformationMessage() {
        ((JOptionPaneDriver)this.driver()).requireInformationMessage((JOptionPane)this.target());
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requireWarningMessage() {
        ((JOptionPaneDriver)this.driver()).requireWarningMessage((JOptionPane)this.target());
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requireQuestionMessage() {
        ((JOptionPaneDriver)this.driver()).requireQuestionMessage((JOptionPane)this.target());
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requirePlainMessage() {
        ((JOptionPaneDriver)this.driver()).requirePlainMessage((JOptionPane)this.target());
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requireTitle(@Nullable String title) {
        ((JOptionPaneDriver)this.driver()).requireTitle((JOptionPane)this.target(), title);
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requireTitle(@Nonnull Pattern pattern) {
        ((JOptionPaneDriver)this.driver()).requireTitle((JOptionPane)this.target(), pattern);
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requireMessage(@Nullable Object message) {
        ((JOptionPaneDriver)this.driver()).requireMessage((JOptionPane)this.target(), message);
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requireMessage(@Nonnull Pattern pattern) {
        ((JOptionPaneDriver)this.driver()).requireMessage((JOptionPane)this.target(), pattern);
        return this;
    }

    @Nonnull
    public JOptionPaneFixture requireOptions(@Nonnull Object[] options) {
        ((JOptionPaneDriver)this.driver()).requireOptions((JOptionPane)this.target(), options);
        return this;
    }
}

