/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.concurrency.ChildContext;
import com.intellij.util.concurrency.Propagation;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

final class ContextCallable<V>
implements Callable<V> {
    private final boolean myRoot;
    @NotNull
    private final ChildContext myChildContext;
    @NotNull
    private final Callable<? extends V> myCallable;
    @NotNull
    private final AtomicBoolean myTracker;

    @Async.Schedule
    ContextCallable(boolean root, @NotNull ChildContext context, @NotNull Callable<? extends V> callable, @NotNull AtomicBoolean cancellationTracker) {
        if (context == null) {
            ContextCallable.$$$reportNull$$$0(0);
        }
        if (callable == null) {
            ContextCallable.$$$reportNull$$$0(1);
        }
        if (cancellationTracker == null) {
            ContextCallable.$$$reportNull$$$0(2);
        }
        this.myRoot = root;
        this.myChildContext = context;
        this.myCallable = callable;
        this.myTracker = cancellationTracker;
    }

    @Override
    @Async.Execute
    public V call() throws Exception {
        RunResult result;
        if (this.myTracker.getAndSet(true)) {
            throw new ProcessCanceledException();
        }
        if (this.myRoot) {
            result = this.myChildContext.runInChildContext(true, () -> {
                try {
                    return new RunResult(this.myCallable.call());
                }
                catch (Exception e) {
                    return new RunResult(e);
                }
            });
        } else {
            Supplier<RunResult> temp = () -> ThreadContext.installThreadContext(this.myChildContext.getContext(), true, () -> {
                try (AccessToken ignored2 = this.myChildContext.applyContextActions(false);){
                    RunResult runResult = new RunResult(this.myCallable.call());
                    return runResult;
                }
            });
            Continuation<Unit> continuation = this.myChildContext.getContinuation();
            result = continuation == null ? temp.get() : Propagation.runAsCoroutine(continuation, true, temp::get);
        }
        return result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "cancellationTracker";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/concurrency/ContextCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class RunResult<V, E extends Exception> {
        Object result;
        boolean isSuccess;

        RunResult(V result) {
            this.result = result;
            this.isSuccess = true;
        }

        RunResult(E error) {
            this.result = error;
            this.isSuccess = false;
        }

        V get() throws E {
            if (this.isSuccess) {
                return (V)this.result;
            }
            throw (Exception)ExceptionUtilRt.addRethrownStackAsSuppressed((Throwable)((Exception)this.result));
        }
    }
}

