/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.diagnostic.WindowsDefenderChecker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleWindowsDefenderCheckerExt
implements WindowsDefenderChecker.Extension {
    @NotNull
    public Collection<Path> getPaths(@Nullable Project project, @Nullable Path projectPath) {
        VirtualFile projectDir;
        Object[] children;
        boolean isGradleProject;
        if (project != null && !GradleSettings.getInstance((Project)project).getLinkedProjectsSettings().isEmpty()) {
            Collection<Path> collection = GradleWindowsDefenderCheckerExt.getGradlePaths();
            if (collection == null) {
                GradleWindowsDefenderCheckerExt.$$$reportNull$$$0(0);
            }
            return collection;
        }
        if (projectPath != null && (isGradleProject = ContainerUtil.exists((Object[])(children = (projectDir = VirtualFileManager.getInstance().findFileByNioPath(projectPath)) != null ? projectDir.getChildren() : VirtualFile.EMPTY_ARRAY), file -> GradleConstants.KNOWN_GRADLE_FILES.contains(file.getName())))) {
            Collection<Path> collection = GradleWindowsDefenderCheckerExt.getGradlePaths();
            if (collection == null) {
                GradleWindowsDefenderCheckerExt.$$$reportNull$$$0(1);
            }
            return collection;
        }
        List<Path> list = List.of();
        if (list == null) {
            GradleWindowsDefenderCheckerExt.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static Collection<Path> getGradlePaths() {
        Path gradleDir;
        String envVar = System.getenv("GRADLE_USER_HOME");
        Path path = gradleDir = envVar != null ? Path.of(envVar, new String[0]) : Path.of(System.getProperty("user.home"), ".gradle");
        if (Files.isDirectory(gradleDir, new LinkOption[0])) {
            return List.of(gradleDir);
        }
        return List.of();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/util/GradleWindowsDefenderCheckerExt", "getPaths"));
    }
}

