/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElementList;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalLoopStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeconstructionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiIfStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLabeledStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabelStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.cache.TypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.AnnotationElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

public final class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance(JavaSharedImplUtil.class);
    private static final TokenSet BRACKETS = TokenSet.create(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET);

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(0);
        }
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(1);
        }
        return JavaSharedImplUtil.getType(typeElement, anchor, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(2);
        }
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(3);
        }
        PsiType type = typeElement.getType();
        boolean ellipsisType = type instanceof PsiEllipsisType;
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        int size = allAnnotations.size();
        for (int i2 = 0; i2 < size; ++i2) {
            type = (ellipsisType && i2 == size - 1 ? new PsiEllipsisType(type) : type.createArrayType()).annotate(TypeAnnotationProvider.Static.create(allAnnotations.get(i2)));
        }
        return type;
    }

    @Nullable
    private static List<PsiAnnotation[]> collectAnnotations(@NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(4);
        }
        List<PsiAnnotation[]> annotations2 = Collections.emptyList();
        SmartList<PsiAnnotation> current = null;
        boolean found = stopAt == null;
        boolean stop = false;
        for (PsiElement child = anchor.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current == null) {
                    current = new SmartList<PsiAnnotation>();
                }
                current.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                if (annotations2 == Collections.EMPTY_LIST) {
                    annotations2 = new SmartList<PsiAnnotation[]>();
                }
                annotations2.add(0, current == null ? PsiAnnotation.EMPTY_ARRAY : ContainerUtil.toArray(current, PsiAnnotation.ARRAY_FACTORY));
                current = null;
                if (!stop) continue;
                return annotations2;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.RBRACKET)) break;
        }
        return !found || stop ? null : annotations2;
    }

    @NotNull
    public static PsiType createTypeFromStub(@NotNull PsiModifierListOwner owner, @NotNull TypeInfo typeInfo) {
        if (owner == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(5);
        }
        if (typeInfo == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(6);
        }
        String typeText = typeInfo.text();
        assert (typeText != null) : owner;
        PsiType type = JavaPsiFacade.getInstance(owner.getProject()).getParserFacade().createTypeFromText(typeText, owner);
        type = JavaSharedImplUtil.applyAnnotations(type, owner.getModifierList());
        PsiType psiType = typeInfo.getTypeAnnotations().applyTo(type, owner);
        if (psiType == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(7);
        }
        return psiType;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type, @Nullable PsiModifierList modifierList2) {
        PsiAnnotation[] annotations2;
        if (type == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(8);
        }
        if (modifierList2 != null && (annotations2 = modifierList2.getAnnotations()).length > 0) {
            if (type instanceof PsiArrayType) {
                Stack<PsiArrayType> types2 = new Stack<PsiArrayType>();
                do {
                    types2.push((PsiArrayType)type);
                } while ((type = ((PsiArrayType)type).getComponentType()) instanceof PsiArrayType);
                type = JavaSharedImplUtil.annotate(type, modifierList2, annotations2);
                while (!types2.isEmpty()) {
                    PsiArrayType t2 = (PsiArrayType)types2.pop();
                    type = t2 instanceof PsiEllipsisType ? new PsiEllipsisType(type, t2.getAnnotations()) : new PsiArrayType(type, t2.getAnnotations());
                }
                PsiType psiType = type;
                if (psiType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(9);
                }
                return psiType;
            }
            if (type instanceof PsiDisjunctionType) {
                ArrayList<PsiType> components = new ArrayList<PsiType>(((PsiDisjunctionType)type).getDisjunctions());
                components.set(0, JavaSharedImplUtil.annotate((PsiType)components.get(0), modifierList2, annotations2));
                PsiDisjunctionType psiDisjunctionType = ((PsiDisjunctionType)type).newDisjunctionType(components);
                if (psiDisjunctionType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(10);
                }
                return psiDisjunctionType;
            }
            return JavaSharedImplUtil.annotate(type, modifierList2, annotations2);
        }
        PsiType psiType = type;
        if (psiType == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(11);
        }
        return psiType;
    }

    @NotNull
    private static PsiType annotate(@NotNull PsiType type, @NotNull PsiModifierList modifierList2, PsiAnnotation @NotNull [] annotations2) {
        if (type == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(12);
        }
        if (modifierList2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(13);
        }
        if (annotations2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(14);
        }
        TypeAnnotationProvider original = modifierList2.getParent() instanceof PsiMethod ? type.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
        FilteringTypeAnnotationProvider provider2 = new FilteringTypeAnnotationProvider(annotations2, original);
        PsiType psiType = type.annotate(provider2);
        if (psiType == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable) {
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(16);
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameElement = variable.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type = typeElement.getNode();
        ASTNode name2 = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name2;
        MultiMap<Integer, AnnotationElement> annotationElementsToMove = new MultiMap<Integer, AnnotationElement>();
        while (element != null) {
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) instanceof AnnotationElement) {
                annotationElementsToMove.putValue(arrayCount, (AnnotationElement)element);
                continue;
            }
            if (element == null || element.getElementType() != JavaTokenType.LBRACKET) break;
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = PsiImplUtil.skipWhitespaceAndComments(name2.getTreeNext());
            while (element != null) {
                ASTNode next = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext());
                CodeEditUtil.removeChild(variableElement, element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type.clone();
            if (!(typeElement.getType() instanceof PsiArrayType)) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType = newType1;
            }
            for (int i2 = arrayCount - 1; i2 >= 0; --i2) {
                TreeElement anchor = newType.getFirstChildNode();
                anchor.rawInsertAfterMe(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                anchor.rawInsertAfterMe(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                List annotations2 = (List)annotationElementsToMove.get(i2);
                for (int j2 = annotations2.size() - 1; j2 >= 0; --j2) {
                    anchor.rawInsertAfterMe((TreeElement)annotations2.get(j2));
                }
            }
            newType.acceptTree(new GeneratedMarkerVisitor());
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type));
            CodeEditUtil.replaceChild(variableElement, type, newType);
        }
    }

    @NotNull
    public static PsiElement getPatternVariableDeclarationScope(@NotNull PsiPatternVariable variable) {
        PsiElement parent2;
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(17);
        }
        if (!((parent2 = variable.getPattern().getParent()) instanceof PsiInstanceOfExpression || parent2 instanceof PsiCaseLabelElementList || parent2 instanceof PsiPattern || parent2 instanceof PsiDeconstructionList)) {
            PsiElement psiElement = parent2;
            if (psiElement == null) {
                JavaSharedImplUtil.$$$reportNull$$$0(18);
            }
            return psiElement;
        }
        PsiElement psiElement = JavaSharedImplUtil.getInstanceOfPartDeclarationScope(parent2);
        if (psiElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getPatternVariableDeclarationScope(@NotNull PsiInstanceOfExpression instanceOfExpression) {
        if (instanceOfExpression == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(20);
        }
        return JavaSharedImplUtil.getInstanceOfPartDeclarationScope(instanceOfExpression);
    }

    private static PsiElement getInstanceOfPartDeclarationScope(@NotNull PsiElement parent2) {
        if (parent2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(21);
        }
        boolean negated = false;
        PsiElement nextParent = parent2.getParent();
        while (true) {
            if (!(nextParent instanceof PsiParenthesizedExpression)) {
                IElementType tokenType;
                if (nextParent instanceof PsiForeachStatementBase || nextParent instanceof PsiConditionalExpression && parent2 == ((PsiConditionalExpression)nextParent).getCondition()) {
                    return nextParent;
                }
                if (nextParent instanceof PsiPrefixExpression && ((PsiPrefixExpression)nextParent).getOperationTokenType().equals(JavaTokenType.EXCL)) {
                    negated = !negated;
                } else if (!(nextParent instanceof PsiPolyadicExpression && ((tokenType = ((PsiPolyadicExpression)nextParent).getOperationTokenType()).equals(JavaTokenType.ANDAND) && !negated || tokenType.equals(JavaTokenType.OROR) && negated))) {
                    if (nextParent instanceof PsiIfStatement) {
                        while (nextParent.getParent() instanceof PsiLabeledStatement) {
                            nextParent = nextParent.getParent();
                        }
                        return nextParent.getParent();
                    }
                    if (nextParent instanceof PsiConditionalLoopStatement) {
                        if (!negated) {
                            return nextParent;
                        }
                        while (nextParent.getParent() instanceof PsiLabeledStatement) {
                            nextParent = nextParent.getParent();
                        }
                        return nextParent.getParent();
                    }
                    if (nextParent instanceof PsiSwitchLabelStatementBase) {
                        while (nextParent.getParent() instanceof PsiLabeledStatement) {
                            nextParent = nextParent.getParent();
                        }
                        return nextParent.getParent();
                    }
                    if (!(nextParent instanceof PsiPattern || nextParent instanceof PsiCaseLabelElementList || parent2 instanceof PsiPattern && nextParent instanceof PsiInstanceOfExpression || parent2 instanceof PsiPattern && nextParent instanceof PsiDeconstructionList)) {
                        return parent2;
                    }
                }
            }
            parent2 = nextParent;
            nextParent = parent2.getParent();
        }
    }

    public static void setInitializer(@NotNull PsiVariable variable, PsiExpression initializer) throws IncorrectOperationException {
        PsiExpression oldInitializer;
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(22);
        }
        if ((oldInitializer = variable.getInitializer()) != null) {
            oldInitializer.delete();
        }
        if (initializer == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable.getManager());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable;
        }
        variable.addAfter(initializer, eq.getPsi());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOfExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeFromStub";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAnnotations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternVariableDeclarationScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromStub";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyAnnotations";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBrackets";
                break;
            }
            case 17: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPatternVariableDeclarationScope";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceOfPartDeclarationScope";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(PsiAnnotation @NotNull [] candidates, @NotNull TypeAnnotationProvider originalProvider) {
            if (originalProvider == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(0);
            }
            if (candidates == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates;
            this.myOriginalProvider = originalProvider;
        }

        @Override
        public PsiAnnotation @NotNull [] getAnnotations() {
            PsiAnnotation[] result2 = this.myCache;
            if (result2 == null) {
                List<PsiAnnotation> filtered = JBIterable.of(this.myCandidates).filter(annotation -> !annotation.isValid() || AnnotationTargetUtil.isTypeAnnotation(annotation)).append((PsiAnnotation)this.myOriginalProvider.getAnnotations()).toList();
                result2 = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
                this.myCache = result2;
            }
            if (result2 == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

