﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codepipeline/CodePipeline_EXPORTS.h>
#include <aws/codepipeline/model/PipelineSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodePipeline {
namespace Model {
/**
 * <p>Represents the output of a <code>ListPipelines</code> action.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelinesOutput">AWS
 * API Reference</a></p>
 */
class ListPipelinesResult {
 public:
  AWS_CODEPIPELINE_API ListPipelinesResult() = default;
  AWS_CODEPIPELINE_API ListPipelinesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEPIPELINE_API ListPipelinesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of pipelines.</p>
   */
  inline const Aws::Vector<PipelineSummary>& GetPipelines() const { return m_pipelines; }
  template <typename PipelinesT = Aws::Vector<PipelineSummary>>
  void SetPipelines(PipelinesT&& value) {
    m_pipelinesHasBeenSet = true;
    m_pipelines = std::forward<PipelinesT>(value);
  }
  template <typename PipelinesT = Aws::Vector<PipelineSummary>>
  ListPipelinesResult& WithPipelines(PipelinesT&& value) {
    SetPipelines(std::forward<PipelinesT>(value));
    return *this;
  }
  template <typename PipelinesT = PipelineSummary>
  ListPipelinesResult& AddPipelines(PipelinesT&& value) {
    m_pipelinesHasBeenSet = true;
    m_pipelines.emplace_back(std::forward<PipelinesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the amount of returned information is significantly large, an identifier
   * is also returned. It can be used in a subsequent list pipelines call to return
   * the next set of pipelines in the list.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListPipelinesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListPipelinesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<PipelineSummary> m_pipelines;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_pipelinesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodePipeline
}  // namespace Aws
