/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import java.util.concurrent.TimeUnit;

@Immutable
public class ConnectionPoolSettings {
    private final int maxSize;
    private final int minSize;
    private final int maxWaitQueueSize;
    private final long maxWaitTimeMS;
    private final long maxConnectionLifeTimeMS;
    private final long maxConnectionIdleTimeMS;
    private final long maintenanceInitialDelayMS;
    private final long maintenanceFrequencyMS;

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxWaitQueueSize() {
        return this.maxWaitQueueSize;
    }

    public long getMaxWaitTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxWaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public long getMaxConnectionLifeTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxConnectionLifeTimeMS, TimeUnit.MILLISECONDS);
    }

    public long getMaxConnectionIdleTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxConnectionIdleTimeMS, TimeUnit.MILLISECONDS);
    }

    public long getMaintenanceInitialDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.maintenanceInitialDelayMS, TimeUnit.MILLISECONDS);
    }

    public long getMaintenanceFrequency(TimeUnit timeUnit) {
        return timeUnit.convert(this.maintenanceFrequencyMS, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPoolSettings that = (ConnectionPoolSettings)o;
        if (this.maxConnectionIdleTimeMS != that.maxConnectionIdleTimeMS) {
            return false;
        }
        if (this.maxConnectionLifeTimeMS != that.maxConnectionLifeTimeMS) {
            return false;
        }
        if (this.maxSize != that.maxSize) {
            return false;
        }
        if (this.minSize != that.minSize) {
            return false;
        }
        if (this.maintenanceInitialDelayMS != that.maintenanceInitialDelayMS) {
            return false;
        }
        if (this.maintenanceFrequencyMS != that.maintenanceFrequencyMS) {
            return false;
        }
        if (this.maxWaitQueueSize != that.maxWaitQueueSize) {
            return false;
        }
        return this.maxWaitTimeMS == that.maxWaitTimeMS;
    }

    public int hashCode() {
        int result = this.maxSize;
        result = 31 * result + this.minSize;
        result = 31 * result + this.maxWaitQueueSize;
        result = 31 * result + (int)(this.maxWaitTimeMS ^ this.maxWaitTimeMS >>> 32);
        result = 31 * result + (int)(this.maxConnectionLifeTimeMS ^ this.maxConnectionLifeTimeMS >>> 32);
        result = 31 * result + (int)(this.maxConnectionIdleTimeMS ^ this.maxConnectionIdleTimeMS >>> 32);
        result = 31 * result + (int)(this.maintenanceInitialDelayMS ^ this.maintenanceInitialDelayMS >>> 32);
        result = 31 * result + (int)(this.maintenanceFrequencyMS ^ this.maintenanceFrequencyMS >>> 32);
        return result;
    }

    public String toString() {
        return "ConnectionPoolSettings{maxSize=" + this.maxSize + ", minSize=" + this.minSize + ", maxWaitQueueSize=" + this.maxWaitQueueSize + ", maxWaitTimeMS=" + this.maxWaitTimeMS + ", maxConnectionLifeTimeMS=" + this.maxConnectionLifeTimeMS + ", maxConnectionIdleTimeMS=" + this.maxConnectionIdleTimeMS + ", maintenanceInitialDelayMS=" + this.maintenanceInitialDelayMS + ", maintenanceFrequencyMS=" + this.maintenanceFrequencyMS + '}';
    }

    ConnectionPoolSettings(Builder builder) {
        Assertions.isTrue("maxSize > 0", builder.maxSize > 0);
        Assertions.isTrue("minSize >= 0", builder.minSize >= 0);
        Assertions.isTrue("maxWaitQueueSize >= 0", builder.maxWaitQueueSize >= 0);
        Assertions.isTrue("maintenanceInitialDelayMS >= 0", builder.maintenanceInitialDelayMS >= 0L);
        Assertions.isTrue("maxConnectionLifeTime >= 0", builder.maxConnectionLifeTimeMS >= 0L);
        Assertions.isTrue("maxConnectionIdleTime >= 0", builder.maxConnectionIdleTimeMS >= 0L);
        Assertions.isTrue("sizeMaintenanceFrequency > 0", builder.maintenanceFrequencyMS > 0L);
        Assertions.isTrue("maxSize >= minSize", builder.maxSize >= builder.minSize);
        this.maxSize = builder.maxSize;
        this.minSize = builder.minSize;
        this.maxWaitQueueSize = builder.maxWaitQueueSize;
        this.maxWaitTimeMS = builder.maxWaitTimeMS;
        this.maxConnectionLifeTimeMS = builder.maxConnectionLifeTimeMS;
        this.maxConnectionIdleTimeMS = builder.maxConnectionIdleTimeMS;
        this.maintenanceInitialDelayMS = builder.maintenanceInitialDelayMS;
        this.maintenanceFrequencyMS = builder.maintenanceFrequencyMS;
    }

    @NotThreadSafe
    public static class Builder {
        private int maxSize = 100;
        private int minSize;
        private int maxWaitQueueSize = 500;
        private long maxWaitTimeMS = 120000L;
        private long maxConnectionLifeTimeMS;
        private long maxConnectionIdleTimeMS;
        private long maintenanceInitialDelayMS;
        private long maintenanceFrequencyMS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public Builder maxWaitQueueSize(int maxWaitQueueSize) {
            this.maxWaitQueueSize = maxWaitQueueSize;
            return this;
        }

        public Builder maxWaitTime(long maxWaitTime, TimeUnit timeUnit) {
            this.maxWaitTimeMS = TimeUnit.MILLISECONDS.convert(maxWaitTime, timeUnit);
            return this;
        }

        public Builder maxConnectionLifeTime(long maxConnectionLifeTime, TimeUnit timeUnit) {
            this.maxConnectionLifeTimeMS = TimeUnit.MILLISECONDS.convert(maxConnectionLifeTime, timeUnit);
            return this;
        }

        public Builder maxConnectionIdleTime(long maxConnectionIdleTime, TimeUnit timeUnit) {
            this.maxConnectionIdleTimeMS = TimeUnit.MILLISECONDS.convert(maxConnectionIdleTime, timeUnit);
            return this;
        }

        public Builder maintenanceInitialDelay(long maintenanceInitialDelay, TimeUnit timeUnit) {
            this.maintenanceInitialDelayMS = TimeUnit.MILLISECONDS.convert(maintenanceInitialDelay, timeUnit);
            return this;
        }

        public Builder maintenanceFrequency(long maintenanceFrequency, TimeUnit timeUnit) {
            this.maintenanceFrequencyMS = TimeUnit.MILLISECONDS.convert(maintenanceFrequency, timeUnit);
            return this;
        }

        public ConnectionPoolSettings build() {
            return new ConnectionPoolSettings(this);
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            if (connectionString.getMaxConnectionPoolSize() != null) {
                this.maxSize(connectionString.getMaxConnectionPoolSize());
            }
            if (connectionString.getMinConnectionPoolSize() != null) {
                this.minSize(connectionString.getMinConnectionPoolSize());
            }
            if (connectionString.getMaxWaitTime() != null) {
                this.maxWaitTime(connectionString.getMaxWaitTime().intValue(), TimeUnit.MILLISECONDS);
            }
            if (connectionString.getMaxConnectionIdleTime() != null) {
                this.maxConnectionIdleTime(connectionString.getMaxConnectionIdleTime().intValue(), TimeUnit.MILLISECONDS);
            }
            if (connectionString.getMaxConnectionLifeTime() != null) {
                this.maxConnectionLifeTime(connectionString.getMaxConnectionLifeTime().intValue(), TimeUnit.MILLISECONDS);
            }
            if (connectionString.getThreadsAllowedToBlockForConnectionMultiplier() != null) {
                this.maxWaitQueueSize(connectionString.getThreadsAllowedToBlockForConnectionMultiplier() * this.maxSize);
            }
            return this;
        }
    }
}

