/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.SQLException;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.JdbcCallParseInfo;
import org.postgresql.core.Parser;
import org.postgresql.core.Query;
import org.postgresql.jdbc.CallableQueryKey;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PgStatement;
import org.postgresql.util.LruCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private final int serverVersionNum;
    private final PgConnection connection;

    public CachedQueryCreateAction(PgConnection connection, int serverVersionNum) {
        this.connection = connection;
        this.serverVersionNum = serverVersionNum;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean outParmBeforeFunc;
        boolean isFunction;
        String sql = key == null ? null : key.toString();
        String parsedSql = PgStatement.replaceProcessing(sql, true, this.connection.getStandardConformingStrings());
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.connection.getStandardConformingStrings(), this.serverVersionNum, this.connection.getProtocolVersion());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
            outParmBeforeFunc = callInfo.isOutParmBeforeFunc();
        } else {
            isFunction = false;
            outParmBeforeFunc = false;
        }
        Query query = this.connection.getQueryExecutor().createParameterizedQuery(parsedSql);
        return new CachedQuery(key, query, isFunction, outParmBeforeFunc);
    }
}

