# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AppliedScopeProperties(_serialization.Model):
    """Properties specific to applied scope type. Not required if not applicable.

    :ivar tenant_id: Tenant ID where the benefit is applied.
    :vartype tenant_id: str
    :ivar management_group_id: Fully-qualified identifier of the management group where the benefit
     must be applied.
    :vartype management_group_id: str
    :ivar subscription_id: Fully-qualified identifier of the subscription.
    :vartype subscription_id: str
    :ivar resource_group_id: Fully-qualified identifier of the resource group.
    :vartype resource_group_id: str
    :ivar display_name: Display name.
    :vartype display_name: str
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "management_group_id": {"key": "managementGroupId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group_id": {"key": "resourceGroupId", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        management_group_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group_id: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: Tenant ID where the benefit is applied.
        :paramtype tenant_id: str
        :keyword management_group_id: Fully-qualified identifier of the management group where the
         benefit must be applied.
        :paramtype management_group_id: str
        :keyword subscription_id: Fully-qualified identifier of the subscription.
        :paramtype subscription_id: str
        :keyword resource_group_id: Fully-qualified identifier of the resource group.
        :paramtype resource_group_id: str
        :keyword display_name: Display name.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.management_group_id = management_group_id
        self.subscription_id = subscription_id
        self.resource_group_id = resource_group_id
        self.display_name = display_name


class BillingInformation(_serialization.Model):
    """billing information.

    :ivar billing_currency_total_paid_amount:
    :vartype billing_currency_total_paid_amount: ~azure.mgmt.billingbenefits.models.Price
    :ivar billing_currency_prorated_amount:
    :vartype billing_currency_prorated_amount: ~azure.mgmt.billingbenefits.models.Price
    :ivar billing_currency_remaining_commitment_amount:
    :vartype billing_currency_remaining_commitment_amount: ~azure.mgmt.billingbenefits.models.Price
    """

    _attribute_map = {
        "billing_currency_total_paid_amount": {"key": "billingCurrencyTotalPaidAmount", "type": "Price"},
        "billing_currency_prorated_amount": {"key": "billingCurrencyProratedAmount", "type": "Price"},
        "billing_currency_remaining_commitment_amount": {
            "key": "billingCurrencyRemainingCommitmentAmount",
            "type": "Price",
        },
    }

    def __init__(
        self,
        *,
        billing_currency_total_paid_amount: Optional["_models.Price"] = None,
        billing_currency_prorated_amount: Optional["_models.Price"] = None,
        billing_currency_remaining_commitment_amount: Optional["_models.Price"] = None,
        **kwargs
    ):
        """
        :keyword billing_currency_total_paid_amount:
        :paramtype billing_currency_total_paid_amount: ~azure.mgmt.billingbenefits.models.Price
        :keyword billing_currency_prorated_amount:
        :paramtype billing_currency_prorated_amount: ~azure.mgmt.billingbenefits.models.Price
        :keyword billing_currency_remaining_commitment_amount:
        :paramtype billing_currency_remaining_commitment_amount:
         ~azure.mgmt.billingbenefits.models.Price
        """
        super().__init__(**kwargs)
        self.billing_currency_total_paid_amount = billing_currency_total_paid_amount
        self.billing_currency_prorated_amount = billing_currency_prorated_amount
        self.billing_currency_remaining_commitment_amount = billing_currency_remaining_commitment_amount


class BillingPlanInformation(_serialization.Model):
    """Information describing the type of billing plan for this savings plan.

    :ivar pricing_currency_total: Amount of money to be paid for the Order. Tax is not included.
    :vartype pricing_currency_total: ~azure.mgmt.billingbenefits.models.Price
    :ivar start_date: Date when the billing plan has started.
    :vartype start_date: ~datetime.date
    :ivar next_payment_due_date: For recurring billing plans, indicates the date when next payment
     will be processed. Null when total is paid off.
    :vartype next_payment_due_date: ~datetime.date
    :ivar transactions:
    :vartype transactions: list[~azure.mgmt.billingbenefits.models.PaymentDetail]
    """

    _attribute_map = {
        "pricing_currency_total": {"key": "pricingCurrencyTotal", "type": "Price"},
        "start_date": {"key": "startDate", "type": "date"},
        "next_payment_due_date": {"key": "nextPaymentDueDate", "type": "date"},
        "transactions": {"key": "transactions", "type": "[PaymentDetail]"},
    }

    def __init__(
        self,
        *,
        pricing_currency_total: Optional["_models.Price"] = None,
        start_date: Optional[datetime.date] = None,
        next_payment_due_date: Optional[datetime.date] = None,
        transactions: Optional[List["_models.PaymentDetail"]] = None,
        **kwargs
    ):
        """
        :keyword pricing_currency_total: Amount of money to be paid for the Order. Tax is not included.
        :paramtype pricing_currency_total: ~azure.mgmt.billingbenefits.models.Price
        :keyword start_date: Date when the billing plan has started.
        :paramtype start_date: ~datetime.date
        :keyword next_payment_due_date: For recurring billing plans, indicates the date when next
         payment will be processed. Null when total is paid off.
        :paramtype next_payment_due_date: ~datetime.date
        :keyword transactions:
        :paramtype transactions: list[~azure.mgmt.billingbenefits.models.PaymentDetail]
        """
        super().__init__(**kwargs)
        self.pricing_currency_total = pricing_currency_total
        self.start_date = start_date
        self.next_payment_due_date = next_payment_due_date
        self.transactions = transactions


class Price(_serialization.Model):
    """Price.

    :ivar currency_code: The ISO 4217 3-letter currency code for the currency used by this purchase
     record.
    :vartype currency_code: str
    :ivar amount:
    :vartype amount: float
    """

    _attribute_map = {
        "currency_code": {"key": "currencyCode", "type": "str"},
        "amount": {"key": "amount", "type": "float"},
    }

    def __init__(self, *, currency_code: Optional[str] = None, amount: Optional[float] = None, **kwargs):
        """
        :keyword currency_code: The ISO 4217 3-letter currency code for the currency used by this
         purchase record.
        :paramtype currency_code: str
        :keyword amount:
        :paramtype amount: float
        """
        super().__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class Commitment(Price):
    """Commitment towards the benefit.

    :ivar currency_code: The ISO 4217 3-letter currency code for the currency used by this purchase
     record.
    :vartype currency_code: str
    :ivar amount:
    :vartype amount: float
    :ivar grain: Commitment grain. "Hourly"
    :vartype grain: str or ~azure.mgmt.billingbenefits.models.CommitmentGrain
    """

    _attribute_map = {
        "currency_code": {"key": "currencyCode", "type": "str"},
        "amount": {"key": "amount", "type": "float"},
        "grain": {"key": "grain", "type": "str"},
    }

    def __init__(
        self,
        *,
        currency_code: Optional[str] = None,
        amount: Optional[float] = None,
        grain: Optional[Union[str, "_models.CommitmentGrain"]] = None,
        **kwargs
    ):
        """
        :keyword currency_code: The ISO 4217 3-letter currency code for the currency used by this
         purchase record.
        :paramtype currency_code: str
        :keyword amount:
        :paramtype amount: float
        :keyword grain: Commitment grain. "Hourly"
        :paramtype grain: str or ~azure.mgmt.billingbenefits.models.CommitmentGrain
        """
        super().__init__(currency_code=currency_code, amount=amount, **kwargs)
        self.grain = grain


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.billingbenefits.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.billingbenefits.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.billingbenefits.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.billingbenefits.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExtendedStatusInfo(_serialization.Model):
    """ExtendedStatusInfo.

    :ivar status_code: Status code providing additional information.
    :vartype status_code: str
    :ivar message: The message giving detailed information about the status code.
    :vartype message: str
    """

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, status_code: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword status_code: Status code providing additional information.
        :paramtype status_code: str
        :keyword message: The message giving detailed information about the status code.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.status_code = status_code
        self.message = message


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.billingbenefits.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.billingbenefits.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.billingbenefits.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.billingbenefits.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.billingbenefits.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationResultError(_serialization.Model):
    """Required if status == failed or status == canceled.

    :ivar code: Required if status == failed or status == cancelled. If status == failed, provide
     an invariant error code used for error troubleshooting, aggregation, and analysis.
    :vartype code: str
    :ivar message: Required if status == failed. Localized. If status == failed, provide an
     actionable error message indicating what error occurred, and what the user can do to address
     the issue.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword code: Required if status == failed or status == cancelled. If status == failed,
         provide an invariant error code used for error troubleshooting, aggregation, and analysis.
        :paramtype code: str
        :keyword message: Required if status == failed. Localized. If status == failed, provide an
         actionable error message indicating what error occurred, and what the user can do to address
         the issue.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class PaymentDetail(_serialization.Model):
    """Information about payment related to a savings plan order.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar due_date: Date when the payment needs to be done.
    :vartype due_date: ~datetime.date
    :ivar payment_date: Date when the transaction is completed. Is null when it is scheduled.
    :vartype payment_date: ~datetime.date
    :ivar pricing_currency_total: Amount in pricing currency. Tax not included.
    :vartype pricing_currency_total: ~azure.mgmt.billingbenefits.models.Price
    :ivar billing_currency_total: Amount charged in Billing currency. Tax not included. Is null for
     future payments.
    :vartype billing_currency_total: ~azure.mgmt.billingbenefits.models.Price
    :ivar status: Describes whether the payment is completed, failed, cancelled or scheduled in the
     future. Known values are: "Succeeded", "Failed", "Scheduled", and "Cancelled".
    :vartype status: str or ~azure.mgmt.billingbenefits.models.PaymentStatus
    :ivar extended_status_info:
    :vartype extended_status_info: ~azure.mgmt.billingbenefits.models.ExtendedStatusInfo
    :ivar billing_account: Billing account.
    :vartype billing_account: str
    """

    _validation = {
        "extended_status_info": {"readonly": True},
    }

    _attribute_map = {
        "due_date": {"key": "dueDate", "type": "date"},
        "payment_date": {"key": "paymentDate", "type": "date"},
        "pricing_currency_total": {"key": "pricingCurrencyTotal", "type": "Price"},
        "billing_currency_total": {"key": "billingCurrencyTotal", "type": "Price"},
        "status": {"key": "status", "type": "str"},
        "extended_status_info": {"key": "extendedStatusInfo", "type": "ExtendedStatusInfo"},
        "billing_account": {"key": "billingAccount", "type": "str"},
    }

    def __init__(
        self,
        *,
        due_date: Optional[datetime.date] = None,
        payment_date: Optional[datetime.date] = None,
        pricing_currency_total: Optional["_models.Price"] = None,
        billing_currency_total: Optional["_models.Price"] = None,
        status: Optional[Union[str, "_models.PaymentStatus"]] = None,
        billing_account: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword due_date: Date when the payment needs to be done.
        :paramtype due_date: ~datetime.date
        :keyword payment_date: Date when the transaction is completed. Is null when it is scheduled.
        :paramtype payment_date: ~datetime.date
        :keyword pricing_currency_total: Amount in pricing currency. Tax not included.
        :paramtype pricing_currency_total: ~azure.mgmt.billingbenefits.models.Price
        :keyword billing_currency_total: Amount charged in Billing currency. Tax not included. Is null
         for future payments.
        :paramtype billing_currency_total: ~azure.mgmt.billingbenefits.models.Price
        :keyword status: Describes whether the payment is completed, failed, cancelled or scheduled in
         the future. Known values are: "Succeeded", "Failed", "Scheduled", and "Cancelled".
        :paramtype status: str or ~azure.mgmt.billingbenefits.models.PaymentStatus
        :keyword billing_account: Billing account.
        :paramtype billing_account: str
        """
        super().__init__(**kwargs)
        self.due_date = due_date
        self.payment_date = payment_date
        self.pricing_currency_total = pricing_currency_total
        self.billing_currency_total = billing_currency_total
        self.status = status
        self.extended_status_info = None
        self.billing_account = billing_account


class PricingCurrencyTotal(Price):
    """PricingCurrencyTotal.

    :ivar currency_code: The ISO 4217 3-letter currency code for the currency used by this purchase
     record.
    :vartype currency_code: str
    :ivar amount:
    :vartype amount: float
    :ivar duration: Represents either billing plan or savings plan term in ISO 8601 format. Known
     values are: "P1M", "P1Y", and "P3Y".
    :vartype duration: str or ~azure.mgmt.billingbenefits.models.PricingCurrencyDuration
    """

    _attribute_map = {
        "currency_code": {"key": "currencyCode", "type": "str"},
        "amount": {"key": "amount", "type": "float"},
        "duration": {"key": "duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        currency_code: Optional[str] = None,
        amount: Optional[float] = None,
        duration: Optional[Union[str, "_models.PricingCurrencyDuration"]] = None,
        **kwargs
    ):
        """
        :keyword currency_code: The ISO 4217 3-letter currency code for the currency used by this
         purchase record.
        :paramtype currency_code: str
        :keyword amount:
        :paramtype amount: float
        :keyword duration: Represents either billing plan or savings plan term in ISO 8601 format.
         Known values are: "P1M", "P1Y", and "P3Y".
        :paramtype duration: str or ~azure.mgmt.billingbenefits.models.PricingCurrencyDuration
        """
        super().__init__(currency_code=currency_code, amount=amount, **kwargs)
        self.duration = duration


class PurchaseRequest(_serialization.Model):
    """PurchaseRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: The SKU to be applied for this resource.
    :vartype sku: ~azure.mgmt.billingbenefits.models.Sku
    :ivar display_name: Friendly name of the savings plan.
    :vartype display_name: str
    :ivar billing_scope_id: Subscription that will be charged for purchasing the benefit.
    :vartype billing_scope_id: str
    :ivar term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
     "P5Y".
    :vartype term: str or ~azure.mgmt.billingbenefits.models.Term
    :ivar billing_plan: Represents the billing plan in ISO 8601 format. Required only for monthly
     billing plans. "P1M"
    :vartype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
    :ivar applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared", and
     "ManagementGroup".
    :vartype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
    :ivar commitment: Commitment towards the benefit.
    :vartype commitment: ~azure.mgmt.billingbenefits.models.Commitment
    :ivar effective_date_time: DateTime of the savings plan starts providing benefit from.
    :vartype effective_date_time: ~datetime.datetime
    :ivar renew: Setting this to true will automatically purchase a new benefit on the expiration
     date time.
    :vartype renew: bool
    :ivar applied_scope_properties: Properties specific to applied scope type. Not required if not
     applicable.
    :vartype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
    """

    _validation = {
        "effective_date_time": {"readonly": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "billing_scope_id": {"key": "properties.billingScopeId", "type": "str"},
        "term": {"key": "properties.term", "type": "str"},
        "billing_plan": {"key": "properties.billingPlan", "type": "str"},
        "applied_scope_type": {"key": "properties.appliedScopeType", "type": "str"},
        "commitment": {"key": "properties.commitment", "type": "Commitment"},
        "effective_date_time": {"key": "properties.effectiveDateTime", "type": "iso-8601"},
        "renew": {"key": "properties.renew", "type": "bool"},
        "applied_scope_properties": {"key": "properties.appliedScopeProperties", "type": "AppliedScopeProperties"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        display_name: Optional[str] = None,
        billing_scope_id: Optional[str] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        billing_plan: Optional[Union[str, "_models.BillingPlan"]] = None,
        applied_scope_type: Optional[Union[str, "_models.AppliedScopeType"]] = None,
        commitment: Optional["_models.Commitment"] = None,
        renew: bool = False,
        applied_scope_properties: Optional["_models.AppliedScopeProperties"] = None,
        **kwargs
    ):
        """
        :keyword sku: The SKU to be applied for this resource.
        :paramtype sku: ~azure.mgmt.billingbenefits.models.Sku
        :keyword display_name: Friendly name of the savings plan.
        :paramtype display_name: str
        :keyword billing_scope_id: Subscription that will be charged for purchasing the benefit.
        :paramtype billing_scope_id: str
        :keyword term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
         "P5Y".
        :paramtype term: str or ~azure.mgmt.billingbenefits.models.Term
        :keyword billing_plan: Represents the billing plan in ISO 8601 format. Required only for
         monthly billing plans. "P1M"
        :paramtype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
        :keyword applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared",
         and "ManagementGroup".
        :paramtype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
        :keyword commitment: Commitment towards the benefit.
        :paramtype commitment: ~azure.mgmt.billingbenefits.models.Commitment
        :keyword renew: Setting this to true will automatically purchase a new benefit on the
         expiration date time.
        :paramtype renew: bool
        :keyword applied_scope_properties: Properties specific to applied scope type. Not required if
         not applicable.
        :paramtype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.display_name = display_name
        self.billing_scope_id = billing_scope_id
        self.term = term
        self.billing_plan = billing_plan
        self.applied_scope_type = applied_scope_type
        self.commitment = commitment
        self.effective_date_time = None
        self.renew = renew
        self.applied_scope_properties = applied_scope_properties


class RenewProperties(_serialization.Model):
    """RenewProperties.

    :ivar purchase_properties:
    :vartype purchase_properties: ~azure.mgmt.billingbenefits.models.PurchaseRequest
    """

    _attribute_map = {
        "purchase_properties": {"key": "purchaseProperties", "type": "PurchaseRequest"},
    }

    def __init__(self, *, purchase_properties: Optional["_models.PurchaseRequest"] = None, **kwargs):
        """
        :keyword purchase_properties:
        :paramtype purchase_properties: ~azure.mgmt.billingbenefits.models.PurchaseRequest
        """
        super().__init__(**kwargs)
        self.purchase_properties = purchase_properties


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.billingbenefits.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ReservationOrderAliasRequest(Resource):  # pylint: disable=too-many-instance-attributes
    """Reservation order alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.billingbenefits.models.SystemData
    :ivar sku: Reservation order SKU. Required.
    :vartype sku: ~azure.mgmt.billingbenefits.models.Sku
    :ivar location: The Azure Region where the reservation benefits are applied to.
    :vartype location: str
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar billing_scope_id: Subscription that will be charged for purchasing the benefit.
    :vartype billing_scope_id: str
    :ivar term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
     "P5Y".
    :vartype term: str or ~azure.mgmt.billingbenefits.models.Term
    :ivar billing_plan: Represents the billing plan in ISO 8601 format. Required only for monthly
     billing plans. "P1M"
    :vartype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
    :ivar applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared", and
     "ManagementGroup".
    :vartype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
    :ivar applied_scope_properties: Properties specific to applied scope type. Not required if not
     applicable.
    :vartype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
    :ivar quantity: Total Quantity of the SKUs purchased in the Reservation.
    :vartype quantity: int
    :ivar renew: Setting this to true will automatically purchase a new benefit on the expiration
     date time.
    :vartype renew: bool
    :ivar reserved_resource_type: The type of the resource that is being reserved. Known values
     are: "VirtualMachines", "SqlDatabases", "SuseLinux", "CosmosDb", "RedHat", "SqlDataWarehouse",
     "VMwareCloudSimple", "RedHatOsa", "Databricks", "AppService", "ManagedDisk", "BlockBlob",
     "RedisCache", "AzureDataExplorer", "MySql", "MariaDb", "PostgreSql", "DedicatedHost",
     "SapHana", "SqlAzureHybridBenefit", "AVS", "DataFactory", "NetAppStorage", "AzureFiles",
     "SqlEdge", and "VirtualMachineSoftware".
    :vartype reserved_resource_type: str or ~azure.mgmt.billingbenefits.models.ReservedResourceType
    :ivar review_date_time: This is the date-time when the Azure Hybrid Benefit needs to be
     reviewed.
    :vartype review_date_time: ~datetime.datetime
    :ivar reserved_resource_properties: Properties specific to each reserved resource type. Not
     required if not applicable.
    :vartype reserved_resource_properties:
     ~azure.mgmt.billingbenefits.models.ReservationOrderAliasRequestPropertiesReservedResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "quantity": {"minimum": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "location": {"key": "location", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "billing_scope_id": {"key": "properties.billingScopeId", "type": "str"},
        "term": {"key": "properties.term", "type": "str"},
        "billing_plan": {"key": "properties.billingPlan", "type": "str"},
        "applied_scope_type": {"key": "properties.appliedScopeType", "type": "str"},
        "applied_scope_properties": {"key": "properties.appliedScopeProperties", "type": "AppliedScopeProperties"},
        "quantity": {"key": "properties.quantity", "type": "int"},
        "renew": {"key": "properties.renew", "type": "bool"},
        "reserved_resource_type": {"key": "properties.reservedResourceType", "type": "str"},
        "review_date_time": {"key": "properties.reviewDateTime", "type": "iso-8601"},
        "reserved_resource_properties": {
            "key": "properties.reservedResourceProperties",
            "type": "ReservationOrderAliasRequestPropertiesReservedResourceProperties",
        },
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        location: Optional[str] = None,
        display_name: Optional[str] = None,
        billing_scope_id: Optional[str] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        billing_plan: Optional[Union[str, "_models.BillingPlan"]] = None,
        applied_scope_type: Optional[Union[str, "_models.AppliedScopeType"]] = None,
        applied_scope_properties: Optional["_models.AppliedScopeProperties"] = None,
        quantity: Optional[int] = None,
        renew: bool = False,
        reserved_resource_type: Optional[Union[str, "_models.ReservedResourceType"]] = None,
        review_date_time: Optional[datetime.datetime] = None,
        reserved_resource_properties: Optional[
            "_models.ReservationOrderAliasRequestPropertiesReservedResourceProperties"
        ] = None,
        **kwargs
    ):
        """
        :keyword sku: Reservation order SKU. Required.
        :paramtype sku: ~azure.mgmt.billingbenefits.models.Sku
        :keyword location: The Azure Region where the reservation benefits are applied to.
        :paramtype location: str
        :keyword display_name: Display name.
        :paramtype display_name: str
        :keyword billing_scope_id: Subscription that will be charged for purchasing the benefit.
        :paramtype billing_scope_id: str
        :keyword term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
         "P5Y".
        :paramtype term: str or ~azure.mgmt.billingbenefits.models.Term
        :keyword billing_plan: Represents the billing plan in ISO 8601 format. Required only for
         monthly billing plans. "P1M"
        :paramtype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
        :keyword applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared",
         and "ManagementGroup".
        :paramtype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
        :keyword applied_scope_properties: Properties specific to applied scope type. Not required if
         not applicable.
        :paramtype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
        :keyword quantity: Total Quantity of the SKUs purchased in the Reservation.
        :paramtype quantity: int
        :keyword renew: Setting this to true will automatically purchase a new benefit on the
         expiration date time.
        :paramtype renew: bool
        :keyword reserved_resource_type: The type of the resource that is being reserved. Known values
         are: "VirtualMachines", "SqlDatabases", "SuseLinux", "CosmosDb", "RedHat", "SqlDataWarehouse",
         "VMwareCloudSimple", "RedHatOsa", "Databricks", "AppService", "ManagedDisk", "BlockBlob",
         "RedisCache", "AzureDataExplorer", "MySql", "MariaDb", "PostgreSql", "DedicatedHost",
         "SapHana", "SqlAzureHybridBenefit", "AVS", "DataFactory", "NetAppStorage", "AzureFiles",
         "SqlEdge", and "VirtualMachineSoftware".
        :paramtype reserved_resource_type: str or
         ~azure.mgmt.billingbenefits.models.ReservedResourceType
        :keyword review_date_time: This is the date-time when the Azure Hybrid Benefit needs to be
         reviewed.
        :paramtype review_date_time: ~datetime.datetime
        :keyword reserved_resource_properties: Properties specific to each reserved resource type. Not
         required if not applicable.
        :paramtype reserved_resource_properties:
         ~azure.mgmt.billingbenefits.models.ReservationOrderAliasRequestPropertiesReservedResourceProperties
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.display_name = display_name
        self.billing_scope_id = billing_scope_id
        self.term = term
        self.billing_plan = billing_plan
        self.applied_scope_type = applied_scope_type
        self.applied_scope_properties = applied_scope_properties
        self.quantity = quantity
        self.renew = renew
        self.reserved_resource_type = reserved_resource_type
        self.review_date_time = review_date_time
        self.reserved_resource_properties = reserved_resource_properties


class ReservationOrderAliasRequestPropertiesReservedResourceProperties(_serialization.Model):
    """Properties specific to each reserved resource type. Not required if not applicable.

    :ivar instance_flexibility: Turning this on will apply the reservation discount to other VMs in
     the same VM size group. Known values are: "On" and "Off".
    :vartype instance_flexibility: str or ~azure.mgmt.billingbenefits.models.InstanceFlexibility
    """

    _attribute_map = {
        "instance_flexibility": {"key": "instanceFlexibility", "type": "str"},
    }

    def __init__(self, *, instance_flexibility: Optional[Union[str, "_models.InstanceFlexibility"]] = None, **kwargs):
        """
        :keyword instance_flexibility: Turning this on will apply the reservation discount to other VMs
         in the same VM size group. Known values are: "On" and "Off".
        :paramtype instance_flexibility: str or ~azure.mgmt.billingbenefits.models.InstanceFlexibility
        """
        super().__init__(**kwargs)
        self.instance_flexibility = instance_flexibility


class ReservationOrderAliasResponse(Resource):  # pylint: disable=too-many-instance-attributes
    """Reservation order alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.billingbenefits.models.SystemData
    :ivar sku: Reservation order SKU. Required.
    :vartype sku: ~azure.mgmt.billingbenefits.models.Sku
    :ivar location: The Azure Region where the reserved resource lives.
    :vartype location: str
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar reservation_order_id: Identifier of the reservation order created.
    :vartype reservation_order_id: str
    :ivar provisioning_state: Provisioning state. Known values are: "Creating", "PendingBilling",
     "ConfirmedBilling", "Created", "Succeeded", "Cancelled", "Expired", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.billingbenefits.models.ProvisioningState
    :ivar billing_scope_id: Subscription that will be charged for purchasing the benefit.
    :vartype billing_scope_id: str
    :ivar term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
     "P5Y".
    :vartype term: str or ~azure.mgmt.billingbenefits.models.Term
    :ivar billing_plan: Represents the billing plan in ISO 8601 format. Required only for monthly
     billing plans. "P1M"
    :vartype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
    :ivar applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared", and
     "ManagementGroup".
    :vartype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
    :ivar applied_scope_properties: Properties specific to applied scope type. Not required if not
     applicable.
    :vartype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
    :ivar quantity: Total Quantity of the SKUs purchased in the Reservation.
    :vartype quantity: int
    :ivar renew: Setting this to true will automatically purchase a new benefit on the expiration
     date time.
    :vartype renew: bool
    :ivar reserved_resource_type: The type of the resource that is being reserved. Known values
     are: "VirtualMachines", "SqlDatabases", "SuseLinux", "CosmosDb", "RedHat", "SqlDataWarehouse",
     "VMwareCloudSimple", "RedHatOsa", "Databricks", "AppService", "ManagedDisk", "BlockBlob",
     "RedisCache", "AzureDataExplorer", "MySql", "MariaDb", "PostgreSql", "DedicatedHost",
     "SapHana", "SqlAzureHybridBenefit", "AVS", "DataFactory", "NetAppStorage", "AzureFiles",
     "SqlEdge", and "VirtualMachineSoftware".
    :vartype reserved_resource_type: str or ~azure.mgmt.billingbenefits.models.ReservedResourceType
    :ivar review_date_time: This is the date-time when the Reservation needs to be reviewed.
    :vartype review_date_time: ~datetime.datetime
    :ivar reserved_resource_properties: Properties specific to each reserved resource type. Not
     required if not applicable.
    :vartype reserved_resource_properties:
     ~azure.mgmt.billingbenefits.models.ReservationOrderAliasResponsePropertiesReservedResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "reservation_order_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "location": {"key": "location", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "reservation_order_id": {"key": "properties.reservationOrderId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "billing_scope_id": {"key": "properties.billingScopeId", "type": "str"},
        "term": {"key": "properties.term", "type": "str"},
        "billing_plan": {"key": "properties.billingPlan", "type": "str"},
        "applied_scope_type": {"key": "properties.appliedScopeType", "type": "str"},
        "applied_scope_properties": {"key": "properties.appliedScopeProperties", "type": "AppliedScopeProperties"},
        "quantity": {"key": "properties.quantity", "type": "int"},
        "renew": {"key": "properties.renew", "type": "bool"},
        "reserved_resource_type": {"key": "properties.reservedResourceType", "type": "str"},
        "review_date_time": {"key": "properties.reviewDateTime", "type": "iso-8601"},
        "reserved_resource_properties": {
            "key": "properties.reservedResourceProperties",
            "type": "ReservationOrderAliasResponsePropertiesReservedResourceProperties",
        },
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        location: Optional[str] = None,
        display_name: Optional[str] = None,
        billing_scope_id: Optional[str] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        billing_plan: Optional[Union[str, "_models.BillingPlan"]] = None,
        applied_scope_type: Optional[Union[str, "_models.AppliedScopeType"]] = None,
        applied_scope_properties: Optional["_models.AppliedScopeProperties"] = None,
        quantity: Optional[int] = None,
        renew: bool = False,
        reserved_resource_type: Optional[Union[str, "_models.ReservedResourceType"]] = None,
        review_date_time: Optional[datetime.datetime] = None,
        reserved_resource_properties: Optional[
            "_models.ReservationOrderAliasResponsePropertiesReservedResourceProperties"
        ] = None,
        **kwargs
    ):
        """
        :keyword sku: Reservation order SKU. Required.
        :paramtype sku: ~azure.mgmt.billingbenefits.models.Sku
        :keyword location: The Azure Region where the reserved resource lives.
        :paramtype location: str
        :keyword display_name: Display name.
        :paramtype display_name: str
        :keyword billing_scope_id: Subscription that will be charged for purchasing the benefit.
        :paramtype billing_scope_id: str
        :keyword term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
         "P5Y".
        :paramtype term: str or ~azure.mgmt.billingbenefits.models.Term
        :keyword billing_plan: Represents the billing plan in ISO 8601 format. Required only for
         monthly billing plans. "P1M"
        :paramtype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
        :keyword applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared",
         and "ManagementGroup".
        :paramtype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
        :keyword applied_scope_properties: Properties specific to applied scope type. Not required if
         not applicable.
        :paramtype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
        :keyword quantity: Total Quantity of the SKUs purchased in the Reservation.
        :paramtype quantity: int
        :keyword renew: Setting this to true will automatically purchase a new benefit on the
         expiration date time.
        :paramtype renew: bool
        :keyword reserved_resource_type: The type of the resource that is being reserved. Known values
         are: "VirtualMachines", "SqlDatabases", "SuseLinux", "CosmosDb", "RedHat", "SqlDataWarehouse",
         "VMwareCloudSimple", "RedHatOsa", "Databricks", "AppService", "ManagedDisk", "BlockBlob",
         "RedisCache", "AzureDataExplorer", "MySql", "MariaDb", "PostgreSql", "DedicatedHost",
         "SapHana", "SqlAzureHybridBenefit", "AVS", "DataFactory", "NetAppStorage", "AzureFiles",
         "SqlEdge", and "VirtualMachineSoftware".
        :paramtype reserved_resource_type: str or
         ~azure.mgmt.billingbenefits.models.ReservedResourceType
        :keyword review_date_time: This is the date-time when the Reservation needs to be reviewed.
        :paramtype review_date_time: ~datetime.datetime
        :keyword reserved_resource_properties: Properties specific to each reserved resource type. Not
         required if not applicable.
        :paramtype reserved_resource_properties:
         ~azure.mgmt.billingbenefits.models.ReservationOrderAliasResponsePropertiesReservedResourceProperties
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.display_name = display_name
        self.reservation_order_id = None
        self.provisioning_state = None
        self.billing_scope_id = billing_scope_id
        self.term = term
        self.billing_plan = billing_plan
        self.applied_scope_type = applied_scope_type
        self.applied_scope_properties = applied_scope_properties
        self.quantity = quantity
        self.renew = renew
        self.reserved_resource_type = reserved_resource_type
        self.review_date_time = review_date_time
        self.reserved_resource_properties = reserved_resource_properties


class ReservationOrderAliasResponsePropertiesReservedResourceProperties(_serialization.Model):
    """Properties specific to each reserved resource type. Not required if not applicable.

    :ivar instance_flexibility: Turning this on will apply the reservation discount to other VMs in
     the same VM size group. Known values are: "On" and "Off".
    :vartype instance_flexibility: str or ~azure.mgmt.billingbenefits.models.InstanceFlexibility
    """

    _attribute_map = {
        "instance_flexibility": {"key": "instanceFlexibility", "type": "str"},
    }

    def __init__(self, *, instance_flexibility: Optional[Union[str, "_models.InstanceFlexibility"]] = None, **kwargs):
        """
        :keyword instance_flexibility: Turning this on will apply the reservation discount to other VMs
         in the same VM size group. Known values are: "On" and "Off".
        :paramtype instance_flexibility: str or ~azure.mgmt.billingbenefits.models.InstanceFlexibility
        """
        super().__init__(**kwargs)
        self.instance_flexibility = instance_flexibility


class RoleAssignmentEntity(_serialization.Model):
    """Role assignment entity.

    :ivar id: Role assignment entity id.
    :vartype id: str
    :ivar name: Role assignment entity name.
    :vartype name: str
    :ivar principal_id: Principal Id.
    :vartype principal_id: str
    :ivar role_definition_id: Role definition id.
    :vartype role_definition_id: str
    :ivar scope: Scope of the role assignment entity.
    :vartype scope: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "principal_id": {"key": "properties.principalId", "type": "str"},
        "role_definition_id": {"key": "properties.roleDefinitionId", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        scope: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Role assignment entity id.
        :paramtype id: str
        :keyword name: Role assignment entity name.
        :paramtype name: str
        :keyword principal_id: Principal Id.
        :paramtype principal_id: str
        :keyword role_definition_id: Role definition id.
        :paramtype role_definition_id: str
        :keyword scope: Scope of the role assignment entity.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.scope = scope


class SavingsPlanModel(Resource):  # pylint: disable=too-many-instance-attributes
    """Savings plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.billingbenefits.models.SystemData
    :ivar sku: Savings plan SKU. Required.
    :vartype sku: ~azure.mgmt.billingbenefits.models.Sku
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar provisioning_state: Provisioning state. Known values are: "Creating", "PendingBilling",
     "ConfirmedBilling", "Created", "Succeeded", "Cancelled", "Expired", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.billingbenefits.models.ProvisioningState
    :ivar display_provisioning_state: The provisioning state of the savings plan for display, e.g.
     Succeeded.
    :vartype display_provisioning_state: str
    :ivar billing_scope_id: Subscription that will be charged for purchasing the benefit.
    :vartype billing_scope_id: str
    :ivar billing_profile_id: Fully-qualified identifier of the billing profile where the savings
     plan is applied. Present only for Field-led or Customer-led customers.
    :vartype billing_profile_id: str
    :ivar customer_id: Fully-qualified identifier of the customer where the savings plan is
     applied. Present only for Partner-led customers.
    :vartype customer_id: str
    :ivar billing_account_id: Fully-qualified identifier of the billing account where the savings
     plan is applied. Present only for Enterprise Agreement customers.
    :vartype billing_account_id: str
    :ivar term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
     "P5Y".
    :vartype term: str or ~azure.mgmt.billingbenefits.models.Term
    :ivar billing_plan: Represents the billing plan in ISO 8601 format. Required only for monthly
     billing plans. "P1M"
    :vartype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
    :ivar applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared", and
     "ManagementGroup".
    :vartype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
    :ivar user_friendly_applied_scope_type: The applied scope type of the savings plan for display,
     e.g. Shared.
    :vartype user_friendly_applied_scope_type: str
    :ivar applied_scope_properties: Properties specific to applied scope type. Not required if not
     applicable.
    :vartype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
    :ivar commitment: Commitment towards the benefit.
    :vartype commitment: ~azure.mgmt.billingbenefits.models.Commitment
    :ivar effective_date_time: DateTime of the savings plan starts providing benefit from.
    :vartype effective_date_time: ~datetime.datetime
    :ivar expiry_date_time: Expiry date time.
    :vartype expiry_date_time: ~datetime.datetime
    :ivar purchase_date_time: Date time when the savings plan was purchased.
    :vartype purchase_date_time: ~datetime.datetime
    :ivar benefit_start_time: This is the DateTime when the savings plan benefit started.
    :vartype benefit_start_time: ~datetime.datetime
    :ivar extended_status_info:
    :vartype extended_status_info: ~azure.mgmt.billingbenefits.models.ExtendedStatusInfo
    :ivar renew: Setting this to true will automatically purchase a new benefit on the expiration
     date time.
    :vartype renew: bool
    :ivar utilization: Savings plan utilization.
    :vartype utilization: ~azure.mgmt.billingbenefits.models.Utilization
    :ivar renew_source: SavingsPlan Id of the SavingsPlan from which this SavingsPlan is renewed.
    :vartype renew_source: str
    :ivar renew_destination: SavingsPlan Id of the SavingsPlan which is purchased because of renew.
    :vartype renew_destination: str
    :ivar renew_properties:
    :vartype renew_properties: ~azure.mgmt.billingbenefits.models.RenewProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "provisioning_state": {"readonly": True},
        "display_provisioning_state": {"readonly": True},
        "billing_profile_id": {"readonly": True},
        "customer_id": {"readonly": True},
        "billing_account_id": {"readonly": True},
        "user_friendly_applied_scope_type": {"readonly": True},
        "effective_date_time": {"readonly": True},
        "expiry_date_time": {"readonly": True},
        "purchase_date_time": {"readonly": True},
        "extended_status_info": {"readonly": True},
        "utilization": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "display_provisioning_state": {"key": "properties.displayProvisioningState", "type": "str"},
        "billing_scope_id": {"key": "properties.billingScopeId", "type": "str"},
        "billing_profile_id": {"key": "properties.billingProfileId", "type": "str"},
        "customer_id": {"key": "properties.customerId", "type": "str"},
        "billing_account_id": {"key": "properties.billingAccountId", "type": "str"},
        "term": {"key": "properties.term", "type": "str"},
        "billing_plan": {"key": "properties.billingPlan", "type": "str"},
        "applied_scope_type": {"key": "properties.appliedScopeType", "type": "str"},
        "user_friendly_applied_scope_type": {"key": "properties.userFriendlyAppliedScopeType", "type": "str"},
        "applied_scope_properties": {"key": "properties.appliedScopeProperties", "type": "AppliedScopeProperties"},
        "commitment": {"key": "properties.commitment", "type": "Commitment"},
        "effective_date_time": {"key": "properties.effectiveDateTime", "type": "iso-8601"},
        "expiry_date_time": {"key": "properties.expiryDateTime", "type": "iso-8601"},
        "purchase_date_time": {"key": "properties.purchaseDateTime", "type": "iso-8601"},
        "benefit_start_time": {"key": "properties.benefitStartTime", "type": "iso-8601"},
        "extended_status_info": {"key": "properties.extendedStatusInfo", "type": "ExtendedStatusInfo"},
        "renew": {"key": "properties.renew", "type": "bool"},
        "utilization": {"key": "properties.utilization", "type": "Utilization"},
        "renew_source": {"key": "properties.renewSource", "type": "str"},
        "renew_destination": {"key": "properties.renewDestination", "type": "str"},
        "renew_properties": {"key": "properties.renewProperties", "type": "RenewProperties"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        sku: "_models.Sku",
        display_name: Optional[str] = None,
        billing_scope_id: Optional[str] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        billing_plan: Optional[Union[str, "_models.BillingPlan"]] = None,
        applied_scope_type: Optional[Union[str, "_models.AppliedScopeType"]] = None,
        applied_scope_properties: Optional["_models.AppliedScopeProperties"] = None,
        commitment: Optional["_models.Commitment"] = None,
        benefit_start_time: Optional[datetime.datetime] = None,
        renew: bool = False,
        renew_source: Optional[str] = None,
        renew_destination: Optional[str] = None,
        renew_properties: Optional["_models.RenewProperties"] = None,
        **kwargs
    ):
        """
        :keyword sku: Savings plan SKU. Required.
        :paramtype sku: ~azure.mgmt.billingbenefits.models.Sku
        :keyword display_name: Display name.
        :paramtype display_name: str
        :keyword billing_scope_id: Subscription that will be charged for purchasing the benefit.
        :paramtype billing_scope_id: str
        :keyword term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
         "P5Y".
        :paramtype term: str or ~azure.mgmt.billingbenefits.models.Term
        :keyword billing_plan: Represents the billing plan in ISO 8601 format. Required only for
         monthly billing plans. "P1M"
        :paramtype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
        :keyword applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared",
         and "ManagementGroup".
        :paramtype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
        :keyword applied_scope_properties: Properties specific to applied scope type. Not required if
         not applicable.
        :paramtype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
        :keyword commitment: Commitment towards the benefit.
        :paramtype commitment: ~azure.mgmt.billingbenefits.models.Commitment
        :keyword benefit_start_time: This is the DateTime when the savings plan benefit started.
        :paramtype benefit_start_time: ~datetime.datetime
        :keyword renew: Setting this to true will automatically purchase a new benefit on the
         expiration date time.
        :paramtype renew: bool
        :keyword renew_source: SavingsPlan Id of the SavingsPlan from which this SavingsPlan is
         renewed.
        :paramtype renew_source: str
        :keyword renew_destination: SavingsPlan Id of the SavingsPlan which is purchased because of
         renew.
        :paramtype renew_destination: str
        :keyword renew_properties:
        :paramtype renew_properties: ~azure.mgmt.billingbenefits.models.RenewProperties
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.display_name = display_name
        self.provisioning_state = None
        self.display_provisioning_state = None
        self.billing_scope_id = billing_scope_id
        self.billing_profile_id = None
        self.customer_id = None
        self.billing_account_id = None
        self.term = term
        self.billing_plan = billing_plan
        self.applied_scope_type = applied_scope_type
        self.user_friendly_applied_scope_type = None
        self.applied_scope_properties = applied_scope_properties
        self.commitment = commitment
        self.effective_date_time = None
        self.expiry_date_time = None
        self.purchase_date_time = None
        self.benefit_start_time = benefit_start_time
        self.extended_status_info = None
        self.renew = renew
        self.utilization = None
        self.renew_source = renew_source
        self.renew_destination = renew_destination
        self.renew_properties = renew_properties


class SavingsPlanModelList(_serialization.Model):
    """SavingsPlanModelList.

    :ivar value:
    :vartype value: list[~azure.mgmt.billingbenefits.models.SavingsPlanModel]
    :ivar next_link: Url to get the next page.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SavingsPlanModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SavingsPlanModel"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.billingbenefits.models.SavingsPlanModel]
        :keyword next_link: Url to get the next page.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SavingsPlanModelListResult(_serialization.Model):
    """SavingsPlanModelListResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of savings plans.
    :vartype value: list[~azure.mgmt.billingbenefits.models.SavingsPlanModel]
    :ivar next_link: Url to get the next page.
    :vartype next_link: str
    :ivar additional_properties: The roll out count summary of the savings plans.
    :vartype additional_properties: list[~azure.mgmt.billingbenefits.models.SavingsPlanSummary]
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
        "additional_properties": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SavingsPlanModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
        "additional_properties": {"key": "additionalProperties", "type": "[SavingsPlanSummary]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None
        self.additional_properties = None


class SavingsPlanOrderAliasModel(Resource):  # pylint: disable=too-many-instance-attributes
    """Savings plan order alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.billingbenefits.models.SystemData
    :ivar sku: Savings plan SKU. Required.
    :vartype sku: ~azure.mgmt.billingbenefits.models.Sku
    :ivar kind: Resource provider kind.
    :vartype kind: str
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar savings_plan_order_id: Identifier of the savings plan created.
    :vartype savings_plan_order_id: str
    :ivar provisioning_state: Provisioning state. Known values are: "Creating", "PendingBilling",
     "ConfirmedBilling", "Created", "Succeeded", "Cancelled", "Expired", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.billingbenefits.models.ProvisioningState
    :ivar billing_scope_id: Subscription that will be charged for purchasing the benefit.
    :vartype billing_scope_id: str
    :ivar term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
     "P5Y".
    :vartype term: str or ~azure.mgmt.billingbenefits.models.Term
    :ivar billing_plan: Represents the billing plan in ISO 8601 format. Required only for monthly
     billing plans. "P1M"
    :vartype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
    :ivar applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared", and
     "ManagementGroup".
    :vartype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
    :ivar applied_scope_properties: Properties specific to applied scope type. Not required if not
     applicable.
    :vartype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
    :ivar commitment: Commitment towards the benefit.
    :vartype commitment: ~azure.mgmt.billingbenefits.models.Commitment
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "savings_plan_order_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "kind": {"key": "kind", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "savings_plan_order_id": {"key": "properties.savingsPlanOrderId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "billing_scope_id": {"key": "properties.billingScopeId", "type": "str"},
        "term": {"key": "properties.term", "type": "str"},
        "billing_plan": {"key": "properties.billingPlan", "type": "str"},
        "applied_scope_type": {"key": "properties.appliedScopeType", "type": "str"},
        "applied_scope_properties": {"key": "properties.appliedScopeProperties", "type": "AppliedScopeProperties"},
        "commitment": {"key": "properties.commitment", "type": "Commitment"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        kind: Optional[str] = None,
        display_name: Optional[str] = None,
        billing_scope_id: Optional[str] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        billing_plan: Optional[Union[str, "_models.BillingPlan"]] = None,
        applied_scope_type: Optional[Union[str, "_models.AppliedScopeType"]] = None,
        applied_scope_properties: Optional["_models.AppliedScopeProperties"] = None,
        commitment: Optional["_models.Commitment"] = None,
        **kwargs
    ):
        """
        :keyword sku: Savings plan SKU. Required.
        :paramtype sku: ~azure.mgmt.billingbenefits.models.Sku
        :keyword kind: Resource provider kind.
        :paramtype kind: str
        :keyword display_name: Display name.
        :paramtype display_name: str
        :keyword billing_scope_id: Subscription that will be charged for purchasing the benefit.
        :paramtype billing_scope_id: str
        :keyword term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
         "P5Y".
        :paramtype term: str or ~azure.mgmt.billingbenefits.models.Term
        :keyword billing_plan: Represents the billing plan in ISO 8601 format. Required only for
         monthly billing plans. "P1M"
        :paramtype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
        :keyword applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared",
         and "ManagementGroup".
        :paramtype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
        :keyword applied_scope_properties: Properties specific to applied scope type. Not required if
         not applicable.
        :paramtype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
        :keyword commitment: Commitment towards the benefit.
        :paramtype commitment: ~azure.mgmt.billingbenefits.models.Commitment
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.kind = kind
        self.display_name = display_name
        self.savings_plan_order_id = None
        self.provisioning_state = None
        self.billing_scope_id = billing_scope_id
        self.term = term
        self.billing_plan = billing_plan
        self.applied_scope_type = applied_scope_type
        self.applied_scope_properties = applied_scope_properties
        self.commitment = commitment


class SavingsPlanOrderModel(Resource):  # pylint: disable=too-many-instance-attributes
    """Savings plan order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.billingbenefits.models.SystemData
    :ivar sku: Savings plan SKU. Required.
    :vartype sku: ~azure.mgmt.billingbenefits.models.Sku
    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar provisioning_state: Provisioning state. Known values are: "Creating", "PendingBilling",
     "ConfirmedBilling", "Created", "Succeeded", "Cancelled", "Expired", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.billingbenefits.models.ProvisioningState
    :ivar billing_scope_id: Subscription that will be charged for purchasing the benefit.
    :vartype billing_scope_id: str
    :ivar billing_profile_id: Fully-qualified identifier of the billing profile where the savings
     plan is applied. Present only for Field-led or Customer-led customers.
    :vartype billing_profile_id: str
    :ivar customer_id: Fully-qualified identifier of the customer where the savings plan is
     applied. Present only for Partner-led customers.
    :vartype customer_id: str
    :ivar billing_account_id: Fully-qualified identifier of the billing account where the savings
     plan is applied. Present only for Enterprise Agreement customers.
    :vartype billing_account_id: str
    :ivar term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
     "P5Y".
    :vartype term: str or ~azure.mgmt.billingbenefits.models.Term
    :ivar billing_plan: Represents the billing plan in ISO 8601 format. Required only for monthly
     billing plans. "P1M"
    :vartype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
    :ivar expiry_date_time: Expiry date time.
    :vartype expiry_date_time: ~datetime.datetime
    :ivar benefit_start_time: This is the DateTime when the savings plan benefit started.
    :vartype benefit_start_time: ~datetime.datetime
    :ivar plan_information: Information describing the type of billing plan for this savings plan.
    :vartype plan_information: ~azure.mgmt.billingbenefits.models.BillingPlanInformation
    :ivar savings_plans:
    :vartype savings_plans: list[str]
    :ivar extended_status_info:
    :vartype extended_status_info: ~azure.mgmt.billingbenefits.models.ExtendedStatusInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "sku": {"required": True},
        "provisioning_state": {"readonly": True},
        "billing_profile_id": {"readonly": True},
        "customer_id": {"readonly": True},
        "billing_account_id": {"readonly": True},
        "expiry_date_time": {"readonly": True},
        "extended_status_info": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "Sku"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "billing_scope_id": {"key": "properties.billingScopeId", "type": "str"},
        "billing_profile_id": {"key": "properties.billingProfileId", "type": "str"},
        "customer_id": {"key": "properties.customerId", "type": "str"},
        "billing_account_id": {"key": "properties.billingAccountId", "type": "str"},
        "term": {"key": "properties.term", "type": "str"},
        "billing_plan": {"key": "properties.billingPlan", "type": "str"},
        "expiry_date_time": {"key": "properties.expiryDateTime", "type": "iso-8601"},
        "benefit_start_time": {"key": "properties.benefitStartTime", "type": "iso-8601"},
        "plan_information": {"key": "properties.planInformation", "type": "BillingPlanInformation"},
        "savings_plans": {"key": "properties.savingsPlans", "type": "[str]"},
        "extended_status_info": {"key": "properties.extendedStatusInfo", "type": "ExtendedStatusInfo"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        display_name: Optional[str] = None,
        billing_scope_id: Optional[str] = None,
        term: Optional[Union[str, "_models.Term"]] = None,
        billing_plan: Optional[Union[str, "_models.BillingPlan"]] = None,
        benefit_start_time: Optional[datetime.datetime] = None,
        plan_information: Optional["_models.BillingPlanInformation"] = None,
        savings_plans: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword sku: Savings plan SKU. Required.
        :paramtype sku: ~azure.mgmt.billingbenefits.models.Sku
        :keyword display_name: Display name.
        :paramtype display_name: str
        :keyword billing_scope_id: Subscription that will be charged for purchasing the benefit.
        :paramtype billing_scope_id: str
        :keyword term: Represent benefit term in ISO 8601 format. Known values are: "P1Y", "P3Y", and
         "P5Y".
        :paramtype term: str or ~azure.mgmt.billingbenefits.models.Term
        :keyword billing_plan: Represents the billing plan in ISO 8601 format. Required only for
         monthly billing plans. "P1M"
        :paramtype billing_plan: str or ~azure.mgmt.billingbenefits.models.BillingPlan
        :keyword benefit_start_time: This is the DateTime when the savings plan benefit started.
        :paramtype benefit_start_time: ~datetime.datetime
        :keyword plan_information: Information describing the type of billing plan for this savings
         plan.
        :paramtype plan_information: ~azure.mgmt.billingbenefits.models.BillingPlanInformation
        :keyword savings_plans:
        :paramtype savings_plans: list[str]
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.display_name = display_name
        self.provisioning_state = None
        self.billing_scope_id = billing_scope_id
        self.billing_profile_id = None
        self.customer_id = None
        self.billing_account_id = None
        self.term = term
        self.billing_plan = billing_plan
        self.expiry_date_time = None
        self.benefit_start_time = benefit_start_time
        self.plan_information = plan_information
        self.savings_plans = savings_plans
        self.extended_status_info = None


class SavingsPlanOrderModelList(_serialization.Model):
    """SavingsPlanOrderModelList.

    :ivar value:
    :vartype value: list[~azure.mgmt.billingbenefits.models.SavingsPlanOrderModel]
    :ivar next_link: Url to get the next page.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SavingsPlanOrderModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SavingsPlanOrderModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.billingbenefits.models.SavingsPlanOrderModel]
        :keyword next_link: Url to get the next page.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SavingsPlanPurchaseValidateRequest(_serialization.Model):
    """SavingsPlanPurchaseValidateRequest.

    :ivar benefits:
    :vartype benefits: list[~azure.mgmt.billingbenefits.models.SavingsPlanOrderAliasModel]
    """

    _attribute_map = {
        "benefits": {"key": "benefits", "type": "[SavingsPlanOrderAliasModel]"},
    }

    def __init__(self, *, benefits: Optional[List["_models.SavingsPlanOrderAliasModel"]] = None, **kwargs):
        """
        :keyword benefits:
        :paramtype benefits: list[~azure.mgmt.billingbenefits.models.SavingsPlanOrderAliasModel]
        """
        super().__init__(**kwargs)
        self.benefits = benefits


class SavingsPlanSummary(_serialization.Model):
    """Savings plans list summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: This property has value 'summary'.
    :vartype name: str
    :ivar value: The roll up count summary of savings plans in each state.
    :vartype value: ~azure.mgmt.billingbenefits.models.SavingsPlanSummaryCount
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "SavingsPlanSummaryCount"},
    }

    def __init__(self, *, value: Optional["_models.SavingsPlanSummaryCount"] = None, **kwargs):
        """
        :keyword value: The roll up count summary of savings plans in each state.
        :paramtype value: ~azure.mgmt.billingbenefits.models.SavingsPlanSummaryCount
        """
        super().__init__(**kwargs)
        self.name = None
        self.value = value


class SavingsPlanSummaryCount(_serialization.Model):
    """The roll up count summary of savings plans in each state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar succeeded_count: The number of savings plans in Succeeded state.
    :vartype succeeded_count: float
    :ivar failed_count: The number of savings plans in Failed state.
    :vartype failed_count: float
    :ivar expiring_count: The number of savings plans in Expiring state.
    :vartype expiring_count: float
    :ivar expired_count: The number of savings plans in Expired state.
    :vartype expired_count: float
    :ivar pending_count: The number of savings plans in Pending state.
    :vartype pending_count: float
    :ivar cancelled_count: The number of savings plans in Cancelled state.
    :vartype cancelled_count: float
    :ivar processing_count: The number of savings plans in Processing state.
    :vartype processing_count: float
    :ivar no_benefit_count: The number of savings plans in No Benefit state.
    :vartype no_benefit_count: float
    :ivar warning_count: The number of savings plans in Warning state.
    :vartype warning_count: float
    """

    _validation = {
        "succeeded_count": {"readonly": True},
        "failed_count": {"readonly": True},
        "expiring_count": {"readonly": True},
        "expired_count": {"readonly": True},
        "pending_count": {"readonly": True},
        "cancelled_count": {"readonly": True},
        "processing_count": {"readonly": True},
        "no_benefit_count": {"readonly": True},
        "warning_count": {"readonly": True},
    }

    _attribute_map = {
        "succeeded_count": {"key": "succeededCount", "type": "float"},
        "failed_count": {"key": "failedCount", "type": "float"},
        "expiring_count": {"key": "expiringCount", "type": "float"},
        "expired_count": {"key": "expiredCount", "type": "float"},
        "pending_count": {"key": "pendingCount", "type": "float"},
        "cancelled_count": {"key": "cancelledCount", "type": "float"},
        "processing_count": {"key": "processingCount", "type": "float"},
        "no_benefit_count": {"key": "noBenefitCount", "type": "float"},
        "warning_count": {"key": "warningCount", "type": "float"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.succeeded_count = None
        self.failed_count = None
        self.expiring_count = None
        self.expired_count = None
        self.pending_count = None
        self.cancelled_count = None
        self.processing_count = None
        self.no_benefit_count = None
        self.warning_count = None


class SavingsPlanUpdateRequest(_serialization.Model):
    """Savings plan patch request.

    :ivar properties: Savings plan patch request.
    :vartype properties: ~azure.mgmt.billingbenefits.models.SavingsPlanUpdateRequestProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "SavingsPlanUpdateRequestProperties"},
    }

    def __init__(self, *, properties: Optional["_models.SavingsPlanUpdateRequestProperties"] = None, **kwargs):
        """
        :keyword properties: Savings plan patch request.
        :paramtype properties: ~azure.mgmt.billingbenefits.models.SavingsPlanUpdateRequestProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SavingsPlanUpdateRequestProperties(_serialization.Model):
    """Savings plan patch request.

    :ivar display_name: Display name.
    :vartype display_name: str
    :ivar applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared", and
     "ManagementGroup".
    :vartype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
    :ivar applied_scope_properties: Properties specific to applied scope type. Not required if not
     applicable.
    :vartype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
    :ivar renew: Setting this to true will automatically purchase a new benefit on the expiration
     date time.
    :vartype renew: bool
    :ivar renew_properties:
    :vartype renew_properties: ~azure.mgmt.billingbenefits.models.RenewProperties
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "applied_scope_type": {"key": "appliedScopeType", "type": "str"},
        "applied_scope_properties": {"key": "appliedScopeProperties", "type": "AppliedScopeProperties"},
        "renew": {"key": "renew", "type": "bool"},
        "renew_properties": {"key": "renewProperties", "type": "RenewProperties"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        applied_scope_type: Optional[Union[str, "_models.AppliedScopeType"]] = None,
        applied_scope_properties: Optional["_models.AppliedScopeProperties"] = None,
        renew: bool = False,
        renew_properties: Optional["_models.RenewProperties"] = None,
        **kwargs
    ):
        """
        :keyword display_name: Display name.
        :paramtype display_name: str
        :keyword applied_scope_type: Type of the Applied Scope. Known values are: "Single", "Shared",
         and "ManagementGroup".
        :paramtype applied_scope_type: str or ~azure.mgmt.billingbenefits.models.AppliedScopeType
        :keyword applied_scope_properties: Properties specific to applied scope type. Not required if
         not applicable.
        :paramtype applied_scope_properties: ~azure.mgmt.billingbenefits.models.AppliedScopeProperties
        :keyword renew: Setting this to true will automatically purchase a new benefit on the
         expiration date time.
        :paramtype renew: bool
        :keyword renew_properties:
        :paramtype renew_properties: ~azure.mgmt.billingbenefits.models.RenewProperties
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.applied_scope_type = applied_scope_type
        self.applied_scope_properties = applied_scope_properties
        self.renew = renew
        self.renew_properties = renew_properties


class SavingsPlanUpdateValidateRequest(_serialization.Model):
    """SavingsPlanUpdateValidateRequest.

    :ivar benefits:
    :vartype benefits: list[~azure.mgmt.billingbenefits.models.SavingsPlanUpdateRequestProperties]
    """

    _attribute_map = {
        "benefits": {"key": "benefits", "type": "[SavingsPlanUpdateRequestProperties]"},
    }

    def __init__(self, *, benefits: Optional[List["_models.SavingsPlanUpdateRequestProperties"]] = None, **kwargs):
        """
        :keyword benefits:
        :paramtype benefits:
         list[~azure.mgmt.billingbenefits.models.SavingsPlanUpdateRequestProperties]
        """
        super().__init__(**kwargs)
        self.benefits = benefits


class SavingsPlanValidateResponse(_serialization.Model):
    """SavingsPlanValidateResponse.

    :ivar benefits:
    :vartype benefits: list[~azure.mgmt.billingbenefits.models.SavingsPlanValidResponseProperty]
    :ivar next_link: Url to get the next page.
    :vartype next_link: str
    """

    _attribute_map = {
        "benefits": {"key": "benefits", "type": "[SavingsPlanValidResponseProperty]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        benefits: Optional[List["_models.SavingsPlanValidResponseProperty"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword benefits:
        :paramtype benefits: list[~azure.mgmt.billingbenefits.models.SavingsPlanValidResponseProperty]
        :keyword next_link: Url to get the next page.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.benefits = benefits
        self.next_link = next_link


class SavingsPlanValidResponseProperty(_serialization.Model):
    """Benefit scope response property.

    :ivar valid: Indicates if the provided input was valid.
    :vartype valid: bool
    :ivar reason_code: Failure reason code if the provided input was invalid.
    :vartype reason_code: str
    :ivar reason: Failure reason if the provided input was invalid.
    :vartype reason: str
    """

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "reason_code": {"key": "reasonCode", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self, *, valid: Optional[bool] = None, reason_code: Optional[str] = None, reason: Optional[str] = None, **kwargs
    ):
        """
        :keyword valid: Indicates if the provided input was valid.
        :paramtype valid: bool
        :keyword reason_code: Failure reason code if the provided input was invalid.
        :paramtype reason_code: str
        :keyword reason: Failure reason if the provided input was invalid.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.valid = valid
        self.reason_code = reason_code
        self.reason = reason


class Sku(_serialization.Model):
    """The SKU to be applied for this resource.

    :ivar name: Name of the SKU to be applied.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the SKU to be applied.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.billingbenefits.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.billingbenefits.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.billingbenefits.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.billingbenefits.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Utilization(_serialization.Model):
    """Savings plan utilization.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar trend: The number of days trend for a savings plan.
    :vartype trend: str
    :ivar aggregates: The array of aggregates of a savings plan's utilization.
    :vartype aggregates: list[~azure.mgmt.billingbenefits.models.UtilizationAggregates]
    """

    _validation = {
        "trend": {"readonly": True},
    }

    _attribute_map = {
        "trend": {"key": "trend", "type": "str"},
        "aggregates": {"key": "aggregates", "type": "[UtilizationAggregates]"},
    }

    def __init__(self, *, aggregates: Optional[List["_models.UtilizationAggregates"]] = None, **kwargs):
        """
        :keyword aggregates: The array of aggregates of a savings plan's utilization.
        :paramtype aggregates: list[~azure.mgmt.billingbenefits.models.UtilizationAggregates]
        """
        super().__init__(**kwargs)
        self.trend = None
        self.aggregates = aggregates


class UtilizationAggregates(_serialization.Model):
    """The aggregate values of savings plan utilization.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar grain: The grain of the aggregate.
    :vartype grain: float
    :ivar grain_unit: The grain unit of the aggregate.
    :vartype grain_unit: str
    :ivar value: The aggregate value.
    :vartype value: float
    :ivar value_unit: The aggregate value unit.
    :vartype value_unit: str
    """

    _validation = {
        "grain": {"readonly": True},
        "grain_unit": {"readonly": True},
        "value": {"readonly": True},
        "value_unit": {"readonly": True},
    }

    _attribute_map = {
        "grain": {"key": "grain", "type": "float"},
        "grain_unit": {"key": "grainUnit", "type": "str"},
        "value": {"key": "value", "type": "float"},
        "value_unit": {"key": "valueUnit", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.grain = None
        self.grain_unit = None
        self.value = None
        self.value_unit = None
