/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.util.Iterator;
import java.util.List;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.Assignment;
import org.chefproject.core.AssignmentContent;
import org.chefproject.core.AssignmentContentEdit;
import org.chefproject.core.AssignmentEdit;
import org.chefproject.core.AssignmentSubmission;
import org.chefproject.core.AssignmentSubmissionEdit;
import org.chefproject.core.User;
import org.chefproject.exception.AssignmentContentNotEmptyException;
import org.chefproject.exception.AssignmentNotEmptyException;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.generic.GenericAssignmentService;
import org.chefproject.util.Blob;
import org.w3c.dom.Element;

public class AssignmentService {
    protected static GenericAssignmentService M_service = null;

    protected static void find() {
        if (M_service == null && (M_service = (GenericAssignmentService)((Object)TurbineServices.getInstance().getService(GenericAssignmentService.SERVICE_NAME))) == null) {
            Log.warn("chef", "AssignmentService.find: missing service: " + GenericAssignmentService.SERVICE_NAME);
        }
    }

    public static GenericAssignmentService getInstance() {
        AssignmentService.find();
        return M_service;
    }

    public static boolean allowAddAssignment(String context) {
        AssignmentService.find();
        return M_service.allowAddAssignment(context);
    }

    public static boolean allowGetAssignment(String assignmentReference) {
        AssignmentService.find();
        return M_service.allowGetAssignment(assignmentReference);
    }

    public static boolean allowUpdateAssignment(String assignmentReference) {
        AssignmentService.find();
        return M_service.allowUpdateAssignment(assignmentReference);
    }

    public static boolean allowRemoveAssignment(String assignmentReference) {
        AssignmentService.find();
        return M_service.allowRemoveAssignment(assignmentReference);
    }

    public static boolean allowAddAssignmentContent(String context) {
        AssignmentService.find();
        return M_service.allowAddAssignmentContent(context);
    }

    public static boolean allowGetAssignmentContent(String contentReference) {
        AssignmentService.find();
        return M_service.allowGetAssignmentContent(contentReference);
    }

    public static boolean allowUpdateAssignmentContent(String contentReference) {
        AssignmentService.find();
        return M_service.allowUpdateAssignmentContent(contentReference);
    }

    public static boolean allowRemoveAssignmentContent(String contentReference) {
        AssignmentService.find();
        return M_service.allowRemoveAssignmentContent(contentReference);
    }

    public static boolean allowAddSubmission(String context) {
        AssignmentService.find();
        return M_service.allowAddSubmission(context);
    }

    public static List allowAddSubmissionUsers(String assignmentReference) {
        AssignmentService.find();
        return M_service.allowAddSubmissionUsers(assignmentReference);
    }

    public static boolean allowGetSubmission(String submissionReference) {
        AssignmentService.find();
        return M_service.allowGetSubmission(submissionReference);
    }

    public static boolean allowUpdateSubmission(String submissionReference) {
        AssignmentService.find();
        return M_service.allowUpdateSubmission(submissionReference);
    }

    public static boolean allowRemoveSubmission(String submissionReference) {
        AssignmentService.find();
        return M_service.allowRemoveSubmission(submissionReference);
    }

    public static AssignmentEdit addAssignment(String context) throws PermissionException {
        AssignmentService.find();
        return M_service.addAssignment(context);
    }

    public static AssignmentEdit mergeAssignment(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        AssignmentService.find();
        return M_service.mergeAssignment(el);
    }

    public static AssignmentEdit addDuplicateAssignment(String context, String assignmentReference) throws IdInvalidException, IdUnusedException, IdUsedException, PermissionException {
        AssignmentService.find();
        return M_service.addDuplicateAssignment(context, assignmentReference);
    }

    public static void removeAssignment(AssignmentEdit assignment) throws AssignmentNotEmptyException, PermissionException {
        AssignmentService.find();
        M_service.removeAssignment(assignment);
    }

    public static AssignmentEdit editAssignment(String assignmentReference) throws IdUnusedException, PermissionException, InUseException {
        AssignmentService.find();
        return M_service.editAssignment(assignmentReference);
    }

    public static void commitEdit(AssignmentEdit assignment) {
        AssignmentService.find();
        M_service.commitEdit(assignment);
    }

    public static void cancelEdit(AssignmentEdit assignment) {
        AssignmentService.find();
        M_service.cancelEdit(assignment);
    }

    public static AssignmentContentEdit addAssignmentContent(String context) throws PermissionException {
        AssignmentService.find();
        return M_service.addAssignmentContent(context);
    }

    public static AssignmentContentEdit mergeAssignmentContent(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        AssignmentService.find();
        return M_service.mergeAssignmentContent(el);
    }

    public static AssignmentContent addDuplicateAssignmentContent(String context, String contentReference) throws IdInvalidException, IdUnusedException, PermissionException {
        AssignmentService.find();
        return M_service.addDuplicateAssignmentContent(context, contentReference);
    }

    public static void removeAssignmentContent(AssignmentContentEdit content) throws AssignmentContentNotEmptyException, PermissionException {
        if (content.inUse()) {
            throw new AssignmentContentNotEmptyException();
        }
        AssignmentService.find();
        M_service.removeAssignmentContent(content);
    }

    public static AssignmentContentEdit editAssignmentContent(String contentReference) throws IdUnusedException, PermissionException, InUseException {
        AssignmentService.find();
        return M_service.editAssignmentContent(contentReference);
    }

    public static void commitEdit(AssignmentContentEdit content) {
        AssignmentService.find();
        M_service.commitEdit(content);
    }

    public static void cancelEdit(AssignmentContentEdit content) {
        AssignmentService.find();
        M_service.cancelEdit(content);
    }

    public static AssignmentSubmissionEdit addSubmission(String context, String assignmentId) throws PermissionException {
        AssignmentService.find();
        return M_service.addSubmission(context, assignmentId);
    }

    public static AssignmentSubmissionEdit mergeSubmission(Element el) throws IdInvalidException, IdUsedException, PermissionException {
        return M_service.mergeSubmission(el);
    }

    public static void removeSubmission(AssignmentSubmissionEdit submission) throws PermissionException {
        AssignmentService.find();
        M_service.removeSubmission(submission);
    }

    public static AssignmentSubmissionEdit editSubmission(String submissionReference) throws IdUnusedException, PermissionException, InUseException {
        AssignmentService.find();
        return M_service.editSubmission(submissionReference);
    }

    public static void commitEdit(AssignmentSubmissionEdit submission) {
        AssignmentService.find();
        M_service.commitEdit(submission);
    }

    public static void cancelEdit(AssignmentSubmissionEdit submission) {
        AssignmentService.find();
        M_service.cancelEdit(submission);
    }

    public static AssignmentContent getAssignmentContent(String contentReference) throws IdUnusedException, PermissionException {
        AssignmentService.find();
        return M_service.getAssignmentContent(contentReference);
    }

    public static Iterator getAssignmentContents(User owner) {
        AssignmentService.find();
        return M_service.getAssignmentContents(owner);
    }

    public static Assignment getAssignment(String assignmentReference) throws IdUnusedException, PermissionException {
        AssignmentService.find();
        return M_service.getAssignment(assignmentReference);
    }

    public static Iterator getAssignments(AssignmentContent content) {
        AssignmentService.find();
        return M_service.getAssignments(content);
    }

    public static Iterator getAssignmentsForContext(String context) {
        AssignmentService.find();
        return M_service.getAssignmentsForContext(context);
    }

    public static AssignmentSubmission getSubmission(String assignmentReference, User person) throws IdUnusedException, PermissionException {
        AssignmentService.find();
        return M_service.getSubmission(assignmentReference, person);
    }

    public static Iterator getSubmissions(Assignment assignment) {
        AssignmentService.find();
        return M_service.getSubmissions(assignment);
    }

    public static AssignmentSubmission getSubmission(String submissionReference) throws IdUnusedException, PermissionException {
        AssignmentService.find();
        return M_service.getSubmission(submissionReference);
    }

    public static Blob getGradesSpreadsheet(String ref) throws IdUnusedException, PermissionException {
        AssignmentService.find();
        return M_service.getGradesSpreadsheet(ref);
    }

    public static Blob getSubmissionsZip(String ref) throws IdUnusedException, PermissionException {
        AssignmentService.find();
        return M_service.getSubmissionsZip(ref);
    }

    public static String assignmentReference(String context, String id) {
        AssignmentService.find();
        return M_service.assignmentReference(context, id);
    }

    public static String contentReference(String context, String id) {
        AssignmentService.find();
        return M_service.contentReference(context, id);
    }

    public static String submissionReference(String context, String id, String assignmentId) {
        AssignmentService.find();
        return M_service.submissionReference(context, id, assignmentId);
    }

    public static String gradesSpreadsheetReference(String context, String assignmentId) {
        AssignmentService.find();
        return M_service.gradesSpreadsheetReference(context, assignmentId);
    }

    public static String submissionsZipReference(String context, String assignmentId) {
        AssignmentService.find();
        return M_service.submissionsZipReference(context, assignmentId);
    }
}

