// Copyright 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for RSA SSA (Signature Schemes with Appendix) using PKCS1-v1_5
// encoding (https://tools.ietf.org/html/rfc8017#section-8.2).

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v3.21.12
// source: rsa_ssa_pkcs1.proto

package rsa_ssa_pkcs1_go_proto

import (
	common_go_proto "github.com/tink-crypto/tink-go/v2/proto/common_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RsaSsaPkcs1Params struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Hash function used in computing hash of the signing message
	// (see https://tools.ietf.org/html/rfc8017#section-9.2).
	// Required.
	HashType      common_go_proto.HashType `protobuf:"varint,1,opt,name=hash_type,json=hashType,proto3,enum=google.crypto.tink.HashType" json:"hash_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RsaSsaPkcs1Params) Reset() {
	*x = RsaSsaPkcs1Params{}
	mi := &file_rsa_ssa_pkcs1_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RsaSsaPkcs1Params) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPkcs1Params) ProtoMessage() {}

func (x *RsaSsaPkcs1Params) ProtoReflect() protoreflect.Message {
	mi := &file_rsa_ssa_pkcs1_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPkcs1Params.ProtoReflect.Descriptor instead.
func (*RsaSsaPkcs1Params) Descriptor() ([]byte, []int) {
	return file_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{0}
}

func (x *RsaSsaPkcs1Params) GetHashType() common_go_proto.HashType {
	if x != nil {
		return x.HashType
	}
	return common_go_proto.HashType(0)
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPkcs1PublicKey
type RsaSsaPkcs1PublicKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params *RsaSsaPkcs1Params `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// Modulus.
	// Unsigned big integer in bigendian representation.
	N []byte `protobuf:"bytes,3,opt,name=n,proto3" json:"n,omitempty"`
	// Public exponent.
	// Unsigned big integer in bigendian representation.
	E             []byte `protobuf:"bytes,4,opt,name=e,proto3" json:"e,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RsaSsaPkcs1PublicKey) Reset() {
	*x = RsaSsaPkcs1PublicKey{}
	mi := &file_rsa_ssa_pkcs1_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RsaSsaPkcs1PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPkcs1PublicKey) ProtoMessage() {}

func (x *RsaSsaPkcs1PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_rsa_ssa_pkcs1_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPkcs1PublicKey.ProtoReflect.Descriptor instead.
func (*RsaSsaPkcs1PublicKey) Descriptor() ([]byte, []int) {
	return file_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{1}
}

func (x *RsaSsaPkcs1PublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *RsaSsaPkcs1PublicKey) GetParams() *RsaSsaPkcs1Params {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *RsaSsaPkcs1PublicKey) GetN() []byte {
	if x != nil {
		return x.N
	}
	return nil
}

func (x *RsaSsaPkcs1PublicKey) GetE() []byte {
	if x != nil {
		return x.E
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPkcs1PrivateKey
type RsaSsaPkcs1PrivateKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	PublicKey *RsaSsaPkcs1PublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Private exponent.
	// Unsigned big integer in bigendian representation.
	// Required.
	D []byte `protobuf:"bytes,3,opt,name=d,proto3" json:"d,omitempty"`
	// The following parameters are used to optimize RSA signature computation.
	// The prime factor p of n.
	// Unsigned big integer in bigendian representation.
	// Required.
	P []byte `protobuf:"bytes,4,opt,name=p,proto3" json:"p,omitempty"`
	// The prime factor q of n.
	// Unsigned big integer in bigendian representation.
	// Required.
	Q []byte `protobuf:"bytes,5,opt,name=q,proto3" json:"q,omitempty"`
	// d mod (p - 1).
	// Unsigned big integer in bigendian representation.
	// Required.
	Dp []byte `protobuf:"bytes,6,opt,name=dp,proto3" json:"dp,omitempty"`
	// d mod (q - 1).
	// Unsigned big integer in bigendian representation.
	// Required.
	Dq []byte `protobuf:"bytes,7,opt,name=dq,proto3" json:"dq,omitempty"`
	// Chinese Remainder Theorem coefficient q^(-1) mod p.
	// Unsigned big integer in bigendian representation.
	// Required.
	Crt           []byte `protobuf:"bytes,8,opt,name=crt,proto3" json:"crt,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RsaSsaPkcs1PrivateKey) Reset() {
	*x = RsaSsaPkcs1PrivateKey{}
	mi := &file_rsa_ssa_pkcs1_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RsaSsaPkcs1PrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPkcs1PrivateKey) ProtoMessage() {}

func (x *RsaSsaPkcs1PrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_rsa_ssa_pkcs1_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPkcs1PrivateKey.ProtoReflect.Descriptor instead.
func (*RsaSsaPkcs1PrivateKey) Descriptor() ([]byte, []int) {
	return file_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{2}
}

func (x *RsaSsaPkcs1PrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *RsaSsaPkcs1PrivateKey) GetPublicKey() *RsaSsaPkcs1PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetD() []byte {
	if x != nil {
		return x.D
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetP() []byte {
	if x != nil {
		return x.P
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetQ() []byte {
	if x != nil {
		return x.Q
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetDp() []byte {
	if x != nil {
		return x.Dp
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetDq() []byte {
	if x != nil {
		return x.Dq
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetCrt() []byte {
	if x != nil {
		return x.Crt
	}
	return nil
}

type RsaSsaPkcs1KeyFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Params *RsaSsaPkcs1Params `protobuf:"bytes,1,opt,name=params,proto3" json:"params,omitempty"`
	// Required.
	ModulusSizeInBits uint32 `protobuf:"varint,2,opt,name=modulus_size_in_bits,json=modulusSizeInBits,proto3" json:"modulus_size_in_bits,omitempty"`
	// Required.
	PublicExponent []byte `protobuf:"bytes,3,opt,name=public_exponent,json=publicExponent,proto3" json:"public_exponent,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *RsaSsaPkcs1KeyFormat) Reset() {
	*x = RsaSsaPkcs1KeyFormat{}
	mi := &file_rsa_ssa_pkcs1_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RsaSsaPkcs1KeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPkcs1KeyFormat) ProtoMessage() {}

func (x *RsaSsaPkcs1KeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_rsa_ssa_pkcs1_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPkcs1KeyFormat.ProtoReflect.Descriptor instead.
func (*RsaSsaPkcs1KeyFormat) Descriptor() ([]byte, []int) {
	return file_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{3}
}

func (x *RsaSsaPkcs1KeyFormat) GetParams() *RsaSsaPkcs1Params {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *RsaSsaPkcs1KeyFormat) GetModulusSizeInBits() uint32 {
	if x != nil {
		return x.ModulusSizeInBits
	}
	return 0
}

func (x *RsaSsaPkcs1KeyFormat) GetPublicExponent() []byte {
	if x != nil {
		return x.PublicExponent
	}
	return nil
}

var File_rsa_ssa_pkcs1_proto protoreflect.FileDescriptor

const file_rsa_ssa_pkcs1_proto_rawDesc = "" +
	"\n" +
	"\x13rsa_ssa_pkcs1.proto\x12\x12google.crypto.tink\x1a\x12proto/common.proto\"N\n" +
	"\x11RsaSsaPkcs1Params\x129\n" +
	"\thash_type\x18\x01 \x01(\x0e2\x1c.google.crypto.tink.HashTypeR\bhashType\"\x8b\x01\n" +
	"\x14RsaSsaPkcs1PublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12=\n" +
	"\x06params\x18\x02 \x01(\v2%.google.crypto.tink.RsaSsaPkcs1ParamsR\x06params\x12\f\n" +
	"\x01n\x18\x03 \x01(\fR\x01n\x12\f\n" +
	"\x01e\x18\x04 \x01(\fR\x01e\"\xd6\x01\n" +
	"\x15RsaSsaPkcs1PrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12G\n" +
	"\n" +
	"public_key\x18\x02 \x01(\v2(.google.crypto.tink.RsaSsaPkcs1PublicKeyR\tpublicKey\x12\f\n" +
	"\x01d\x18\x03 \x01(\fR\x01d\x12\f\n" +
	"\x01p\x18\x04 \x01(\fR\x01p\x12\f\n" +
	"\x01q\x18\x05 \x01(\fR\x01q\x12\x0e\n" +
	"\x02dp\x18\x06 \x01(\fR\x02dp\x12\x0e\n" +
	"\x02dq\x18\a \x01(\fR\x02dq\x12\x10\n" +
	"\x03crt\x18\b \x01(\fR\x03crt\"\xaf\x01\n" +
	"\x14RsaSsaPkcs1KeyFormat\x12=\n" +
	"\x06params\x18\x01 \x01(\v2%.google.crypto.tink.RsaSsaPkcs1ParamsR\x06params\x12/\n" +
	"\x14modulus_size_in_bits\x18\x02 \x01(\rR\x11modulusSizeInBits\x12'\n" +
	"\x0fpublic_exponent\x18\x03 \x01(\fR\x0epublicExponentB`\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z>github.com/tink-crypto/tink-go/v2/proto/rsa_ssa_pkcs1_go_protob\x06proto3"

var (
	file_rsa_ssa_pkcs1_proto_rawDescOnce sync.Once
	file_rsa_ssa_pkcs1_proto_rawDescData []byte
)

func file_rsa_ssa_pkcs1_proto_rawDescGZIP() []byte {
	file_rsa_ssa_pkcs1_proto_rawDescOnce.Do(func() {
		file_rsa_ssa_pkcs1_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_rsa_ssa_pkcs1_proto_rawDesc), len(file_rsa_ssa_pkcs1_proto_rawDesc)))
	})
	return file_rsa_ssa_pkcs1_proto_rawDescData
}

var file_rsa_ssa_pkcs1_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_rsa_ssa_pkcs1_proto_goTypes = []any{
	(*RsaSsaPkcs1Params)(nil),     // 0: google.crypto.tink.RsaSsaPkcs1Params
	(*RsaSsaPkcs1PublicKey)(nil),  // 1: google.crypto.tink.RsaSsaPkcs1PublicKey
	(*RsaSsaPkcs1PrivateKey)(nil), // 2: google.crypto.tink.RsaSsaPkcs1PrivateKey
	(*RsaSsaPkcs1KeyFormat)(nil),  // 3: google.crypto.tink.RsaSsaPkcs1KeyFormat
	(common_go_proto.HashType)(0), // 4: google.crypto.tink.HashType
}
var file_rsa_ssa_pkcs1_proto_depIdxs = []int32{
	4, // 0: google.crypto.tink.RsaSsaPkcs1Params.hash_type:type_name -> google.crypto.tink.HashType
	0, // 1: google.crypto.tink.RsaSsaPkcs1PublicKey.params:type_name -> google.crypto.tink.RsaSsaPkcs1Params
	1, // 2: google.crypto.tink.RsaSsaPkcs1PrivateKey.public_key:type_name -> google.crypto.tink.RsaSsaPkcs1PublicKey
	0, // 3: google.crypto.tink.RsaSsaPkcs1KeyFormat.params:type_name -> google.crypto.tink.RsaSsaPkcs1Params
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_rsa_ssa_pkcs1_proto_init() }
func file_rsa_ssa_pkcs1_proto_init() {
	if File_rsa_ssa_pkcs1_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_rsa_ssa_pkcs1_proto_rawDesc), len(file_rsa_ssa_pkcs1_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_rsa_ssa_pkcs1_proto_goTypes,
		DependencyIndexes: file_rsa_ssa_pkcs1_proto_depIdxs,
		MessageInfos:      file_rsa_ssa_pkcs1_proto_msgTypes,
	}.Build()
	File_rsa_ssa_pkcs1_proto = out.File
	file_rsa_ssa_pkcs1_proto_goTypes = nil
	file_rsa_ssa_pkcs1_proto_depIdxs = nil
}
