//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// DevicesClient contains the methods for the Devices group.
// Don't use this type directly, use NewDevicesClient() instead.
type DevicesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDevicesClient creates a new instance of DevicesClient with the specified values.
//   - subscriptionID - The subscription id
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDevicesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DevicesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DevicesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// AuthorizeForServiceEncryptionKeyRollover - Authorizes the specified device for service data encryption key rollover.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientAuthorizeForServiceEncryptionKeyRolloverOptions contains the optional parameters for the DevicesClient.AuthorizeForServiceEncryptionKeyRollover
//     method.
func (client *DevicesClient) AuthorizeForServiceEncryptionKeyRollover(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientAuthorizeForServiceEncryptionKeyRolloverOptions) (DevicesClientAuthorizeForServiceEncryptionKeyRolloverResponse, error) {
	var err error
	const operationName = "DevicesClient.AuthorizeForServiceEncryptionKeyRollover"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.authorizeForServiceEncryptionKeyRolloverCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DevicesClientAuthorizeForServiceEncryptionKeyRolloverResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DevicesClientAuthorizeForServiceEncryptionKeyRolloverResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return DevicesClientAuthorizeForServiceEncryptionKeyRolloverResponse{}, err
	}
	return DevicesClientAuthorizeForServiceEncryptionKeyRolloverResponse{}, nil
}

// authorizeForServiceEncryptionKeyRolloverCreateRequest creates the AuthorizeForServiceEncryptionKeyRollover request.
func (client *DevicesClient) authorizeForServiceEncryptionKeyRolloverCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientAuthorizeForServiceEncryptionKeyRolloverOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/authorizeForServiceEncryptionKeyRollover"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// BeginConfigure - Complete minimal setup before using the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - The minimal properties to configure a device.
//   - options - DevicesClientBeginConfigureOptions contains the optional parameters for the DevicesClient.BeginConfigure method.
func (client *DevicesClient) BeginConfigure(ctx context.Context, resourceGroupName string, managerName string, parameters ConfigureDeviceRequest, options *DevicesClientBeginConfigureOptions) (*runtime.Poller[DevicesClientConfigureResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.configure(ctx, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DevicesClientConfigureResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DevicesClientConfigureResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Configure - Complete minimal setup before using the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DevicesClient) configure(ctx context.Context, resourceGroupName string, managerName string, parameters ConfigureDeviceRequest, options *DevicesClientBeginConfigureOptions) (*http.Response, error) {
	var err error
	const operationName = "DevicesClient.BeginConfigure"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.configureCreateRequest(ctx, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// configureCreateRequest creates the Configure request.
func (client *DevicesClient) configureCreateRequest(ctx context.Context, resourceGroupName string, managerName string, parameters ConfigureDeviceRequest, options *DevicesClientBeginConfigureOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/configureDevice"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDeactivate - Deactivates the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientBeginDeactivateOptions contains the optional parameters for the DevicesClient.BeginDeactivate method.
func (client *DevicesClient) BeginDeactivate(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeactivateOptions) (*runtime.Poller[DevicesClientDeactivateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deactivate(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DevicesClientDeactivateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DevicesClientDeactivateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Deactivate - Deactivates the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DevicesClient) deactivate(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeactivateOptions) (*http.Response, error) {
	var err error
	const operationName = "DevicesClient.BeginDeactivate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deactivateCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deactivateCreateRequest creates the Deactivate request.
func (client *DevicesClient) deactivateCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeactivateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/deactivate"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// BeginDelete - Deletes the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientBeginDeleteOptions contains the optional parameters for the DevicesClient.BeginDelete method.
func (client *DevicesClient) BeginDelete(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeleteOptions) (*runtime.Poller[DevicesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DevicesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DevicesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DevicesClient) deleteOperation(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "DevicesClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *DevicesClient) deleteCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// BeginFailover - Failovers a set of volume containers from a specified source device to a target device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - sourceDeviceName - The source device name on which failover is performed.
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - FailoverRequest containing the source device and the list of volume containers to be failed over.
//   - options - DevicesClientBeginFailoverOptions contains the optional parameters for the DevicesClient.BeginFailover method.
func (client *DevicesClient) BeginFailover(ctx context.Context, sourceDeviceName string, resourceGroupName string, managerName string, parameters FailoverRequest, options *DevicesClientBeginFailoverOptions) (*runtime.Poller[DevicesClientFailoverResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.failover(ctx, sourceDeviceName, resourceGroupName, managerName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DevicesClientFailoverResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DevicesClientFailoverResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Failover - Failovers a set of volume containers from a specified source device to a target device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DevicesClient) failover(ctx context.Context, sourceDeviceName string, resourceGroupName string, managerName string, parameters FailoverRequest, options *DevicesClientBeginFailoverOptions) (*http.Response, error) {
	var err error
	const operationName = "DevicesClient.BeginFailover"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.failoverCreateRequest(ctx, sourceDeviceName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// failoverCreateRequest creates the Failover request.
func (client *DevicesClient) failoverCreateRequest(ctx context.Context, sourceDeviceName string, resourceGroupName string, managerName string, parameters FailoverRequest, options *DevicesClientBeginFailoverOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{sourceDeviceName}/failover"
	urlPath = strings.ReplaceAll(urlPath, "{sourceDeviceName}", sourceDeviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// Get - Returns the properties of the specified device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientGetOptions contains the optional parameters for the DevicesClient.Get method.
func (client *DevicesClient) Get(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetOptions) (DevicesClientGetResponse, error) {
	var err error
	const operationName = "DevicesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DevicesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DevicesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DevicesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DevicesClient) getCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DevicesClient) getHandleResponse(resp *http.Response) (DevicesClientGetResponse, error) {
	result := DevicesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Device); err != nil {
		return DevicesClientGetResponse{}, err
	}
	return result, nil
}

// GetUpdateSummary - Returns the update summary of the specified device name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientGetUpdateSummaryOptions contains the optional parameters for the DevicesClient.GetUpdateSummary
//     method.
func (client *DevicesClient) GetUpdateSummary(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetUpdateSummaryOptions) (DevicesClientGetUpdateSummaryResponse, error) {
	var err error
	const operationName = "DevicesClient.GetUpdateSummary"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getUpdateSummaryCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return DevicesClientGetUpdateSummaryResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DevicesClientGetUpdateSummaryResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DevicesClientGetUpdateSummaryResponse{}, err
	}
	resp, err := client.getUpdateSummaryHandleResponse(httpResp)
	return resp, err
}

// getUpdateSummaryCreateRequest creates the GetUpdateSummary request.
func (client *DevicesClient) getUpdateSummaryCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientGetUpdateSummaryOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/updateSummary/default"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getUpdateSummaryHandleResponse handles the GetUpdateSummary response.
func (client *DevicesClient) getUpdateSummaryHandleResponse(resp *http.Response) (DevicesClientGetUpdateSummaryResponse, error) {
	result := DevicesClientGetUpdateSummaryResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Updates); err != nil {
		return DevicesClientGetUpdateSummaryResponse{}, err
	}
	return result, nil
}

// BeginInstallUpdates - Downloads and installs the updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientBeginInstallUpdatesOptions contains the optional parameters for the DevicesClient.BeginInstallUpdates
//     method.
func (client *DevicesClient) BeginInstallUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginInstallUpdatesOptions) (*runtime.Poller[DevicesClientInstallUpdatesResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.installUpdates(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DevicesClientInstallUpdatesResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DevicesClientInstallUpdatesResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// InstallUpdates - Downloads and installs the updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DevicesClient) installUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginInstallUpdatesOptions) (*http.Response, error) {
	var err error
	const operationName = "DevicesClient.BeginInstallUpdates"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.installUpdatesCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// installUpdatesCreateRequest creates the InstallUpdates request.
func (client *DevicesClient) installUpdatesCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginInstallUpdatesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/installUpdates"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// NewListByManagerPager - Returns the list of devices for the specified manager.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientListByManagerOptions contains the optional parameters for the DevicesClient.NewListByManagerPager
//     method.
func (client *DevicesClient) NewListByManagerPager(resourceGroupName string, managerName string, options *DevicesClientListByManagerOptions) *runtime.Pager[DevicesClientListByManagerResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListByManagerResponse]{
		More: func(page DevicesClientListByManagerResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListByManagerResponse) (DevicesClientListByManagerResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DevicesClient.NewListByManagerPager")
			req, err := client.listByManagerCreateRequest(ctx, resourceGroupName, managerName, options)
			if err != nil {
				return DevicesClientListByManagerResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return DevicesClientListByManagerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListByManagerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByManagerHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByManagerCreateRequest creates the ListByManager request.
func (client *DevicesClient) listByManagerCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *DevicesClientListByManagerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByManagerHandleResponse handles the ListByManager response.
func (client *DevicesClient) listByManagerHandleResponse(resp *http.Response) (DevicesClientListByManagerResponse, error) {
	result := DevicesClientListByManagerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeviceList); err != nil {
		return DevicesClientListByManagerResponse{}, err
	}
	return result, nil
}

// NewListFailoverSetsPager - Returns all failover sets for a given device and their eligibility for participating in a failover.
// A failover set refers to a set of volume containers that need to be failed-over as a single unit to
// maintain data integrity.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientListFailoverSetsOptions contains the optional parameters for the DevicesClient.NewListFailoverSetsPager
//     method.
func (client *DevicesClient) NewListFailoverSetsPager(deviceName string, resourceGroupName string, managerName string, options *DevicesClientListFailoverSetsOptions) *runtime.Pager[DevicesClientListFailoverSetsResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListFailoverSetsResponse]{
		More: func(page DevicesClientListFailoverSetsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListFailoverSetsResponse) (DevicesClientListFailoverSetsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DevicesClient.NewListFailoverSetsPager")
			req, err := client.listFailoverSetsCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return DevicesClientListFailoverSetsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return DevicesClientListFailoverSetsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListFailoverSetsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listFailoverSetsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listFailoverSetsCreateRequest creates the ListFailoverSets request.
func (client *DevicesClient) listFailoverSetsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientListFailoverSetsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/listFailoverSets"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFailoverSetsHandleResponse handles the ListFailoverSets response.
func (client *DevicesClient) listFailoverSetsHandleResponse(resp *http.Response) (DevicesClientListFailoverSetsResponse, error) {
	result := DevicesClientListFailoverSetsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FailoverSetsList); err != nil {
		return DevicesClientListFailoverSetsResponse{}, err
	}
	return result, nil
}

// NewListFailoverTargetsPager - Given a list of volume containers to be failed over from a source device, this method returns
// the eligibility result, as a failover target, for all devices under that resource.
//
// Generated from API version 2017-06-01
//   - sourceDeviceName - The source device name on which failover is performed.
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - ListFailoverTargetsRequest containing the list of volume containers to be failed over.
//   - options - DevicesClientListFailoverTargetsOptions contains the optional parameters for the DevicesClient.NewListFailoverTargetsPager
//     method.
func (client *DevicesClient) NewListFailoverTargetsPager(sourceDeviceName string, resourceGroupName string, managerName string, parameters ListFailoverTargetsRequest, options *DevicesClientListFailoverTargetsOptions) *runtime.Pager[DevicesClientListFailoverTargetsResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListFailoverTargetsResponse]{
		More: func(page DevicesClientListFailoverTargetsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListFailoverTargetsResponse) (DevicesClientListFailoverTargetsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DevicesClient.NewListFailoverTargetsPager")
			req, err := client.listFailoverTargetsCreateRequest(ctx, sourceDeviceName, resourceGroupName, managerName, parameters, options)
			if err != nil {
				return DevicesClientListFailoverTargetsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return DevicesClientListFailoverTargetsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListFailoverTargetsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listFailoverTargetsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listFailoverTargetsCreateRequest creates the ListFailoverTargets request.
func (client *DevicesClient) listFailoverTargetsCreateRequest(ctx context.Context, sourceDeviceName string, resourceGroupName string, managerName string, parameters ListFailoverTargetsRequest, options *DevicesClientListFailoverTargetsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{sourceDeviceName}/listFailoverTargets"
	urlPath = strings.ReplaceAll(urlPath, "{sourceDeviceName}", sourceDeviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// listFailoverTargetsHandleResponse handles the ListFailoverTargets response.
func (client *DevicesClient) listFailoverTargetsHandleResponse(resp *http.Response) (DevicesClientListFailoverTargetsResponse, error) {
	result := DevicesClientListFailoverTargetsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FailoverTargetsList); err != nil {
		return DevicesClientListFailoverTargetsResponse{}, err
	}
	return result, nil
}

// NewListMetricDefinitionPager - Gets the metric definitions for the specified device.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientListMetricDefinitionOptions contains the optional parameters for the DevicesClient.NewListMetricDefinitionPager
//     method.
func (client *DevicesClient) NewListMetricDefinitionPager(deviceName string, resourceGroupName string, managerName string, options *DevicesClientListMetricDefinitionOptions) *runtime.Pager[DevicesClientListMetricDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListMetricDefinitionResponse]{
		More: func(page DevicesClientListMetricDefinitionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListMetricDefinitionResponse) (DevicesClientListMetricDefinitionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DevicesClient.NewListMetricDefinitionPager")
			req, err := client.listMetricDefinitionCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
			if err != nil {
				return DevicesClientListMetricDefinitionResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return DevicesClientListMetricDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListMetricDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricDefinitionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMetricDefinitionCreateRequest creates the ListMetricDefinition request.
func (client *DevicesClient) listMetricDefinitionCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientListMetricDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/metricsDefinitions"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricDefinitionHandleResponse handles the ListMetricDefinition response.
func (client *DevicesClient) listMetricDefinitionHandleResponse(resp *http.Response) (DevicesClientListMetricDefinitionResponse, error) {
	result := DevicesClientListMetricDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionList); err != nil {
		return DevicesClientListMetricDefinitionResponse{}, err
	}
	return result, nil
}

// NewListMetricsPager - Gets the metrics for the specified device.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - filter - OData Filter options
//   - options - DevicesClientListMetricsOptions contains the optional parameters for the DevicesClient.NewListMetricsPager method.
func (client *DevicesClient) NewListMetricsPager(deviceName string, resourceGroupName string, managerName string, filter string, options *DevicesClientListMetricsOptions) *runtime.Pager[DevicesClientListMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[DevicesClientListMetricsResponse]{
		More: func(page DevicesClientListMetricsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *DevicesClientListMetricsResponse) (DevicesClientListMetricsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DevicesClient.NewListMetricsPager")
			req, err := client.listMetricsCreateRequest(ctx, deviceName, resourceGroupName, managerName, filter, options)
			if err != nil {
				return DevicesClientListMetricsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return DevicesClientListMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return DevicesClientListMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMetricsCreateRequest creates the ListMetrics request.
func (client *DevicesClient) listMetricsCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, filter string, options *DevicesClientListMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/metrics"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	reqQP.Set("$filter", filter)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricsHandleResponse handles the ListMetrics response.
func (client *DevicesClient) listMetricsHandleResponse(resp *http.Response) (DevicesClientListMetricsResponse, error) {
	result := DevicesClientListMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricList); err != nil {
		return DevicesClientListMetricsResponse{}, err
	}
	return result, nil
}

// BeginScanForUpdates - Scans for updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - DevicesClientBeginScanForUpdatesOptions contains the optional parameters for the DevicesClient.BeginScanForUpdates
//     method.
func (client *DevicesClient) BeginScanForUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginScanForUpdatesOptions) (*runtime.Poller[DevicesClientScanForUpdatesResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.scanForUpdates(ctx, deviceName, resourceGroupName, managerName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DevicesClientScanForUpdatesResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DevicesClientScanForUpdatesResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ScanForUpdates - Scans for updates on the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
func (client *DevicesClient) scanForUpdates(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginScanForUpdatesOptions) (*http.Response, error) {
	var err error
	const operationName = "DevicesClient.BeginScanForUpdates"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.scanForUpdatesCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// scanForUpdatesCreateRequest creates the ScanForUpdates request.
func (client *DevicesClient) scanForUpdatesCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *DevicesClientBeginScanForUpdatesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/scanForUpdates"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Update - Patches the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - Patch representation of the device.
//   - options - DevicesClientUpdateOptions contains the optional parameters for the DevicesClient.Update method.
func (client *DevicesClient) Update(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters DevicePatch, options *DevicesClientUpdateOptions) (DevicesClientUpdateResponse, error) {
	var err error
	const operationName = "DevicesClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, deviceName, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return DevicesClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DevicesClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DevicesClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *DevicesClient) updateCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, parameters DevicePatch, options *DevicesClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *DevicesClient) updateHandleResponse(resp *http.Response) (DevicesClientUpdateResponse, error) {
	result := DevicesClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Device); err != nil {
		return DevicesClientUpdateResponse{}, err
	}
	return result, nil
}
