//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armblockchain.ClientFactory type.
type ServerFactory struct {
	LocationsServer              LocationsServer
	MemberOperationResultsServer MemberOperationResultsServer
	MembersServer                MembersServer
	OperationsServer             OperationsServer
	SKUsServer                   SKUsServer
	TransactionNodesServer       TransactionNodesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armblockchain.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armblockchain.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                            *ServerFactory
	trMu                           sync.Mutex
	trLocationsServer              *LocationsServerTransport
	trMemberOperationResultsServer *MemberOperationResultsServerTransport
	trMembersServer                *MembersServerTransport
	trOperationsServer             *OperationsServerTransport
	trSKUsServer                   *SKUsServerTransport
	trTransactionNodesServer       *TransactionNodesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "LocationsClient":
		initServer(s, &s.trLocationsServer, func() *LocationsServerTransport { return NewLocationsServerTransport(&s.srv.LocationsServer) })
		resp, err = s.trLocationsServer.Do(req)
	case "MemberOperationResultsClient":
		initServer(s, &s.trMemberOperationResultsServer, func() *MemberOperationResultsServerTransport {
			return NewMemberOperationResultsServerTransport(&s.srv.MemberOperationResultsServer)
		})
		resp, err = s.trMemberOperationResultsServer.Do(req)
	case "MembersClient":
		initServer(s, &s.trMembersServer, func() *MembersServerTransport { return NewMembersServerTransport(&s.srv.MembersServer) })
		resp, err = s.trMembersServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "SKUsClient":
		initServer(s, &s.trSKUsServer, func() *SKUsServerTransport { return NewSKUsServerTransport(&s.srv.SKUsServer) })
		resp, err = s.trSKUsServer.Do(req)
	case "TransactionNodesClient":
		initServer(s, &s.trTransactionNodesServer, func() *TransactionNodesServerTransport {
			return NewTransactionNodesServerTransport(&s.srv.TransactionNodesServer)
		})
		resp, err = s.trTransactionNodesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
