/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2025 Huawei Technologies Co., Ltd
 */

#ifndef _HINIC3_CSR_H_
#define _HINIC3_CSR_H_

#ifdef CONFIG_SP_VID_DID
#define PCI_VENDOR_ID_SPNIC    0x1F3F
#define HINIC3_DEV_ID_STANDARD 0x9020
#define HINIC3_DEV_ID_VF       0x9001
#else
#define PCI_VENDOR_ID_HUAWEI   0x19e5
#define HINIC3_DEV_ID_STANDARD 0x0222
#define HINIC3_DEV_ID_VF       0x375F
#endif

/*
 * Bit30/bit31 for bar index flag.
 * 00: bar0
 * 01: bar1
 * 10: bar2
 * 11: bar3
 */
#define HINIC3_CFG_REGS_FLAG  0x40000000

#define HINIC3_MGMT_REGS_FLAG 0xC0000000

#define HINIC3_REGS_FLAG_MASK 0x3FFFFFFF

#define HINIC3_VF_CFG_REG_OFFSET 0x2000

#define HINIC3_HOST_CSR_BASE_ADDR   (HINIC3_MGMT_REGS_FLAG + 0x6000)

/* HW interface registers. */
#define HINIC3_CSR_FUNC_ATTR0_ADDR (HINIC3_CFG_REGS_FLAG + 0x0)
#define HINIC3_CSR_FUNC_ATTR1_ADDR (HINIC3_CFG_REGS_FLAG + 0x4)
#define HINIC3_CSR_FUNC_ATTR2_ADDR (HINIC3_CFG_REGS_FLAG + 0x8)
#define HINIC3_CSR_FUNC_ATTR3_ADDR (HINIC3_CFG_REGS_FLAG + 0xC)
#define HINIC3_CSR_FUNC_ATTR4_ADDR (HINIC3_CFG_REGS_FLAG + 0x10)
#define HINIC3_CSR_FUNC_ATTR5_ADDR (HINIC3_CFG_REGS_FLAG + 0x14)
#define HINIC3_CSR_FUNC_ATTR6_ADDR (HINIC3_CFG_REGS_FLAG + 0x18)

#define HINIC3_FUNC_CSR_MAILBOX_DATA_OFF       0x80
#define HINIC3_FUNC_CSR_MAILBOX_CONTROL_OFF    (HINIC3_CFG_REGS_FLAG + 0x0100)
#define HINIC3_FUNC_CSR_MAILBOX_INT_OFFSET_OFF (HINIC3_CFG_REGS_FLAG + 0x0104)
#define HINIC3_FUNC_CSR_MAILBOX_RESULT_H_OFF   (HINIC3_CFG_REGS_FLAG + 0x0108)
#define HINIC3_FUNC_CSR_MAILBOX_RESULT_L_OFF   (HINIC3_CFG_REGS_FLAG + 0x010C)

#define HINIC3_PPF_ELECTION_OFFSET 0x0
#define HINIC3_MPF_ELECTION_OFFSET 0x20

#define HINIC3_CSR_PPF_ELECTION_ADDR \
	(HINIC3_HOST_CSR_BASE_ADDR + HINIC3_PPF_ELECTION_OFFSET)

#define HINIC3_CSR_GLOBAL_MPF_ELECTION_ADDR \
	(HINIC3_HOST_CSR_BASE_ADDR + HINIC3_MPF_ELECTION_OFFSET)

/* MSI-X registers. */
#define HINIC3_CSR_MSIX_INDIR_IDX_ADDR	(HINIC3_CFG_REGS_FLAG + 0x310)
#define HINIC3_CSR_MSIX_CTRL_ADDR	(HINIC3_CFG_REGS_FLAG + 0x300)
#define HINIC3_CSR_MSIX_CNT_ADDR	(HINIC3_CFG_REGS_FLAG + 0x304)
#define HINIC3_CSR_FUNC_MSI_CLR_WR_ADDR (HINIC3_CFG_REGS_FLAG + 0x58)

#define HINIC3_MSI_CLR_INDIR_RESEND_TIMER_CLR_SHIFT 0
#define HINIC3_MSI_CLR_INDIR_INT_MSK_SET_SHIFT	    1
#define HINIC3_MSI_CLR_INDIR_INT_MSK_CLR_SHIFT	    2
#define HINIC3_MSI_CLR_INDIR_AUTO_MSK_SET_SHIFT	    3
#define HINIC3_MSI_CLR_INDIR_AUTO_MSK_CLR_SHIFT	    4
#define HINIC3_MSI_CLR_INDIR_SIMPLE_INDIR_IDX_SHIFT 22

#define HINIC3_MSI_CLR_INDIR_RESEND_TIMER_CLR_MASK 0x1U
#define HINIC3_MSI_CLR_INDIR_INT_MSK_SET_MASK	   0x1U
#define HINIC3_MSI_CLR_INDIR_INT_MSK_CLR_MASK	   0x1U
#define HINIC3_MSI_CLR_INDIR_AUTO_MSK_SET_MASK	   0x1U
#define HINIC3_MSI_CLR_INDIR_AUTO_MSK_CLR_MASK	   0x1U
#define HINIC3_MSI_CLR_INDIR_SIMPLE_INDIR_IDX_MASK 0x3FFU

#define HINIC3_MSI_CLR_INDIR_SET(val, member)           \
	(((val) & HINIC3_MSI_CLR_INDIR_##member##_MASK) \
	 << HINIC3_MSI_CLR_INDIR_##member##_SHIFT)

/* EQ registers. */
#define HINIC3_AEQ_INDIR_IDX_ADDR (HINIC3_CFG_REGS_FLAG + 0x210)

#define HINIC3_AEQ_MTT_OFF_BASE_ADDR (HINIC3_CFG_REGS_FLAG + 0x240)

#define HINIC3_CSR_EQ_PAGE_OFF_STRIDE 8

#define HINIC3_AEQ_HI_PHYS_ADDR_REG(pg_num) \
	(HINIC3_AEQ_MTT_OFF_BASE_ADDR +     \
	 (pg_num) * HINIC3_CSR_EQ_PAGE_OFF_STRIDE)

#define HINIC3_AEQ_LO_PHYS_ADDR_REG(pg_num) \
	(HINIC3_AEQ_MTT_OFF_BASE_ADDR +     \
	 (pg_num) * HINIC3_CSR_EQ_PAGE_OFF_STRIDE + 4)

#define HINIC3_CSR_AEQ_CTRL_0_ADDR	    (HINIC3_CFG_REGS_FLAG + 0x200)
#define HINIC3_CSR_AEQ_CTRL_1_ADDR	    (HINIC3_CFG_REGS_FLAG + 0x204)
#define HINIC3_CSR_AEQ_CONS_IDX_ADDR	    (HINIC3_CFG_REGS_FLAG + 0x208)
#define HINIC3_CSR_AEQ_PROD_IDX_ADDR	    (HINIC3_CFG_REGS_FLAG + 0x20C)
#define HINIC3_CSR_AEQ_CI_SIMPLE_INDIR_ADDR (HINIC3_CFG_REGS_FLAG + 0x50)

#endif /* _HINIC3_CSR_H_ */
