/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.latex3.SequenceCommand;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;

public class TeXPath {
    private Path base;
    private Path relative;
    private boolean foundByKpsewhich = false;
    private Charset charset;

    public TeXPath(TeXParser teXParser, String string) throws IOException {
        this(teXParser, string, (Charset)null);
    }

    public TeXPath(TeXParser teXParser, String string, Charset charset) throws IOException {
        this(teXParser, string, !string.contains("/"), "tex");
        this.setEncoding(charset);
    }

    public TeXPath(TeXParser teXParser, String string, boolean bl) throws IOException {
        this(teXParser, string, bl, "tex");
    }

    public TeXPath(TeXParser teXParser, String string, String ... stringArray) throws IOException {
        this(teXParser, string, !string.contains("/"), stringArray);
    }

    public TeXPath(TeXParser teXParser, String string, String string2, boolean bl) throws IOException {
        this.init(teXParser, string, bl, string2);
    }

    public TeXPath(TeXParser teXParser, String string, boolean bl, String ... stringArray) throws IOException {
        this.init(teXParser, string, bl, stringArray);
    }

    public TeXPath(TeXParser teXParser, File file) throws IOException {
        this.init(teXParser, file);
    }

    public TeXPath(TeXParser teXParser, File file, Charset charset) throws IOException {
        this.init(teXParser, file);
        this.setEncoding(charset);
    }

    private TeXPath() {
    }

    protected File getDefaultBaseDir(TeXParser teXParser) {
        if (teXParser == null) {
            return null;
        }
        File file = teXParser.getBaseDir();
        if (file != null && file.getName().equals(".")) {
            return null;
        }
        return file;
    }

    public static TeXPath newOutputPath(TeXParser teXParser, String string, String string2) {
        File file = null;
        if (teXParser != null) {
            file = teXParser.getListener().getOutputDir();
        }
        return TeXPath.newOutputPath(file, string, string2);
    }

    public static TeXPath newOutputPath(File file, String string, String string2) {
        return TeXPath.newOutputPath(file, string, string2, true);
    }

    public static TeXPath newOutputPath(File file, String string, String string2, boolean bl) {
        File file2;
        Path path;
        String[] stringArray;
        File file3 = file;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        File file4 = new File((stringArray = string.split("/")).length == 1 ? stringArray[0] : stringArray[0] + File.separator);
        TeXPath teXPath = new TeXPath();
        int n = 0;
        if (file4.isAbsolute()) {
            teXPath.base = null;
            file3 = file4;
            n = 1;
        }
        int n2 = stringArray.length - 1;
        while (n < n2) {
            if (!stringArray[n].isEmpty()) {
                file3 = file3 == null ? new File(stringArray[n]) : new File(file3, stringArray[n]);
            }
            ++n;
        }
        if (stringArray[n2].startsWith("\"") && stringArray[n2].endsWith("\"")) {
            stringArray[n2] = stringArray[n2].substring(1, stringArray[n2].length() - 1);
        }
        String string3 = stringArray[n2];
        if (string2 != null && !string2.isEmpty() && (bl && !string3.endsWith("." + string2) || !string3.contains("."))) {
            string3 = string3 + "." + string2;
        }
        if ((path = (file2 = new File(file3, string3)).toPath()).isAbsolute()) {
            teXPath.relative = path;
        } else {
            try {
                teXPath.base = file3 == null ? null : file3.toPath();
                teXPath.relative = teXPath.base == null ? path : teXPath.base.relativize(path);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                teXPath.base = null;
                teXPath.relative = path;
            }
        }
        return teXPath;
    }

    private void init(TeXParser teXParser, File file) throws IOException {
        File file2 = this.getDefaultBaseDir(teXParser);
        Path path = file.toPath();
        if (path.isAbsolute()) {
            this.base = null;
            this.relative = path;
        } else {
            try {
                this.base = file2 == null ? null : file2.toPath();
                this.relative = this.base == null ? path : this.base.relativize(path);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.base = null;
                this.relative = path;
            }
        }
    }

    private void init(TeXParser teXParser, String string, String ... stringArray) throws IOException {
        this.init(teXParser, string, !string.contains("/"), stringArray);
    }

    private void init(TeXParser teXParser, String string, boolean bl, String ... stringArray) throws IOException {
        this.init(teXParser, string, bl, true, stringArray);
    }

    private void init(TeXParser teXParser, String string, boolean bl, boolean bl2, String ... stringArray) throws IOException {
        Object object;
        String[] stringArray2;
        File file = this.getDefaultBaseDir(teXParser);
        Path path = this.base = file == null ? null : file.toPath();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        File file2 = new File((stringArray2 = string.split("/")).length == 1 ? stringArray2[0] : stringArray2[0] + File.separator);
        int n = 0;
        if (file2.isAbsolute()) {
            bl = false;
            this.base = null;
            file = file2;
            n = 1;
        }
        int n2 = stringArray2.length - 1;
        while (n < n2) {
            if (!stringArray2[n].isEmpty()) {
                file = file == null ? new File(stringArray2[n]) : new File(file, stringArray2[n]);
            }
            ++n;
        }
        if (stringArray2[n2].startsWith("\"") && stringArray2[n2].endsWith("\"")) {
            stringArray2[n2] = stringArray2[n2].substring(1, stringArray2[n2].length() - 1);
        }
        File file3 = null;
        String string2 = stringArray2[n2];
        boolean bl3 = string2.contains(".");
        if (bl3 && file != null && file.isAbsolute() && (file3 = new File(file, stringArray2[n2])).exists()) {
            this.relative = file3.toPath();
            return;
        }
        if (!bl3 && this.tryExt(teXParser, bl, bl2, file2, file, stringArray2, string2, null)) {
            return;
        }
        if (stringArray.length > 0 && !bl3) {
            object = stringArray;
            int n3 = ((String[])object).length;
            for (int i = 0; i < n3; ++i) {
                String string3 = object[i];
                if (!this.tryExt(teXParser, bl, bl2, file2, file, stringArray2, string2, string3)) continue;
                return;
            }
            stringArray2[n2] = string2 + "." + stringArray[0];
            bl = false;
        }
        file3 = file == null ? new File(stringArray2[n2]) : new File(file, stringArray2[n2]);
        this.relative = this.base == null ? file3.toPath() : this.base.relativize(file3.toPath());
        if (!file3.exists() && teXParser != null) {
            if (bl2 && !file2.isAbsolute() && (object = this.trySearchPath(teXParser, stringArray2)) != null) {
                this.base = ((File)object).getParentFile().toPath();
                this.relative = this.base.relativize(((File)object).toPath());
            }
            if (bl) {
                try {
                    object = teXParser.getListener().getTeXApp().kpsewhich(stringArray2[n2]);
                    if (object != null && !((String)object).isEmpty()) {
                        this.foundByKpsewhich = true;
                        this.init(teXParser, (String)object, false, "");
                    }
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean tryExt(TeXParser teXParser, boolean bl, boolean bl2, File file, File file2, String[] stringArray, String string, String string2) throws IOException {
        File file3;
        int n = stringArray.length - 1;
        stringArray[n] = string2 == null || string2.isEmpty() ? string : string + "." + string2;
        File file4 = file3 = file2 == null ? new File(stringArray[n]) : new File(file2, stringArray[n]);
        if (file3.exists()) {
            if (file3.isDirectory() && (string2 == null || string2.isEmpty())) {
                return false;
            }
            this.relative = this.base == null ? file3.toPath() : this.base.relativize(file3.toPath());
            return true;
        }
        if (teXParser != null) {
            Object object;
            if (bl2 && !file.isAbsolute() && (object = this.trySearchPath(teXParser, stringArray)) != null) {
                this.base = ((File)object).getParentFile().toPath();
                this.relative = this.base.relativize(((File)object).toPath());
            }
            if (bl) {
                try {
                    object = teXParser.getListener().getTeXApp().kpsewhich(stringArray[n]);
                    if (object != null && !((String)object).isEmpty()) {
                        this.foundByKpsewhich = true;
                        this.init(teXParser, (String)object, false, "");
                        return true;
                    }
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected File trySearchPath(TeXParser teXParser, String[] stringArray) throws IOException {
        ControlSequence controlSequence = teXParser.getControlSequence("l_file_search_path_seq");
        if (controlSequence instanceof SequenceCommand) {
            for (TeXObject teXObject : ((SequenceCommand)controlSequence).getContent()) {
                int n;
                String string = teXParser.expandToString((TeXObject)teXObject.clone(), null);
                if (string.equals(".") || string.isEmpty()) continue;
                String[] stringArray2 = string.split("/");
                File file = new File(stringArray2.length == 1 ? stringArray2[0] : stringArray2[0] + File.separator);
                File file2 = file.isAbsolute() ? file : null;
                int n2 = n = file2 == null ? 0 : 1;
                while (n < stringArray2.length) {
                    if (!stringArray2[n].isEmpty()) {
                        file2 = new File(file2, stringArray2[n]);
                    }
                    ++n;
                }
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n].isEmpty()) continue;
                    file2 = new File(file2, stringArray[n]);
                }
                if (!file2.exists()) continue;
                return file2;
            }
        }
        return null;
    }

    public Path getRelativePath() {
        return this.relative;
    }

    public Path getBaseDir() {
        return this.base;
    }

    public boolean isHidden() {
        String string;
        int n;
        if (this.base != null) {
            for (n = this.base.getNameCount() - 1; n >= 0; --n) {
                string = this.base.getName(n).toString();
                if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
                return true;
            }
        }
        for (n = this.relative.getNameCount() - 1; n >= 0; --n) {
            string = this.relative.getName(n).toString();
            if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
            return true;
        }
        return false;
    }

    public String getTeXPath(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Path> iterator = this.relative.iterator();
        while (iterator.hasNext()) {
            Path path = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(path.toString());
                stringBuilder.append('/');
                continue;
            }
            if (bl) {
                String string = path.toString();
                int n = string.lastIndexOf(".");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(path.toString());
        }
        return stringBuilder.toString();
    }

    public File getFile() {
        Path path = this.base == null ? this.relative : this.base.resolve(this.relative);
        return path.toFile();
    }

    public Path getPath() {
        return this.base == null ? this.relative : this.base.resolve(this.relative);
    }

    @Deprecated
    public Path getRelative() {
        return this.relative;
    }

    public Path getLeaf() {
        return this.relative.getName(this.relative.getNameCount() - 1);
    }

    public String getExtension() {
        String string = this.getLeaf().toString();
        int n = string.lastIndexOf(".");
        return n == -1 ? null : string.substring(n);
    }

    public Path getFileName() {
        return this.relative.getFileName();
    }

    public boolean isAbsolute() {
        return this.relative.isAbsolute();
    }

    public boolean exists() {
        File file = this.getFile();
        return file == null ? false : file.exists();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TeXPath)) {
            return false;
        }
        TeXPath teXPath = (TeXPath)object;
        if (this.base == null && teXPath.base == null) {
            return this.relative.equals(teXPath.relative);
        }
        if (this.base == null || teXPath.base == null) {
            return false;
        }
        return this.relative.equals(teXPath.relative);
    }

    public String toString() {
        return this.base == null ? this.relative.toString() : this.base.resolve(this.relative).toString();
    }

    public boolean wasFoundByKpsewhich() {
        return this.foundByKpsewhich;
    }

    public Charset getEncoding() {
        return this.charset;
    }

    public void setEncoding(Charset charset) {
        this.charset = charset;
    }
}

