package cmd

import (
	"log"
	"testing"

	"github.com/chef/chef-workstation/components/main-chef-wrapper/dist"
	//"github.com/chef/chef-workstation/components/main-chef-wrapper/cmd"
)

func TestExportCommand(t *testing.T) {
	for _, test := range []struct {
		Args []string
	}{
		{
			Args: []string{"export", "--help"},
		},
		{
			Args: []string{"export", "POLICY_FILE", "DESTINATION_DIRECTORY"},
		},
		{
			Args: []string{"export", "POLICY_FILE", "DESTINATION_DIRECTORY", "--force"},
		},
	} {
		t.Run("", func(t *testing.T) {
			err := Runner.PassThroughCommand(dist.WorkstationExec, "", test.Args)
			if err != nil {
				log.Printf("Command finished with error: %v", err)
			} else {
				log.Printf("Command executed successfully")
			}
		})
	}
}
