﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

namespace Aws {
namespace GuardDuty {
namespace Model {
enum class MalwareProtectionPlanStatus { NOT_SET, ACTIVE, WARNING, ERROR_ };

namespace MalwareProtectionPlanStatusMapper {
AWS_GUARDDUTY_API MalwareProtectionPlanStatus GetMalwareProtectionPlanStatusForName(const Aws::String& name);

AWS_GUARDDUTY_API Aws::String GetNameForMalwareProtectionPlanStatus(MalwareProtectionPlanStatus value);
}  // namespace MalwareProtectionPlanStatusMapper
}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
