/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model.plan;

import java.sql.SQLException;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanException;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanNode;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanToken;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanTokenMatcher;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;

class FireBirdPlanParser {
    private String plan;
    private JDBCSession session;
    private FireBirdPlanTokenMatcher tokenMatch;

    FireBirdPlanParser(String plan, JDBCSession session) {
        this.plan = plan;
        this.session = session;
        this.tokenMatch = new FireBirdPlanTokenMatcher(plan);
    }

    FireBirdPlanNode parse() throws FireBirdPlanException {
        this.tokenMatch.jump();
        this.tokenMatch.checkToken(FireBirdPlanToken.PLAN);
        FireBirdPlanNode node = this.addPlanNode(null, this.plan);
        this.tokenMatch.jump();
        this.planExpr(node);
        return node;
    }

    private void planExpr(FireBirdPlanNode parent) throws FireBirdPlanException {
        switch (this.tokenMatch.token) {
            case LEFTPARENTHESE: {
                do {
                    this.tokenMatch.jump();
                    this.planItem(parent);
                } while (this.tokenMatch.token == FireBirdPlanToken.COMMA);
                this.tokenMatch.checkToken(FireBirdPlanToken.RIGHTPARENTHESE);
                break;
            }
            case SORT: {
                this.sortedItem(parent);
                break;
            }
            case JOIN: {
                this.joinedItem(parent);
                break;
            }
            case HASH: {
                this.hashedItem(parent);
                break;
            }
            case SORT_MERGE: {
                this.mergedItem(parent, true);
                break;
            }
            case MERGE: {
                this.mergedItem(parent, false);
                break;
            }
            default: {
                this.tokenMatch.raisePlanTokenException();
            }
        }
    }

    private void planItem(FireBirdPlanNode parent) throws FireBirdPlanException {
        switch (this.tokenMatch.token) {
            case IDENTIFICATOR: {
                this.basicItem(parent);
                break;
            }
            default: {
                this.planExpr(parent);
            }
        }
    }

    private void joinedItem(FireBirdPlanNode parent) throws FireBirdPlanException {
        this.tokenMatch.checkToken(FireBirdPlanToken.JOIN);
        FireBirdPlanNode node = this.addPlanNode(parent, "JOIN");
        this.tokenMatch.jump();
        this.tokenMatch.checkToken(FireBirdPlanToken.LEFTPARENTHESE);
        do {
            this.tokenMatch.jump();
            this.planItem(node);
        } while (this.tokenMatch.getToken() == FireBirdPlanToken.COMMA);
        this.tokenMatch.checkToken(FireBirdPlanToken.RIGHTPARENTHESE);
    }

    private void hashedItem(FireBirdPlanNode parent) throws FireBirdPlanException {
        this.tokenMatch.checkToken(FireBirdPlanToken.HASH);
        FireBirdPlanNode node = this.addPlanNode(parent, "HASH");
        this.tokenMatch.jump();
        this.tokenMatch.checkToken(FireBirdPlanToken.LEFTPARENTHESE);
        do {
            this.tokenMatch.jump();
            this.planItem(node);
        } while (this.tokenMatch.getToken() == FireBirdPlanToken.COMMA);
        this.tokenMatch.checkToken(FireBirdPlanToken.RIGHTPARENTHESE);
    }

    private void mergedItem(FireBirdPlanNode parent, Boolean sorted) throws FireBirdPlanException {
        if (sorted.booleanValue()) {
            this.tokenMatch.checkToken(FireBirdPlanToken.SORT_MERGE);
        } else {
            this.tokenMatch.checkToken(FireBirdPlanToken.MERGE);
        }
        this.tokenMatch.jump();
        this.tokenMatch.checkToken(FireBirdPlanToken.LEFTPARENTHESE);
        FireBirdPlanNode node = null;
        node = sorted != false ? this.addPlanNode(parent, "SORT MERGE") : this.addPlanNode(parent, "MERGE");
        this.tokenMatch.jump();
        this.tokenMatch.checkToken(FireBirdPlanToken.LEFTPARENTHESE);
        do {
            this.tokenMatch.jump();
            this.sortedItem(node);
            this.tokenMatch.jump();
        } while (this.tokenMatch.getToken() == FireBirdPlanToken.COMMA);
        this.tokenMatch.checkToken(FireBirdPlanToken.RIGHTPARENTHESE);
    }

    private void sortedItem(FireBirdPlanNode parent) throws FireBirdPlanException {
        this.tokenMatch.checkToken(FireBirdPlanToken.SORT);
        FireBirdPlanNode node = this.addPlanNode(parent, "SORT");
        this.tokenMatch.jump();
        this.tokenMatch.checkToken(FireBirdPlanToken.LEFTPARENTHESE);
        this.tokenMatch.jump();
        this.planItem(node);
        this.tokenMatch.checkToken(FireBirdPlanToken.RIGHTPARENTHESE);
    }

    private void basicItem(FireBirdPlanNode parent) throws FireBirdPlanException {
        String aliases = this.collectIdentifiers();
        switch (this.tokenMatch.token) {
            case NATURAL: {
                this.addPlanNode(parent, aliases + " NATURAL");
                this.tokenMatch.jump();
                break;
            }
            case INDEX: {
                String indexes = this.collectIndexes();
                this.addPlanNode(parent, aliases + " INDEX (" + indexes + ")");
                break;
            }
            case ORDER: {
                this.tokenMatch.jump();
                this.tokenMatch.checkToken(FireBirdPlanToken.IDENTIFICATOR);
                String orderIndex = this.tokenMatch.getValue();
                this.tokenMatch.jump();
                String text = aliases + " ORDER " + orderIndex + this.indexInfo(orderIndex);
                if (this.tokenMatch.getToken() == FireBirdPlanToken.INDEX) {
                    String orderIndexes = this.collectIndexes();
                    text = text + " INDEX(" + orderIndexes + ")";
                }
                this.addPlanNode(parent, text);
                break;
            }
            default: {
                this.tokenMatch.raisePlanTokenException();
            }
        }
    }

    private String collectIdentifiers() {
        Object identifiers = "";
        while (this.tokenMatch.getToken() == FireBirdPlanToken.IDENTIFICATOR) {
            identifiers = (String)identifiers + this.tokenMatch.getValue() + " ";
            this.tokenMatch.jump();
        }
        return identifiers;
    }

    private String collectIndexes() throws FireBirdPlanException {
        this.tokenMatch.jump();
        this.tokenMatch.checkToken(FireBirdPlanToken.LEFTPARENTHESE);
        Object indexes = "";
        this.tokenMatch.jump();
        while (this.tokenMatch.getToken() != FireBirdPlanToken.RIGHTPARENTHESE) {
            indexes = (String)indexes + this.tokenMatch.getValue() + this.indexInfo(this.tokenMatch.getValue());
            this.tokenMatch.jump();
            if (this.tokenMatch.getToken() != FireBirdPlanToken.COMMA) continue;
            indexes = (String)indexes + ",";
            this.tokenMatch.jump();
        }
        return indexes;
    }

    private FireBirdPlanNode addPlanNode(FireBirdPlanNode parent, String text) {
        FireBirdPlanNode node = new FireBirdPlanNode(text);
        node.parent = parent;
        if (parent != null) {
            parent.getNested().add(node);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String indexInfo(String index) throws FireBirdPlanException {
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        try (JDBCPreparedStatement dbStat = this.session.prepareStatement("SELECT RDB$FIELD_NAME, RDB$STATISTICS FROM RDB$INDEX_SEGMENTS WHERE RDB$INDEX_NAME = ? ORDER BY RDB$FIELD_POSITION");){
            dbStat.setString(1, index);
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (dbResult.next()) {
                    sb.append(String.format("%1$s[%2$f]", dbResult.getString(1).trim(), dbResult.getDouble(2)));
                    sb.append(", ");
                }
                sb.delete(sb.length() - 2, sb.length());
            }
        }
        catch (SQLException e) {
            throw new FireBirdPlanException(index, e.getMessage());
        }
        sb.append(" )");
        return sb.toString();
    }
}

