/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.tipoftheday;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.tipoftheday.ShowTipOfTheDayDialog;
import org.jkiss.dbeaver.ui.app.standalone.tipoftheday.TipsXmlHandler;
import org.jkiss.utils.CommonUtils;
import org.xml.sax.helpers.DefaultHandler;

public class ShowTipOfTheDayHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ShowTipOfTheDayHandler.class);
    private static final String TIPS_XML_FILE = "tips.xml";

    static void showTipOfTheDay(IWorkbenchWindow window) {
        if (UIUtils.isWindowVisible((Display)window.getShell().getDisplay(), ShowTipOfTheDayDialog.class)) {
            return;
        }
        List<String> tips = ShowTipOfTheDayHandler.loadTips();
        if (!CommonUtils.isEmpty(tips)) {
            ShowTipOfTheDayHandler.showTipOfTheDayDialog(tips, window);
        }
    }

    private static void showTipOfTheDayDialog(List<String> tips, IWorkbenchWindow window) {
        if (tips.isEmpty()) {
            return;
        }
        ShowTipOfTheDayDialog tipDialog = new ShowTipOfTheDayDialog(window.getShell(), tips);
        tipDialog.setDisplayShowOnStartup(true);
        tipDialog.open();
    }

    private static List<String> loadTips() {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream tipsInputStream = ShowTipOfTheDayHandler.class.getResourceAsStream(TIPS_XML_FILE);){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            TipsXmlHandler handler = new TipsXmlHandler();
            saxParser.parse(tipsInputStream, (DefaultHandler)handler);
            result.addAll(handler.getTips());
            if (!result.isEmpty() && result.size() > 1) {
                Collections.shuffle(result);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error reading tips", e);
        }
        return result;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ShowTipOfTheDayHandler.showTipOfTheDay(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
        return null;
    }
}

