/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Block;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.CreateFunctionalStatement;
import net.sf.jsqlparser.statement.DeclareStatement;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ExplainStatement;
import net.sf.jsqlparser.statement.IfElseStatement;
import net.sf.jsqlparser.statement.PurgeStatement;
import net.sf.jsqlparser.statement.ResetStatement;
import net.sf.jsqlparser.statement.RollbackStatement;
import net.sf.jsqlparser.statement.SavepointStatement;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.ShowColumnsStatement;
import net.sf.jsqlparser.statement.ShowStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.UnsupportedStatement;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterSession;
import net.sf.jsqlparser.statement.alter.AlterSystemStatement;
import net.sf.jsqlparser.statement.alter.RenameTableStatement;
import net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import net.sf.jsqlparser.statement.analyze.Analyze;
import net.sf.jsqlparser.statement.comment.Comment;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.schema.CreateSchema;
import net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.delete.ParenthesedDelete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.grant.Grant;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.insert.ParenthesedInsert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.refresh.RefreshMaterializedViewStatement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.show.ShowIndexStatement;
import net.sf.jsqlparser.statement.show.ShowTablesStatement;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.ParenthesedUpdate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.AlterDeParser;
import net.sf.jsqlparser.util.deparser.AlterSequenceDeParser;
import net.sf.jsqlparser.util.deparser.AlterSessionDeParser;
import net.sf.jsqlparser.util.deparser.AlterViewDeParser;
import net.sf.jsqlparser.util.deparser.CreateIndexDeParser;
import net.sf.jsqlparser.util.deparser.CreateSequenceDeParser;
import net.sf.jsqlparser.util.deparser.CreateSynonymDeparser;
import net.sf.jsqlparser.util.deparser.CreateTableDeParser;
import net.sf.jsqlparser.util.deparser.CreateViewDeParser;
import net.sf.jsqlparser.util.deparser.DeclareStatementDeParser;
import net.sf.jsqlparser.util.deparser.DeleteDeParser;
import net.sf.jsqlparser.util.deparser.DropDeParser;
import net.sf.jsqlparser.util.deparser.ExecuteDeParser;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.GrantDeParser;
import net.sf.jsqlparser.util.deparser.InsertDeParser;
import net.sf.jsqlparser.util.deparser.MergeDeParser;
import net.sf.jsqlparser.util.deparser.RefreshMaterializedViewStatementDeParser;
import net.sf.jsqlparser.util.deparser.ResetStatementDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import net.sf.jsqlparser.util.deparser.SetStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowColumnsStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowIndexStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowStatementDeParser;
import net.sf.jsqlparser.util.deparser.ShowTablesStatementDeparser;
import net.sf.jsqlparser.util.deparser.UpdateDeParser;
import net.sf.jsqlparser.util.deparser.UpsertDeParser;
import net.sf.jsqlparser.util.deparser.UseStatementDeParser;

public class StatementDeParser
extends AbstractDeParser<Statement>
implements StatementVisitor<StringBuilder> {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public StatementDeParser(Class<? extends ExpressionDeParser> expressionDeparserClass, Class<? extends SelectDeParser> selectDeparserClass, StringBuilder builder) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        super(builder);
        this.selectDeParser = selectDeparserClass.getConstructor(Class.class, StringBuilder.class).newInstance(expressionDeparserClass, builder);
        this.expressionDeParser = expressionDeparserClass.cast(this.selectDeParser.getExpressionVisitor());
    }

    public StatementDeParser(Class<? extends ExpressionDeParser> expressionDeparserClass, Class<? extends SelectDeParser> selectDeparserClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this(expressionDeparserClass, selectDeparserClass, new StringBuilder());
    }

    public StatementDeParser(StringBuilder buffer) {
        this(new ExpressionDeParser(), new SelectDeParser(), buffer);
    }

    public StatementDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        super(buffer);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
        this.selectDeParser.setBuilder(buffer);
        this.selectDeParser.setExpressionVisitor(expressionDeParser);
        this.expressionDeParser.setSelectVisitor(selectDeParser);
        this.expressionDeParser.setBuilder(buffer);
    }

    @Override
    public <S> StringBuilder visit(CreateIndex createIndex, S context) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.builder);
        createIndexDeParser.deParse(createIndex);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CreateTable createTable, S context) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this, this.builder);
        createTableDeParser.deParse(createTable);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CreateView createView, S context) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.builder);
        createViewDeParser.deParse(createView);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(RefreshMaterializedViewStatement materializedViewStatement, S context) {
        new RefreshMaterializedViewStatementDeParser(this.builder).deParse(materializedViewStatement);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AlterView alterView, S context) {
        AlterViewDeParser alterViewDeParser = new AlterViewDeParser(this.builder);
        alterViewDeParser.deParse(alterView);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Delete delete, S context) {
        DeleteDeParser deleteDeParser = new DeleteDeParser(this.expressionDeParser, this.builder);
        deleteDeParser.deParse(delete);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Drop drop, S context) {
        DropDeParser dropDeParser = new DropDeParser(this.builder);
        dropDeParser.deParse(drop);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Insert insert, S context) {
        InsertDeParser insertDeParser = new InsertDeParser(this.expressionDeParser, this.selectDeParser, this.builder);
        insertDeParser.deParse(insert);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ParenthesedInsert insert, S context) {
        List<WithItem<?>> withItemsList = insert.getWithItemsList();
        this.addWithItemsToBuffer(withItemsList, context);
        this.builder.append("(");
        insert.getInsert().accept(this, context);
        this.builder.append(")");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ParenthesedUpdate update, S context) {
        List<WithItem<?>> withItemsList = update.getWithItemsList();
        this.addWithItemsToBuffer(withItemsList, context);
        this.builder.append("(");
        update.getUpdate().accept(this, context);
        this.builder.append(")");
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ParenthesedDelete delete, S context) {
        List<WithItem<?>> withItemsList = delete.getWithItemsList();
        this.addWithItemsToBuffer(withItemsList, context);
        this.builder.append("(");
        delete.getDelete().accept(this, context);
        this.builder.append(")");
        return this.builder;
    }

    private <S> StringBuilder addWithItemsToBuffer(List<WithItem<?>> withItemsList, S context) {
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.builder.append("WITH ");
            for (WithItem<?> withItem : withItemsList) {
                withItem.accept((SelectVisitor)((Object)this), context);
                this.builder.append(" ");
            }
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Select select, S context) {
        select.accept(this.selectDeParser, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Truncate truncate, S context) {
        this.builder.append("TRUNCATE");
        if (truncate.isTableToken()) {
            this.builder.append(" TABLE");
        }
        if (truncate.isOnly()) {
            this.builder.append(" ONLY");
        }
        this.builder.append(" ");
        if (truncate.getTables() != null && !truncate.getTables().isEmpty()) {
            this.builder.append(truncate.getTables().stream().map(Table::toString).collect(Collectors.joining(", ")));
        } else {
            this.builder.append(truncate.getTable());
        }
        if (truncate.getCascade()) {
            this.builder.append(" CASCADE");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Update update, S context) {
        UpdateDeParser updateDeParser = new UpdateDeParser(this.expressionDeParser, this.builder);
        updateDeParser.deParse(update);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Analyze analyzer, S context) {
        this.builder.append("ANALYZE ");
        this.builder.append(analyzer.getTable());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Alter alter, S context) {
        AlterDeParser alterDeParser = new AlterDeParser(this.builder);
        alterDeParser.deParse(alter);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Statements statements, S context) {
        statements.accept(this, context);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Execute execute, S context) {
        ExecuteDeParser executeDeParser = new ExecuteDeParser(this.expressionDeParser, this.builder);
        executeDeParser.deParse(execute);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(SetStatement set, S context) {
        SetStatementDeParser setStatementDeparser = new SetStatementDeParser(this.expressionDeParser, this.builder);
        setStatementDeparser.deParse(set);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ResetStatement reset, S context) {
        ResetStatementDeParser setStatementDeparser = new ResetStatementDeParser(this.expressionDeParser, this.builder);
        setStatementDeparser.deParse(reset);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Merge merge, S context) {
        new MergeDeParser(this.expressionDeParser, this.selectDeParser, this.builder).deParse(merge);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(SavepointStatement savepointStatement, S context) {
        this.builder.append(savepointStatement.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(RollbackStatement rollbackStatement, S context) {
        this.builder.append(rollbackStatement.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Commit commit, S context) {
        this.builder.append(commit.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Upsert upsert, S context) {
        UpsertDeParser upsertDeParser = new UpsertDeParser(this.expressionDeParser, this.selectDeParser, this.builder);
        upsertDeParser.deParse(upsert);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(UseStatement use, S context) {
        new UseStatementDeParser(this.builder).deParse(use);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ShowColumnsStatement show, S context) {
        new ShowColumnsStatementDeParser(this.builder).deParse(show);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ShowIndexStatement showIndexes, S context) {
        new ShowIndexStatementDeParser(this.builder).deParse(showIndexes);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ShowTablesStatement showTables, S context) {
        new ShowTablesStatementDeparser(this.builder).deParse(showTables);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Block block, S context) {
        this.builder.append("BEGIN\n");
        if (block.getStatements() != null) {
            for (Statement stmt : block.getStatements()) {
                stmt.accept(this, context);
                this.builder.append(";\n");
            }
        }
        this.builder.append("END");
        if (block.hasSemicolonAfterEnd()) {
            this.builder.append(";");
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Comment comment, S context) {
        this.builder.append(comment.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(DescribeStatement describe, S context) {
        this.builder.append(describe.getDescribeType());
        this.builder.append(" ");
        this.builder.append(describe.getTable());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ExplainStatement explainStatement, S context) {
        this.builder.append(explainStatement.getKeyword()).append(" ");
        if (explainStatement.getTable() != null) {
            this.builder.append(explainStatement.getTable());
        } else if (explainStatement.getOptions() != null) {
            this.builder.append(explainStatement.getOptions().values().stream().map(ExplainStatement.Option::formatOption).collect(Collectors.joining(" ")));
            this.builder.append(" ");
        }
        if (explainStatement.getStatement() != null) {
            explainStatement.getStatement().accept(this, context);
        }
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(ShowStatement showStatement, S context) {
        new ShowStatementDeParser(this.builder).deParse(showStatement);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(DeclareStatement declareStatement, S context) {
        new DeclareStatementDeParser(this.expressionDeParser, this.builder).deParse(declareStatement);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(Grant grant, S context) {
        GrantDeParser grantDeParser = new GrantDeParser(this.builder);
        grantDeParser.deParse(grant);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CreateSchema aThis, S context) {
        this.builder.append(aThis.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CreateSequence createSequence, S context) {
        new CreateSequenceDeParser(this.builder).deParse(createSequence);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AlterSequence alterSequence, S context) {
        new AlterSequenceDeParser(this.builder).deParse(alterSequence);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CreateFunctionalStatement createFunctionalStatement, S context) {
        this.builder.append(createFunctionalStatement.toString());
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(CreateSynonym createSynonym, S context) {
        new CreateSynonymDeparser(this.builder).deParse(createSynonym);
        return this.builder;
    }

    @Override
    void deParse(Statement statement) {
        statement.accept(this, null);
    }

    @Override
    public <S> StringBuilder visit(AlterSession alterSession, S context) {
        new AlterSessionDeParser(this.builder).deParse(alterSession);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(IfElseStatement ifElseStatement, S context) {
        ifElseStatement.appendTo(this.builder);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(RenameTableStatement renameTableStatement, S context) {
        renameTableStatement.appendTo(this.builder);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(PurgeStatement purgeStatement, S context) {
        purgeStatement.appendTo(this.builder);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(AlterSystemStatement alterSystemStatement, S context) {
        alterSystemStatement.appendTo(this.builder);
        return this.builder;
    }

    @Override
    public <S> StringBuilder visit(UnsupportedStatement unsupportedStatement, S context) {
        unsupportedStatement.appendTo(this.builder);
        return this.builder;
    }

    public ExpressionDeParser getExpressionDeParser() {
        return this.expressionDeParser;
    }

    public SelectDeParser getSelectDeParser() {
        return this.selectDeParser;
    }
}

