/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDNote;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.erd.command.EntityAddCommand;
import org.jkiss.dbeaver.ui.editors.erd.command.EntityRemoveCommand;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDThemeSettings;
import org.jkiss.dbeaver.ui.editors.erd.figures.EntityDiagramFigure;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIActivator;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIMessages;
import org.jkiss.dbeaver.ui.editors.erd.layout.DelegatingLayoutManager;
import org.jkiss.dbeaver.ui.editors.erd.layout.GraphAnimation;
import org.jkiss.dbeaver.ui.editors.erd.layout.GraphLayoutAuto;
import org.jkiss.dbeaver.ui.editors.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ui.editors.erd.part.AssociationPart;
import org.jkiss.dbeaver.ui.editors.erd.part.EntityPart;
import org.jkiss.dbeaver.ui.editors.erd.part.NodePart;
import org.jkiss.dbeaver.ui.editors.erd.part.NotePart;
import org.jkiss.dbeaver.ui.editors.erd.part.PropertyAwarePart;
import org.jkiss.dbeaver.ui.editors.erd.part.RearrangeDiagramService;
import org.jkiss.dbeaver.ui.editors.erd.policy.DiagramContainerEditPolicy;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouter;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouterDescriptor;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouterRegistry;
import org.jkiss.utils.CommonUtils;

public class DiagramPart
extends PropertyAwarePart {
    private ERDConnectionRouter router;
    private final CommandStackEventListener stackListener = new CommandStackEventListener(){

        public void stackChanged(CommandStackEvent commandStackEvent) {
            if (DiagramPart.this.delegatingLayoutManager.getActiveLayoutManager() instanceof GraphLayoutAuto) {
                if (!GraphAnimation.captureLayout(DiagramPart.this.getFigure())) {
                    return;
                }
                while (GraphAnimation.step()) {
                    DiagramPart.this.getFigure().getUpdateManager().performUpdate();
                }
                GraphAnimation.end();
            } else {
                DiagramPart.this.getFigure().getUpdateManager().performUpdate();
            }
        }
    };
    private DelegatingLayoutManager delegatingLayoutManager;

    @Override
    public void activate() {
        super.activate();
        this.getViewer().getEditDomain().getCommandStack().addCommandStackEventListener(this.stackListener);
    }

    @Override
    protected boolean isListensModelChanges() {
        return true;
    }

    @Override
    public void deactivate() {
        this.getViewer().getEditDomain().getCommandStack().removeCommandStackEventListener(this.stackListener);
        super.deactivate();
    }

    public void performRequest(Request request) {
        this.getDiagram().getModelAdapter().performPartRequest((EditPart)this, request);
    }

    protected IFigure createFigure() {
        ERDEditorPart editor;
        ERDConnectionRouterDescriptor routerDescriptor;
        EntityDiagramFigure figure = new EntityDiagramFigure(this);
        this.delegatingLayoutManager = new DelegatingLayoutManager(this);
        figure.setLayoutManager(this.delegatingLayoutManager);
        Control control = this.getViewer().getControl();
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if ((control.getStyle() & 0x8000000) == 0) {
            cLayer.setAntialias(1);
        }
        ERDConnectionRouterDescriptor eRDConnectionRouterDescriptor = routerDescriptor = (editor = this.getEditor()) == null ? null : editor.getDiagramRouter();
        if (routerDescriptor == null) {
            routerDescriptor = ERDConnectionRouterRegistry.getInstance().getActiveRouter();
        }
        this.router = routerDescriptor.createRouter();
        this.router.setContainer((IFigure)figure);
        cLayer.setConnectionRouter((ConnectionRouter)this.router);
        return figure;
    }

    @Override
    @NotNull
    public EntityDiagram getDiagram() {
        return (EntityDiagram)this.getModel();
    }

    public Font getNormalFont() {
        return ERDThemeSettings.instance.diagramFont;
    }

    public Font getBoldFont() {
        return ERDThemeSettings.instance.diagramFontBold;
    }

    public void resetArrangement() {
        if (this.getEditor() == null) {
            return;
        }
        RearrangeDiagramService diagramService = new RearrangeDiagramService(this);
        LoadingJob.createService((ILoadService)diagramService, this.getEditor().getProgressControl().createLoadVisualizer()).schedule();
    }

    void rearrangeDiagram(@NotNull DBRProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask(ERDUIMessages.erd_job_rearrange_diagram, this.getChildren().size() + 2);
        this.getChildren().forEach(c -> {
            if (c instanceof NodePart) {
                NodePart nodePart = (NodePart)c;
                UIUtils.syncExec(() -> this.resetConnectionConstraints(monitor, nodePart.getSourceConnections()));
                monitor.worked(1);
            }
        });
        monitor.subTask(ERDUIMessages.erd_job_reset_element_position);
        this.delegatingLayoutManager.rearrange(monitor, this.getFigure());
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        monitor.subTask(ERDUIMessages.erd_job_repaint_diagram);
        UIUtils.syncExec(() -> this.getFigure().repaint());
        monitor.worked(1);
    }

    private void resetConnectionConstraints(DBRProgressMonitor monitor, List<?> sourceConnections) {
        if (monitor.isCanceled()) {
            return;
        }
        if (!CommonUtils.isEmpty(sourceConnections)) {
            for (Object sc : sourceConnections) {
                if (!(sc instanceof AbstractConnectionEditPart)) continue;
                AbstractConnectionEditPart abstractPart = (AbstractConnectionEditPart)sc;
                abstractPart.getConnectionFigure().setRoutingConstraint(null);
                if (!(sc instanceof AssociationPart)) continue;
                AssociationPart associationPart = (AssociationPart)sc;
                associationPart.getAssociation().setInitBends(null);
                associationPart.setConnectionRouting(monitor, (PolylineConnection)abstractPart.getConnectionFigure());
            }
        }
    }

    protected List<?> getModelChildren() {
        return this.getDiagram().getContents();
    }

    public boolean isSelectable() {
        return false;
    }

    protected void createEditPolicies() {
        ERDEditorPart editor = this.getEditor();
        if (editor != null && !editor.isReadOnly()) {
            this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new DiagramContainerEditPolicy());
            this.installEditPolicy("LayoutEditPolicy", null);
            this.getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
        }
    }

    public void setTableModelBounds() {
        List entityParts = this.getChildren();
        for (Object child : entityParts) {
            NodePart entityPart;
            IFigure entityFigure;
            if (!(child instanceof NodePart) || (entityFigure = (entityPart = (NodePart)child).getFigure()) == null) continue;
            Rectangle bounds = entityFigure.getBounds().getCopy();
            entityPart.setBounds(bounds);
        }
    }

    public boolean setTableFigureBounds(boolean updateConstraint) {
        List nodeParts = this.getChildren();
        for (Object child : nodeParts) {
            if (!(child instanceof NodePart)) continue;
            NodePart entityPart = (NodePart)child;
            Rectangle bounds = entityPart.getBounds();
            if (bounds == null) {
                return false;
            }
            IFigure entityFigure = entityPart.getFigure();
            if (entityFigure == null) {
                return false;
            }
            if (!updateConstraint) continue;
            this.delegatingLayoutManager.setXYLayoutConstraint(entityFigure, new Rectangle(bounds.x, bounds.y, -1, -1));
        }
        return true;
    }

    public void changeLayout() {
        this.getFigure().setLayoutManager((LayoutManager)this.delegatingLayoutManager);
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        super.setLayoutConstraint(child, childFigure, constraint);
    }

    @Override
    protected void handleChildChange(PropertyChangeEvent evt) {
        super.handleChildChange(evt);
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == SnapToHelper.class) {
            DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
            if (store.getBoolean("erd.grid.enabled") && store.getBoolean("erd.grid.snap")) {
                return key.cast(new SnapToGrid((GraphicalEditPart)this));
            }
            return null;
        }
        return super.getAdapter(key);
    }

    @Nullable
    public NodePart getChildByObject(Object object) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof NodePart) || ((NodePart)child).getElement().getObject() != object) continue;
            return (NodePart)child;
        }
        return null;
    }

    @Nullable
    public EntityPart getEntityPart(ERDEntity erdEntity) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof EntityPart) || ((EntityPart)child).getEntity() != erdEntity) continue;
            return (EntityPart)child;
        }
        return null;
    }

    public List<EntityPart> getEntityParts() {
        ArrayList<EntityPart> result = new ArrayList<EntityPart>();
        for (Object child : this.getChildren()) {
            if (!(child instanceof EntityPart)) continue;
            result.add((EntityPart)child);
        }
        return result;
    }

    @Nullable
    public NotePart getNotePart(ERDNote erdNote) {
        for (Object child : this.getChildren()) {
            if (!(child instanceof NotePart) || ((NotePart)child).getNote() != erdNote) continue;
            return (NotePart)child;
        }
        return null;
    }

    @NotNull
    public Command createEntityAddCommand(List<ERDEntity> entities, Point location) {
        return new EntityAddCommand(this, entities, location);
    }

    public Command createEntityDeleteCommand(EntityPart entityPart) {
        return new EntityRemoveCommand(entityPart);
    }

    public String toString() {
        return ERDUIMessages.entity_diagram_;
    }

    public ERDConnectionRouter getActiveRouter() {
        return this.router;
    }
}

