/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.messages.ModelMessages;

public enum JDBCTransactionIsolation implements DBPTransactionIsolation
{
    NONE(0, ModelMessages.model_jdbc_None),
    READ_UNCOMMITTED(1, ModelMessages.model_jdbc_read_uncommitted),
    READ_COMMITTED(2, ModelMessages.model_jdbc_read_committed),
    REPEATABLE_READ(4, ModelMessages.model_jdbc_repeatable_read),
    SERIALIZABLE(8, ModelMessages.model_jdbc_Serializable);

    private final int code;
    private final String title;

    private JDBCTransactionIsolation(int code, String title) {
        this.code = code;
        this.title = title;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isEnabled() {
        return this != NONE;
    }

    public String getTitle() {
        return this.title;
    }

    public static JDBCTransactionIsolation getByCode(int code) {
        for (JDBCTransactionIsolation txni : JDBCTransactionIsolation.values()) {
            if (txni.code != code) continue;
            return txni;
        }
        return null;
    }
}

