/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndex;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class MySQLTableManager
extends SQLTableManager<MySQLTableBase, MySQLCatalog>
implements DBEObjectRenamer<MySQLTableBase> {
    private static final Class<? extends DBSObject>[] CHILD_TYPES = (Class[])CommonUtils.array((Object[])new Class[]{MySQLTableColumn.class, MySQLTableConstraint.class, MySQLTableForeignKey.class, MySQLTableIndex.class});

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return super.getMakerOptions(dataSource) | 0x10L;
    }

    @Nullable
    public DBSObjectCache<MySQLCatalog, MySQLTableBase> getObjectsCache(MySQLTableBase object) {
        return ((MySQLCatalog)object.getContainer()).getTableCache();
    }

    protected MySQLTableBase createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        MySQLTable table;
        MySQLCatalog catalog = (MySQLCatalog)container;
        if (copyFrom instanceof DBSEntity) {
            table = new MySQLTable(monitor, catalog, (DBSEntity)copyFrom);
            table.setName(this.getNewChildName(monitor, (DBSObject)catalog, ((DBSEntity)copyFrom).getName()));
        } else if (copyFrom == null) {
            table = new MySQLTable(catalog);
            this.setNewObjectName(monitor, (DBSObject)catalog, table);
            MySQLTable.AdditionalInfo additionalInfo = table.getAdditionalInfo(monitor);
            additionalInfo.setEngine(catalog.getDataSource().getDefaultEngine());
            additionalInfo.setCharset(catalog.getAdditionalInfo(monitor).getDefaultCharset());
            additionalInfo.setCollation(catalog.getAdditionalInfo(monitor).getDefaultCollation());
        } else {
            throw new DBException("Can't create MySQL table from '" + String.valueOf(copyFrom) + "'");
        }
        return table;
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        StringBuilder query = new StringBuilder("ALTER TABLE ");
        query.append(((MySQLTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
        this.appendTableModifiers(monitor, (MySQLTableBase)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command, query, true, options);
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction(query.toString()));
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.getOption(options, (String)"script.includeDrop")) {
            MySQLTableBase table = (MySQLTableBase)command.getObject();
            String tableName = DBUtils.getEntityScriptName((DBSObject)table, options);
            actions.add(0, (DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, "DROP TABLE IF EXISTS " + tableName));
        }
        super.addStructObjectCreateActions(monitor, executionContext, actions, command, options);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendTableModifiers(DBRProgressMonitor monitor, MySQLTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter, Map<String, Object> options) {
        if (!(tableBase instanceof MySQLTable)) {
            return;
        }
        MySQLTable mySQLTable = (MySQLTable)tableBase;
        String delimiter = MySQLTableManager.getDelimiter(options);
        try {
            void table;
            MySQLDataSource dataSource = (MySQLDataSource)table.getDataSource();
            MySQLTable.AdditionalInfo additionalInfo = table.getAdditionalInfo(monitor);
            if (!(table.isPersisted() && tableProps.getProperty((Object)"engine") == null || additionalInfo.getEngine() == null)) {
                ddl.append(delimiter).append("ENGINE=").append(additionalInfo.getEngine().getName());
            }
            if (dataSource.supportsCharsets() && (!table.isPersisted() || tableProps.getProperty((Object)"charset") != null) && additionalInfo.getCharset() != null) {
                ddl.append(delimiter).append("DEFAULT CHARSET=").append(additionalInfo.getCharset().getName());
            }
            if (dataSource.supportsCollations() && (!table.isPersisted() || tableProps.getProperty((Object)"collation") != null) && additionalInfo.getCollation() != null) {
                ddl.append(delimiter).append("COLLATE=").append(additionalInfo.getCollation().getName());
            }
            if (!table.isPersisted() && table.getDescription() != null || tableProps.hasProperty((Object)"description")) {
                ddl.append(delimiter).append("COMMENT=").append(SQLUtils.quoteString((DBSObject)table, (String)CommonUtils.notEmpty((String)table.getDescription())));
            }
            if (!(table.isPersisted() && tableProps.getProperty((Object)"autoIncrement") == null || additionalInfo.getAutoIncrement() <= 0L)) {
                ddl.append(delimiter).append("AUTO_INCREMENT=").append(additionalInfo.getAutoIncrement());
            }
        }
        catch (DBCException e) {
            log.error((Object)e);
        }
    }

    protected boolean isIncludeIndexInDDL(DBRProgressMonitor monitor, DBSTableIndex index) throws DBException {
        return !((MySQLTableIndex)index).isUniqueKeyIndex(monitor) && super.isIncludeIndexInDDL(monitor, index);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        MySQLDataSource dataSource = (MySQLDataSource)((MySQLTableBase)command.getObject()).getDataSource();
        boolean alterTable = dataSource.supportsAlterTableRenameSyntax();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", (alterTable ? "ALTER" : "RENAME") + " TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((MySQLTableBase)command.getObject()).getContainer()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + (alterTable ? " RENAME" : "") + " TO " + DBUtils.getQuotedIdentifier((DBSObject)((MySQLTableBase)command.getObject()).getContainer()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    @NotNull
    public Class<? extends DBSObject>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, MySQLTableBase object, Class<? extends DBSObject> childType) throws DBException {
        if (childType == MySQLTableColumn.class) {
            return object.getAttributes(monitor);
        }
        if (childType == MySQLTableConstraint.class) {
            return object.getConstraints(monitor);
        }
        if (childType == MySQLTableForeignKey.class) {
            return object.getAssociations(monitor);
        }
        if (childType == MySQLTableIndex.class) {
            return object.getIndexes(monitor);
        }
        return null;
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull MySQLTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }
}

