/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueDiff;

public abstract class DuplexingObservableValue<T>
extends AbstractObservableValue<T> {
    private IObservableList<T> target;
    private final Object valueType;
    private boolean dirty = true;
    private boolean updating = false;
    private T cachedValue = null;
    private PrivateInterface privateInterface;

    public static <T> DuplexingObservableValue<T> withDefaults(IObservableList<T> target, final T emptyValue, final T multiValue) {
        return new DuplexingObservableValue<T>(target){

            @Override
            protected T coalesceElements(Collection<T> elements) {
                if (elements.isEmpty()) {
                    return emptyValue;
                }
                Iterator it = elements.iterator();
                Object first = it.next();
                while (it.hasNext()) {
                    if (Objects.equals(first, it.next())) continue;
                    return multiValue;
                }
                return first;
            }
        };
    }

    public DuplexingObservableValue(IObservableList<T> target) {
        this(target, target.getElementType());
    }

    public DuplexingObservableValue(IObservableList<T> target, Object valueType) {
        super(target.getRealm());
        this.target = target;
        this.valueType = valueType;
    }

    @Override
    protected void firstListenerAdded() {
        if (this.privateInterface == null) {
            this.privateInterface = new PrivateInterface();
        }
        this.target.addChangeListener(this.privateInterface);
        this.target.addStaleListener(this.privateInterface);
    }

    @Override
    protected void lastListenerRemoved() {
        this.target.removeChangeListener(this.privateInterface);
        this.target.removeStaleListener(this.privateInterface);
    }

    protected final void makeDirty() {
        if (this.hasListeners() && !this.dirty) {
            this.dirty = true;
            final T oldValue = this.cachedValue;
            this.fireValueChange(new ValueDiff<T>(){

                @Override
                public T getOldValue() {
                    return oldValue;
                }

                @Override
                public T getNewValue() {
                    return DuplexingObservableValue.this.getValue();
                }
            });
        }
    }

    @Override
    public boolean isStale() {
        this.getValue();
        return this.target.isStale();
    }

    @Override
    protected T doGetValue() {
        if (!this.hasListeners()) {
            return this.coalesceElements(this.target);
        }
        if (this.dirty) {
            this.cachedValue = this.coalesceElements(this.target);
            this.dirty = false;
            if (this.target.isStale()) {
                this.fireStale();
            }
        }
        return this.cachedValue;
    }

    protected abstract T coalesceElements(Collection<T> var1);

    @Override
    protected void doSetValue(T value) {
        final T oldValue = this.cachedValue;
        boolean wasUpdating = this.updating;
        try {
            this.updating = true;
            int i = 0;
            while (i < this.target.size()) {
                this.target.set(i, value);
                ++i;
            }
        }
        finally {
            this.updating = wasUpdating;
        }
        if (this.hasListeners()) {
            this.fireValueChange(new ValueDiff<T>(){

                @Override
                public T getOldValue() {
                    return oldValue;
                }

                @Override
                public T getNewValue() {
                    return DuplexingObservableValue.this.getValue();
                }
            });
        }
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    @Override
    public synchronized void addChangeListener(IChangeListener listener) {
        super.addChangeListener(listener);
        this.computeValueForListeners();
    }

    @Override
    public synchronized void addValueChangeListener(IValueChangeListener<? super T> listener) {
        super.addValueChangeListener(listener);
        this.computeValueForListeners();
    }

    private void computeValueForListeners() {
        this.getRealm().exec(() -> {
            if (this.hasListeners()) {
                this.getValue();
            }
        });
    }

    @Override
    public synchronized void dispose() {
        if (this.privateInterface != null && this.target != null) {
            this.target.removeChangeListener(this.privateInterface);
        }
        if (this.privateInterface != null && this.target != null) {
            this.target.removeStaleListener(this.privateInterface);
        }
        this.target = null;
        this.privateInterface = null;
        super.dispose();
    }

    private class PrivateInterface
    implements IChangeListener,
    IStaleListener {
        private PrivateInterface() {
        }

        @Override
        public void handleChange(ChangeEvent event) {
            if (!DuplexingObservableValue.this.updating) {
                DuplexingObservableValue.this.makeDirty();
            }
        }

        @Override
        public void handleStale(StaleEvent staleEvent) {
            if (!DuplexingObservableValue.this.dirty) {
                DuplexingObservableValue.this.fireStale();
            }
        }
    }
}

