/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.exceptions.DataConversionException;
import com.mysql.cj.result.DefaultValueFactory;
import com.mysql.cj.result.Field;
import com.mysql.cj.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.UUID;

public class UuidValueFactory
extends DefaultValueFactory<UUID> {
    public UuidValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public UUID createFromBytes(byte[] bytes, int offset, int length, Field f) {
        if (f.isBinary()) {
            return this.getUuidFromBytes(bytes);
        }
        MysqlType mysqlType = f.getMysqlType();
        switch (mysqlType) {
            case CHAR: 
            case VARCHAR: 
            case TEXT: 
            case TINYTEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: {
                String s = StringUtils.toString(bytes, offset, length, f.getEncoding());
                try {
                    return UUID.fromString(s);
                }
                catch (IllegalArgumentException e) {
                    throw new DataConversionException(Messages.getString("ResultSet.UnableToConvertString", new Object[]{s, this.getTargetTypeName()}));
                }
            }
        }
        throw new DataConversionException(Messages.getString("ResultSet.UnsupportedConversion", new Object[]{mysqlType.name(), this.getTargetTypeName()}));
    }

    @Override
    public String getTargetTypeName() {
        return UUID.class.getName();
    }

    private UUID getUuidFromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long high = bb.getLong();
        long low = bb.getLong();
        return new UUID(high, low);
    }
}

