/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.functools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.HashNotImplemented;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.functools.KeyWrapperBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.functools.KeyWrapperBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.functools.PKeyWrapper;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectRichCompare;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PKeyWrapper})
@HashNotImplemented
public final class KeyWrapperBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = KeyWrapperBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return KeyWrapperBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
    }

    @Builtin(name="obj", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="Value wrapped by a key function.")
    @GenerateNodeFactory
    public static abstract class KeyWrapperObjNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(value)"})
        static Object doGet(PKeyWrapper self, PNone value) {
            return self.getObject();
        }

        @Specialization
        static Object doSet(PKeyWrapper self, Object value) {
            self.setObject(value);
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_call, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=2, parameterNames={"$self", "obj"})
    @GenerateNodeFactory
    public static abstract class KWCallNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object call(PKeyWrapper self, Object obj, @Bind PythonLanguage language) {
            PKeyWrapper keyWrapper = PFactory.createKeyWrapper(language, self.getCmp());
            keyWrapper.setObject(obj);
            return keyWrapper;
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    static abstract class KeyWrapperRichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        KeyWrapperRichCmpNode() {
        }

        @Specialization
        boolean doCompare(VirtualFrame frame, PKeyWrapper self, PKeyWrapper other, RichCmpOp op, @Bind Node inliningTarget, @Cached CallNode callNode, @Cached PyObjectRichCompare richCompareNode, @Cached PyObjectIsTrueNode isTrueNode) {
            Object cmpResult = callNode.execute((Frame)frame, self.getCmp(), self.getObject(), other.getObject());
            return isTrueNode.execute((Frame)frame, richCompareNode.execute(frame, inliningTarget, cmpResult, 0, op));
        }

        @Fallback
        static boolean fallback(Object self, Object other, RichCmpOp op, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OTHER_ARG_MUST_BE_KEY);
        }
    }
}

