/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleConversionInputStream
extends OracleBufferedStream {
    static final int CHUNK_SIZE = 32768;
    DBConversion converter;
    int conversion;
    InputStream istream;
    Reader reader;
    byte[] convbuf;
    int convbufSize;
    char[] javaChars;
    int javaCharsSize;
    int maxSize;
    int totalSize;
    int numUnconvertedBytes;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion) {
        this(conv_object, istream, conversion, 1);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$8, null, conv_object, istream, conversion);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, short formOfUse) {
        super(32768);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$9, null, conv_object, istream, conversion, formOfUse);
            }
            this.istream = istream;
            this.conversion = conversion;
            this.converter = conv_object;
            this.maxSize = 0;
            this.totalSize = 0;
            this.numUnconvertedBytes = 0;
            this.endOfStream = false;
            this.nbytes = new int[1];
            this.csform = formOfUse;
            this.currentBufferSize = this.initialBufferSize;
            switch (conversion) {
                case 0: {
                    this.javaCharsSize = 32768;
                    this.convbufSize = 32768;
                    break;
                }
                case 1: {
                    this.convbufSize = 16384;
                    this.javaCharsSize = 16384;
                    break;
                }
                case 2: {
                    this.convbufSize = 16384;
                    this.javaCharsSize = 32768;
                    break;
                }
                case 3: {
                    this.convbufSize = 8192;
                    this.javaCharsSize = 16384;
                    break;
                }
                case 4: {
                    int size = 32768 / this.converter.getMaxCharbyteSize();
                    this.convbufSize = size * 2;
                    this.javaCharsSize = size;
                    break;
                }
                case 5: {
                    if (this.converter.isUcs2CharSet()) {
                        this.convbufSize = 16384;
                        this.javaCharsSize = 16384;
                        break;
                    }
                    this.convbufSize = 32768;
                    this.javaCharsSize = 32768;
                    break;
                }
                case 7: {
                    int size;
                    this.javaCharsSize = size = 32768 / (this.csform == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.getMaxCharbyteSize());
                    this.convbufSize = 0;
                    break;
                }
                case 13: {
                    this.convbufSize = 16384;
                    this.javaCharsSize = 0;
                    break;
                }
                case 14: {
                    this.javaCharsSize = 16384;
                    this.convbufSize = 0;
                    break;
                }
                case 15: {
                    this.convbufSize = this.javaCharsSize = 32768 / (this.csform == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.sMaxCharSize);
                    break;
                }
                case 16: {
                    this.javaCharsSize = 32768 / (this.csform == 2 ? this.converter.getMaxNCharbyteSize() : this.converter.sMaxCharSize);
                    this.convbufSize = 0;
                    break;
                }
                default: {
                    this.convbufSize = 32768;
                    this.javaCharsSize = 32768;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, int max_bytesize) {
        this(conv_object, istream, conversion, 1);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$10, null, conv_object, istream, conversion, max_bytesize);
            }
            this.maxSize = max_bytesize;
            this.totalSize = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleConversionInputStream(DBConversion conv_object, Reader reader, int conversion, int max_charsize, short formOfUse) {
        this(conv_object, (InputStream)null, conversion, formOfUse);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$11, null, conv_object, reader, conversion, max_charsize, formOfUse);
            }
            this.reader = reader;
            this.maxSize = max_charsize;
            this.totalSize = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public void allocateBuffers() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.resizableBuffer == null) {
                this.resizableBuffer = new byte[this.currentBufferSize];
                this.javaChars = new char[this.javaCharsSize];
                if (this.convbufSize > 0) {
                    this.convbuf = new byte[this.convbufSize];
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    void deallocateBuffers() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$1, this, new Object[0]);
            }
            this.convbuf = null;
            this.javaChars = null;
            this.resizableBuffer = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFormOfUse(short s2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void csform;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$2, this, s2);
            }
            this.csform = csform;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean needBytes(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$3, this, n2);
            }
            boolean bl2 = this.needBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$3, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean needBytes() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, new Object[0]);
            }
            if (this.closed) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, null);
                }
                return false;
            }
            if (this.pos < this.count) {
                boolean bl3 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, null);
                }
                return true;
            }
            if (this.istream != null) {
                boolean bl4 = this.needBytesFromStream();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, null);
                }
                return bl4;
            }
            if (this.reader != null) {
                boolean bl5 = this.needBytesFromReader();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, bl5);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, null);
                }
                return bl5;
            }
            boolean bl6 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, bl6);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean needBytesFromReader() throws IOException {
        var3_1 = (516L & TraceControllerImpl.feature) != 0L;
        try {
            block19: {
                block20: {
                    block17: {
                        block18: {
                            if (var3_1) {
                                ClioSupport.entering(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, new Object[0]);
                            }
                            try {
                                read_size = 0;
                                read_size = this.maxSize == 0 ? this.javaCharsSize : Math.min(this.maxSize - this.totalSize, this.javaCharsSize);
                                if (read_size > 0) break block17;
                                this.deallocateBuffers();
                                v0 = var4_4 = false;
                                if (!var3_1) break block18;
                            }
                            catch (SQLException e) {
                                var5_8 = (IOException)DatabaseError.createIOException(e).fillInStackTrace();
                                if (var3_1) {
                                    ClioSupport.throwing(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, var5_8);
                                }
                                throw var5_8;
                            }
                            ClioSupport.returning(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, var4_4);
                            ClioSupport.exiting(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, null);
                        }
                        return v0;
                    }
                    this.allocateBuffers();
                    chars_read = this.reader.read(this.javaChars, 0, read_size);
                    if (chars_read != -1) break block19;
                    this.deallocateBuffers();
                    v1 = var4_5 = false;
                    if (!var3_1) break block20;
                    ClioSupport.returning(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, var4_5);
                    ClioSupport.exiting(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, null);
                }
                return v1;
            }
            this.totalSize += chars_read;
            switch (this.conversion) {
                case 7: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, chars_read, this.resizableBuffer);
                        ** break;
                    }
                    this.count = this.converter.javaCharsToCHARBytes(this.javaChars, chars_read, this.resizableBuffer);
                    ** break;
                }
                case 14: {
                    this.count = CharacterSet.convertJavaCharsToAL16UTF16Bytes(this.javaChars, 0, this.resizableBuffer, 0, chars_read);
                    ** break;
                }
                case 16: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.javaChars, chars_read, this.resizableBuffer);
                        ** break;
                    }
                    this.count = this.converter.javaCharsToDbCsBytes(this.javaChars, chars_read, this.resizableBuffer);
                    ** break;
                }
                default: {
                    System.arraycopy(this.convbuf, 0, this.resizableBuffer, 0, chars_read);
                    this.count = chars_read;
                    ** break;
                }
            }
lbl57:
            // 6 sources

            this.pos = 0;
            var4_6 = true;
            if (var3_1) {
                ClioSupport.returning(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, var4_6);
                ClioSupport.exiting(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, null);
            }
            return true;
        }
        catch (Throwable v2) {
            var5_9 = v2;
            if (var3_1) {
                ClioSupport.exiting(OracleConversionInputStream.$$$loggerRef$$$5, Level.FINEST, OracleConversionInputStream.class, OracleConversionInputStream.$$$methodRef$$$5, this, var5_9);
            }
            throw v2;
        }
    }

    public boolean needBytesFromStream() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (!this.endOfStream) {
                int bytes_read;
                block33: {
                    boolean bl2;
                    block34: {
                        boolean bl3;
                        int read_size = 0;
                        read_size = this.maxSize == 0 ? this.convbufSize : Math.min(this.maxSize - this.totalSize, this.convbufSize);
                        bytes_read = 0;
                        if (read_size <= 0) {
                            this.endOfStream = true;
                            this.istream.close();
                            if (this.numUnconvertedBytes != 0) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, sQLException);
                                }
                                throw sQLException;
                            }
                        } else {
                            this.allocateBuffers();
                            bytes_read = this.istream.read(this.convbuf, this.numUnconvertedBytes, read_size - this.numUnconvertedBytes);
                            if (bl) {
                                OracleLog.debug($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, OracleLog.bytesToPrintableForm("Read " + bytes_read + " bytes into convbuf", this.convbuf, bytes_read));
                            }
                        }
                        if (bytes_read == -1) {
                            this.endOfStream = true;
                            this.istream.close();
                            if (this.numUnconvertedBytes != 0) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, sQLException);
                                }
                                throw sQLException;
                            }
                        } else {
                            this.totalSize += (bytes_read += this.numUnconvertedBytes);
                        }
                        if (bytes_read > 0) break block33;
                        this.deallocateBuffers();
                        bl2 = bl3 = false;
                        if (!bl) break block34;
                        ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, null);
                    }
                    return bl2;
                }
                try {
                    switch (this.conversion) {
                        case 0: {
                            this.nbytes[0] = bytes_read;
                            int chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaCharsSize);
                            this.numUnconvertedBytes = this.nbytes[0];
                            for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                                this.convbuf[i2] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                            }
                            this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 1: {
                            this.nbytes[0] = bytes_read;
                            int chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, 0, this.javaChars, 0, this.nbytes, this.javaCharsSize);
                            this.numUnconvertedBytes = this.nbytes[0];
                            for (int i3 = 0; i3 < this.numUnconvertedBytes; ++i3) {
                                this.convbuf[i3] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                            }
                            this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 2: {
                            int chars_read = DBConversion.RAWBytesToHexChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 3: {
                            int chars_read = DBConversion.RAWBytesToHexChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = DBConversion.javaCharsToUcs2Bytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 4: {
                            int chars_read = DBConversion.ucs2BytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = this.converter.javaCharsToCHARBytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 12: {
                            int chars_read = DBConversion.ucs2BytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = DBConversion.javaCharsToAsciiBytes(this.javaChars, chars_read, this.resizableBuffer);
                            break;
                        }
                        case 5: {
                            DBConversion.asciiBytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = this.converter.javaCharsToCHARBytes(this.javaChars, bytes_read, this.resizableBuffer);
                            break;
                        }
                        case 13: {
                            this.count = DBConversion.asciiBytesToUTF16Bytes(this.convbuf, bytes_read, this.resizableBuffer);
                            break;
                        }
                        case 15: {
                            DBConversion.asciiBytesToJavaChars(this.convbuf, bytes_read, this.javaChars);
                            this.count = this.converter.javaCharsToDbCsBytes(this.javaChars, bytes_read, this.resizableBuffer);
                            break;
                        }
                        default: {
                            System.arraycopy(this.convbuf, 0, this.resizableBuffer, 0, bytes_read);
                            this.count = bytes_read;
                            break;
                        }
                    }
                }
                catch (SQLException e2) {
                    IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, iOException);
                    }
                    throw iOException;
                }
                this.pos = 0;
                boolean bl4 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, null);
                }
                return true;
            }
            this.deallocateBuffers();
            boolean bl5 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$7, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$7, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$7, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleConversionInputStream.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = OracleConversionInputStream.class.getDeclaredConstructor(DBConversion.class, Reader.class, Integer.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleConversionInputStream.class.getDeclaredConstructor(DBConversion.class, InputStream.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleConversionInputStream.class.getDeclaredConstructor(DBConversion.class, InputStream.class, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleConversionInputStream.class.getDeclaredConstructor(DBConversion.class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleConversionInputStream.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleConversionInputStream.class.getDeclaredMethod("needBytesFromStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleConversionInputStream.class.getDeclaredMethod("needBytesFromReader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleConversionInputStream.class.getDeclaredMethod("needBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleConversionInputStream.class.getDeclaredMethod("needBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleConversionInputStream.class.getDeclaredMethod("setFormOfUse", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleConversionInputStream.class.getDeclaredMethod("deallocateBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleConversionInputStream.class.getDeclaredMethod("allocateBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

