/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.partial;

import com.jetbrains.cef.remote.thrift.partial.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ThriftField {
    public final String name;
    public final List<ThriftField> fields;
    private int hashcode = 0;

    ThriftField(String name, List<ThriftField> fields) {
        Validate.checkNotNullAndNotEmpty(name, "name");
        Validate.checkNotNull(fields, "fields");
        this.name = name;
        this.fields = Collections.unmodifiableList(fields);
    }

    ThriftField(String name) {
        this(name, Collections.emptyList());
    }

    ThriftField(String name, List<ThriftField> fields, boolean allowFieldAdds) {
        Validate.checkNotNullAndNotEmpty(name, "name");
        Validate.checkNotNull(fields, "fields");
        this.name = name;
        this.fields = fields;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int hc = this.name.toLowerCase().hashCode();
            for (ThriftField subField : this.fields) {
                hc ^= subField.hashCode();
            }
            this.hashcode = hc;
        }
        return this.hashcode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ThriftField)) {
            return false;
        }
        ThriftField other = (ThriftField)o;
        if (!this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        if (this.fields.size() != other.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).equals(other.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.join((CharSequence)", ", this.getFieldNames());
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldsList = new ArrayList<String>();
        if (this.fields.size() == 0) {
            fieldsList.add(this.name);
        } else {
            for (ThriftField f : this.fields) {
                for (String subF : f.getFieldNames()) {
                    fieldsList.add(this.name + "." + subF);
                }
            }
        }
        return fieldsList;
    }

    public static List<ThriftField> fromNames(Collection<String> fieldNames) {
        Validate.checkNotNullAndNotEmpty(fieldNames, "fieldNames");
        ArrayList<String> fieldNamesList = new ArrayList<String>(fieldNames);
        Collections.sort(fieldNamesList, String.CASE_INSENSITIVE_ORDER);
        ArrayList<ThriftField> fields = new ArrayList<ThriftField>();
        for (String fieldName : fieldNamesList) {
            String[] tokens;
            List<ThriftField> tfields = fields;
            for (String token : tokens = fieldName.split("\\.")) {
                ThriftField field = ThriftField.findField(token, tfields);
                if (field == null) {
                    field = new ThriftField(token, new ArrayList<ThriftField>(), true);
                    tfields.add(field);
                }
                tfields = field.fields;
            }
        }
        return ThriftField.makeReadOnly(fields);
    }

    private static ThriftField findField(String name, List<ThriftField> fields) {
        for (ThriftField field : fields) {
            if (!field.name.equalsIgnoreCase(name)) continue;
            return field;
        }
        return null;
    }

    private static List<ThriftField> makeReadOnly(List<ThriftField> fields) {
        ArrayList<ThriftField> result = new ArrayList<ThriftField>(fields.size());
        for (ThriftField field : fields) {
            ThriftField copy = new ThriftField(field.name, ThriftField.makeReadOnly(field.fields));
            result.add(copy);
        }
        return Collections.unmodifiableList(result);
    }
}

