/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class RepositoryImpl
implements Repository {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRootDir;
    private boolean myDisposed;

    protected RepositoryImpl(@NotNull Project project, @NotNull VirtualFile dir) {
        if (project == null) {
            RepositoryImpl.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            RepositoryImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRootDir = dir;
    }

    protected RepositoryImpl(@NotNull Project project, @NotNull VirtualFile dir, @NotNull Disposable parentDisposable) {
        if (project == null) {
            RepositoryImpl.$$$reportNull$$$0(2);
        }
        if (dir == null) {
            RepositoryImpl.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            RepositoryImpl.$$$reportNull$$$0(4);
        }
        this(project, dir);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRootDir;
        if (virtualFile == null) {
            RepositoryImpl.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.getRoot().getPresentableUrl();
        if (string == null) {
            RepositoryImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String toString() {
        return this.getPresentableUrl();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RepositoryImpl.$$$reportNull$$$0(7);
        }
        return project;
    }

    public boolean isFresh() {
        return this.getCurrentRevision() == null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repository that = (Repository)o;
        if (!this.getProject().equals((Object)that.getProject())) {
            return false;
        }
        return this.getRoot().equals(that.getRoot());
    }

    public int hashCode() {
        int result = this.getProject().hashCode();
        result = 31 * result + this.getRoot().hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/RepositoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/RepositoryImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

