/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureSet;
import com.jetbrains.mlapi.feature.FeatureSignature;
import com.jetbrains.mlapi.feature.FeaturesValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bJ\u0014\u0010\u000b\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tJ(\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/mlapi/feature/FeaturesValidator;", "", "inputFeatures", "Lcom/jetbrains/mlapi/feature/FeatureSet;", "(Lcom/jetbrains/mlapi/feature/FeatureSet;)V", "requireValidBatch", "", "featuresBatch", "", "", "Lcom/jetbrains/mlapi/feature/Feature;", "requireValidRow", "features", "validateBatch", "", "", "Lcom/jetbrains/mlapi/feature/FeaturesValidator$Result;", "validateRow", "Result", "mlapi-core"})
@SourceDebugExtension(value={"SMAP\nFeaturesValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeaturesValidator.kt\ncom/jetbrains/mlapi/feature/FeaturesValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1477#2:65\n1502#2,3:66\n1505#2,3:76\n1603#2,9:86\n1855#2:95\n1856#2:97\n1612#2:98\n372#3,7:69\n526#3:79\n511#3,6:80\n1#4:96\n*S KotlinDebug\n*F\n+ 1 FeaturesValidator.kt\ncom/jetbrains/mlapi/feature/FeaturesValidator\n*L\n46#1:65\n46#1:66,3\n46#1:76,3\n51#1:86,9\n51#1:95\n51#1:97\n51#1:98\n46#1:69,7\n46#1:79\n46#1:80,6\n51#1:96\n*E\n"})
final class FeaturesValidator {
    @NotNull
    private final FeatureSet inputFeatures;

    public FeaturesValidator(@NotNull FeatureSet inputFeatures2) {
        Intrinsics.checkNotNullParameter((Object)inputFeatures2, (String)"inputFeatures");
        this.inputFeatures = inputFeatures2;
    }

    public final void requireValidRow(@NotNull Collection<? extends Feature> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Result validationInfo = this.validateRow(features);
        if (!validationInfo.isValid()) {
            boolean bl = false;
            String string = "ML model has received inconsistent feature set: \n " + validationInfo;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void requireValidBatch(@NotNull List<? extends Collection<? extends Feature>> featuresBatch) {
        Intrinsics.checkNotNullParameter(featuresBatch, (String)"featuresBatch");
        Map<Integer, Result> validationInfo = this.validateBatch(featuresBatch);
        if (!validationInfo.isEmpty()) {
            boolean bl = false;
            String string = "ML model has received inconsistent feature set: \n " + CollectionsKt.joinToString$default((Iterable)validationInfo.entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)requireValidBatch.1.1.INSTANCE, (int)30, null);
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Result validateRow(Collection<? extends Feature> features) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object it;
        void $this$groupByTo$iv$iv;
        Collection<FeatureSignature> missing = this.inputFeatures.selectMissingFeatures(features);
        Collection<Feature> redundant = this.inputFeatures.selectFeaturesNotFromThis(features);
        Object $this$groupBy$iv = features;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Feature)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map duplicated = destination$iv$iv;
        return new Result(missing, redundant, duplicated);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, Result> validateBatch(List<? extends Collection<? extends Feature>> featuresBatch) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.withIndex((Iterable)featuresBatch);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            int rowI = indexedValue.component1();
            Collection itemFeatures = (Collection)indexedValue.component2();
            Result validationResult = this.validateRow(itemFeatures);
            if ((validationResult.isValid() ? null : TuplesKt.to((Object)rowI, (Object)validationResult)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u001b\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\bH\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\tH\u0016R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/mlapi/feature/FeaturesValidator$Result;", "", "missingFeatures", "", "Lcom/jetbrains/mlapi/feature/FeatureSignature;", "redundantFeatures", "Lcom/jetbrains/mlapi/feature/Feature;", "duplicatedFeatures", "", "", "", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Map;)V", "getDuplicatedFeatures", "()Ljava/util/Map;", "isValid", "", "()Z", "getMissingFeatures", "()Ljava/util/Collection;", "getRedundantFeatures", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "mlapi-core"})
    private static final class Result {
        @NotNull
        private final Collection<FeatureSignature> missingFeatures;
        @NotNull
        private final Collection<Feature> redundantFeatures;
        @NotNull
        private final Map<String, List<Feature>> duplicatedFeatures;

        public Result(@NotNull Collection<? extends FeatureSignature> missingFeatures, @NotNull Collection<? extends Feature> redundantFeatures, @NotNull Map<String, ? extends List<? extends Feature>> duplicatedFeatures) {
            Intrinsics.checkNotNullParameter(missingFeatures, (String)"missingFeatures");
            Intrinsics.checkNotNullParameter(redundantFeatures, (String)"redundantFeatures");
            Intrinsics.checkNotNullParameter(duplicatedFeatures, (String)"duplicatedFeatures");
            this.missingFeatures = missingFeatures;
            this.redundantFeatures = redundantFeatures;
            this.duplicatedFeatures = duplicatedFeatures;
        }

        @NotNull
        public final Collection<FeatureSignature> getMissingFeatures() {
            return this.missingFeatures;
        }

        @NotNull
        public final Collection<Feature> getRedundantFeatures() {
            return this.redundantFeatures;
        }

        @NotNull
        public final Map<String, List<Feature>> getDuplicatedFeatures() {
            return this.duplicatedFeatures;
        }

        public final boolean isValid() {
            return this.missingFeatures.isEmpty() && this.redundantFeatures.isEmpty() && this.duplicatedFeatures.isEmpty();
        }

        @NotNull
        public String toString() {
            List list;
            List $this$toString_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (!this.missingFeatures.isEmpty()) {
                $this$toString_u24lambda_u240.add("Missing: " + this.missingFeatures);
            }
            if (!this.redundantFeatures.isEmpty()) {
                $this$toString_u24lambda_u240.add("Redundant: " + this.redundantFeatures);
            }
            if (!this.duplicatedFeatures.isEmpty()) {
                $this$toString_u24lambda_u240.add("Duplicated: " + this.duplicatedFeatures);
            }
            List infos = CollectionsKt.build((List)list);
            return CollectionsKt.joinToString$default((Iterable)infos, (CharSequence)"\n", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null);
        }

        @NotNull
        public final Collection<FeatureSignature> component1() {
            return this.missingFeatures;
        }

        @NotNull
        public final Collection<Feature> component2() {
            return this.redundantFeatures;
        }

        @NotNull
        public final Map<String, List<Feature>> component3() {
            return this.duplicatedFeatures;
        }

        @NotNull
        public final Result copy(@NotNull Collection<? extends FeatureSignature> missingFeatures, @NotNull Collection<? extends Feature> redundantFeatures, @NotNull Map<String, ? extends List<? extends Feature>> duplicatedFeatures) {
            Intrinsics.checkNotNullParameter(missingFeatures, (String)"missingFeatures");
            Intrinsics.checkNotNullParameter(redundantFeatures, (String)"redundantFeatures");
            Intrinsics.checkNotNullParameter(duplicatedFeatures, (String)"duplicatedFeatures");
            return new Result(missingFeatures, redundantFeatures, duplicatedFeatures);
        }

        public static /* synthetic */ Result copy$default(Result result, Collection collection, Collection collection2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                collection = result.missingFeatures;
            }
            if ((n & 2) != 0) {
                collection2 = result.redundantFeatures;
            }
            if ((n & 4) != 0) {
                map = result.duplicatedFeatures;
            }
            return result.copy(collection, collection2, map);
        }

        public int hashCode() {
            int result = ((Object)this.missingFeatures).hashCode();
            result = result * 31 + ((Object)this.redundantFeatures).hashCode();
            result = result * 31 + ((Object)this.duplicatedFeatures).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual(this.missingFeatures, result.missingFeatures)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.redundantFeatures, result.redundantFeatures)) {
                return false;
            }
            return Intrinsics.areEqual(this.duplicatedFeatures, result.duplicatedFeatures);
        }
    }
}

