/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.GraphCompactionStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.SplineRoutingMode;
import org.eclipse.elk.alg.layered.p5edges.splines.NubSpline;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineEdgeRouter;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineSegment;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class FinalSplineBendpointsCalculator
implements ILayoutProcessor<LGraph> {
    private double edgeEdgeSpacing;
    private double edgeNodeSpacing;
    private SplineRoutingMode splineRoutingMode;
    private GraphCompactionStrategy compactionStrategy;
    private static final double ONE_HALF = 0.5;
    public static final double NODE_TO_STRAIGHTENING_CP_GAP = 5.0;
    private static final double SLOPPY_CENTER_CP_MULTIPLIER = 0.4;

    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        this.edgeEdgeSpacing = graph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        this.edgeNodeSpacing = graph.getProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS);
        this.splineRoutingMode = graph.getProperty(LayeredOptions.EDGE_ROUTING_SPLINES_MODE);
        this.compactionStrategy = graph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_STRATEGY);
        this.indexNodesPerLayer(graph);
        List startEdges = graph.getLayers().stream().flatMap(l -> l.getNodes().stream()).flatMap(n -> StreamSupport.stream(n.getOutgoingEdges().spliterator(), false)).filter(e -> !e.isSelfLoop()).filter(e -> e.hasProperty(InternalProperties.SPLINE_ROUTE_START)).collect(Collectors.toList());
        for (LEdge e2 : startEdges) {
            List<SplineSegment> spline = e2.getProperty(InternalProperties.SPLINE_ROUTE_START);
            spline.forEach(s -> this.calculateControlPoints((SplineSegment)s));
            e2.setProperty(InternalProperties.SPLINE_ROUTE_START, (Object)null);
        }
        for (LEdge e2 : startEdges) {
            LEdge survivingEdge = e2.getProperty(InternalProperties.SPLINE_SURVIVING_EDGE);
            List<LEdge> edgeChain = e2.getProperty(InternalProperties.SPLINE_EDGE_CHAIN);
            this.calculateBezierBendPoints(edgeChain, survivingEdge);
            e2.setProperty(InternalProperties.SPLINE_EDGE_CHAIN, (Object)null);
        }
    }

    private void indexNodesPerLayer(LGraph graph) {
        for (Layer l : graph) {
            int index = 0;
            for (LNode n : l) {
                n.id = index++;
            }
        }
    }

    private void calculateControlPoints(SplineSegment segment) {
        if (segment.handled) {
            return;
        }
        segment.handled = true;
        for (LEdge edge : segment.edges) {
            boolean sloppy;
            if (segment.isStraight && !segment.isHyperEdge()) {
                this.calculateControlPointsStraight(segment);
                continue;
            }
            SplineSegment.EdgeInformation ei = segment.edgeInformation.get(edge);
            if (ei.invertedLeft || ei.invertedRight) {
                this.calculateControlPointsInvertedEdge(edge, segment);
                continue;
            }
            boolean bl = sloppy = this.splineRoutingMode == SplineRoutingMode.SLOPPY && (ei.normalSourceNode || ei.normalTargetNode) && this.segmentAllowsSloppyRouting(segment) && !segment.isHyperEdge();
            if (sloppy) {
                this.calculateControlPointsSloppy(edge, segment);
                continue;
            }
            this.calculateControlPointsConservative(edge, segment);
        }
        if (segment.inverseOrder) {
            segment.edges.forEach(e -> Collections.reverse(e.getBendPoints()));
        }
    }

    private void calculateControlPointsStraight(SplineSegment segment) {
        double xStartPos = segment.boundingBox.x;
        double xEndPos = segment.boundingBox.x + segment.boundingBox.width;
        KVector halfway = new KVector(xStartPos + (xEndPos - xStartPos) / 2.0, segment.centerControlPointY);
        segment.edges.iterator().next().getBendPoints().add(halfway);
    }

    private void calculateControlPointsInvertedEdge(LEdge edge, SplineSegment containingSegment) {
        boolean isHyperedge;
        double startXPos = containingSegment.boundingBox.x;
        double endXPos = containingSegment.boundingBox.x + containingSegment.boundingBox.width;
        SplineSegment.EdgeInformation ei = containingSegment.edgeInformation.get(edge);
        double ySourceAnchor = ei.startY;
        double yTargetAnchor = ei.endY;
        KVector sourceStraightCP = ei.invertedLeft ? new KVector(endXPos, ySourceAnchor) : new KVector(startXPos, ySourceAnchor);
        KVector targetStraightCP = ei.invertedRight ? new KVector(startXPos, yTargetAnchor) : new KVector(endXPos, yTargetAnchor);
        double centerXPos = startXPos;
        if (!containingSegment.isWestOfInitialLayer) {
            centerXPos += this.edgeNodeSpacing;
        }
        KVector sourceVerticalCP = new KVector(centerXPos += containingSegment.xDelta + (double)(containingSegment.rank + 0) * this.edgeEdgeSpacing, ySourceAnchor);
        KVector targetVerticalCP = new KVector(centerXPos, yTargetAnchor);
        edge.getBendPoints().addAll(sourceStraightCP, sourceVerticalCP);
        boolean bl = isHyperedge = containingSegment.edges.size() > 1;
        if (isHyperedge) {
            KVector center = new KVector(centerXPos, containingSegment.centerControlPointY);
            edge.getBendPoints().add(center);
        }
        edge.getBendPoints().addAll(targetVerticalCP, targetStraightCP);
    }

    private void calculateControlPointsConservative(LEdge edge, SplineSegment containingSegment) {
        boolean isHyperedge;
        double startXPos = containingSegment.boundingBox.x;
        double endXPos = containingSegment.boundingBox.x + containingSegment.boundingBox.width;
        SplineSegment.EdgeInformation ei = containingSegment.edgeInformation.get(edge);
        double ySourceAnchor = ei.startY;
        double yTargetAnchor = ei.endY;
        KVector sourceStraightCP = new KVector(startXPos, ySourceAnchor);
        KVector targetStraightCP = new KVector(endXPos, yTargetAnchor);
        double centerXPos = startXPos;
        if (!containingSegment.isWestOfInitialLayer) {
            centerXPos += this.edgeNodeSpacing;
        }
        KVector sourceVerticalCP = new KVector(centerXPos += containingSegment.xDelta + (double)(containingSegment.rank + 0) * this.edgeEdgeSpacing, ySourceAnchor);
        KVector targetVerticalCP = new KVector(centerXPos, yTargetAnchor);
        edge.getBendPoints().addAll(sourceStraightCP, sourceVerticalCP);
        boolean bl = isHyperedge = containingSegment.edges.size() > 1;
        if (isHyperedge) {
            KVector center = new KVector(centerXPos, containingSegment.centerControlPointY);
            edge.getBendPoints().add(center);
        }
        edge.getBendPoints().addAll(targetVerticalCP, targetStraightCP);
    }

    private void calculateControlPointsSloppy(LEdge edge, SplineSegment containingSegment) {
        SplineSegment.EdgeInformation ei = containingSegment.edgeInformation.get(edge);
        assert (ei.normalSourceNode || ei.normalTargetNode);
        double startXPos = containingSegment.boundingBox.x;
        double endXPos = containingSegment.boundingBox.x + containingSegment.boundingBox.width;
        double ySourceAnchor = ei.startY;
        double yTargetAnchor = ei.endY;
        boolean edgePointsDownwards = ySourceAnchor < yTargetAnchor;
        KVector sourceStraightCP = new KVector(startXPos, ySourceAnchor);
        KVector targetStraightCP = new KVector(endXPos, yTargetAnchor);
        double centerXPos = (startXPos + endXPos) / 2.0;
        KVector sourceVerticalCP = new KVector(centerXPos, ySourceAnchor);
        KVector targetVerticalCP = new KVector(centerXPos, yTargetAnchor);
        double centerYPos = this.computeSloppyCenterY(edge, ySourceAnchor, yTargetAnchor);
        KVector v1 = containingSegment.sourcePort.getAbsoluteAnchor();
        KVector v2 = new KVector(centerXPos, centerYPos);
        KVector v3 = containingSegment.targetPort.getAbsoluteAnchor();
        KVector[] approx = ElkMath.approximateBezierSegment(2, v1, v2, v3);
        boolean shortCutSource = false;
        LNode src = containingSegment.sourcePort.getNode();
        if (src != null && src.getLayer() != null && ei.normalSourceNode) {
            boolean needToCheckSrc;
            boolean bl = needToCheckSrc = edgePointsDownwards && src.id < src.getLayer().getNodes().size() - 1 || !edgePointsDownwards && src.id > 0;
            if (!needToCheckSrc) {
                shortCutSource = true;
            } else if (needToCheckSrc) {
                int neighborIndex = src.id;
                neighborIndex = edgePointsDownwards ? ++neighborIndex : --neighborIndex;
                LNode neighbor = src.getLayer().getNodes().get(neighborIndex);
                ElkRectangle box = this.nodeToBoundingBox(neighbor);
                shortCutSource = !ElkMath.intersects(box, v1, approx[0]) && !ElkMath.contains(box, v1, approx[0]);
            }
        }
        boolean shortCutTarget = false;
        LNode tgt = containingSegment.targetPort.getNode();
        if (tgt != null && tgt.getLayer() != null && ei.normalTargetNode) {
            boolean needToCheckTgt;
            boolean bl = needToCheckTgt = edgePointsDownwards && tgt.id > 0 || !edgePointsDownwards && tgt.id < tgt.getLayer().getNodes().size() - 1;
            if (!needToCheckTgt) {
                shortCutTarget = true;
            } else {
                int neighborIndex = tgt.id;
                neighborIndex = edgePointsDownwards ? --neighborIndex : ++neighborIndex;
                LNode neighbor = tgt.getLayer().getNodes().get(neighborIndex);
                ElkRectangle box = this.nodeToBoundingBox(neighbor);
                boolean bl2 = shortCutTarget = !ElkMath.intersects(box, approx[0], v3) && !ElkMath.contains(box, approx[0], v3);
            }
        }
        if (shortCutSource && shortCutTarget) {
            edge.getBendPoints().add(v2);
        }
        if (!shortCutSource) {
            edge.getBendPoints().addAll(sourceStraightCP, sourceVerticalCP);
        }
        if (!shortCutTarget) {
            edge.getBendPoints().addAll(targetVerticalCP, targetStraightCP);
        }
    }

    private ElkRectangle nodeToBoundingBox(LNode node) {
        KVector pos = node.getPosition();
        KVector size = node.getSize();
        LMargin m = node.getMargin();
        return new ElkRectangle(pos.x - m.left, pos.y - m.top, size.x + m.getHorizontal(), size.y + m.getVertical());
    }

    private double computeSloppyCenterY(LEdge edge, double ySourceAnchor, double yTargetAnchor) {
        int indegree = 0;
        int outdegree = 0;
        if (edge.getSource() != null) {
            for (LPort port : edge.getTarget().getNode().getPorts()) {
                indegree += port.getIncomingEdges().size();
            }
        } else {
            indegree = 1;
        }
        if (edge.getTarget() != null) {
            for (LPort port : edge.getSource().getNode().getPorts()) {
                outdegree += port.getOutgoingEdges().size();
            }
        } else {
            outdegree = 1;
        }
        int degreeDiff = (int)Math.signum(outdegree - indegree);
        double centerYPos = (yTargetAnchor + ySourceAnchor) / 2.0 + (yTargetAnchor - ySourceAnchor) * (0.4 * (double)degreeDiff);
        return centerYPos;
    }

    private void calculateBezierBendPoints(List<LEdge> edgeChain, LEdge survivingEdge) {
        if (edgeChain.isEmpty()) {
            return;
        }
        KVectorChain allCP = new KVectorChain();
        LEdge edge = survivingEdge != null ? survivingEdge : edgeChain.get(0);
        LPort sourcePort = edge.getSource();
        if (!SplineEdgeRouter.isQualifiedAsStartingNode(sourcePort.getNode())) {
            throw new IllegalArgumentException("The target node of the edge must be a normal node or a northSouthPort.");
        }
        allCP.addLast(sourcePort.getAbsoluteAnchor());
        if (PortSide.SIDES_NORTH_SOUTH.contains((Object)sourcePort.getSide())) {
            double y = sourcePort.getProperty(InternalProperties.SPLINE_NS_PORT_Y_COORD);
            KVector northSouthCP = new KVector(sourcePort.getAbsoluteAnchor().x, y);
            allCP.addLast(northSouthCP);
        }
        KVector lastCP = null;
        boolean addMidPoint = false;
        for (LEdge currentEdge : edgeChain) {
            KVectorChain currentBendPoints = currentEdge.getBendPoints();
            if (currentBendPoints.isEmpty()) continue;
            if (addMidPoint) {
                KVector halfway = lastCP.add((KVector)currentBendPoints.getFirst()).scale(0.5);
                allCP.addLast(halfway);
                addMidPoint = false;
            } else {
                addMidPoint = true;
            }
            lastCP = ((KVector)currentBendPoints.getLast()).clone();
            allCP.addAll(currentBendPoints);
            currentBendPoints.clear();
        }
        LPort targetPort = edge.getTarget();
        if (PortSide.SIDES_NORTH_SOUTH.contains((Object)targetPort.getSide())) {
            double y = targetPort.getProperty(InternalProperties.SPLINE_NS_PORT_Y_COORD);
            KVector northSouthCP = new KVector(targetPort.getAbsoluteAnchor().x, y);
            allCP.addLast(northSouthCP);
        }
        allCP.addLast(targetPort.getAbsoluteAnchor());
        if (this.splineRoutingMode == SplineRoutingMode.CONSERVATIVE) {
            this.insertStraighteningControlPoints(allCP, sourcePort, targetPort);
        }
        NubSpline nubSpline = new NubSpline(true, 3, allCP);
        edge.getBendPoints().addAll(nubSpline.getBezierCP());
    }

    private void insertStraighteningControlPoints(KVectorChain allCPs, LPort srcPort, LPort tgtPort) {
        KVector first = (KVector)allCPs.getFirst();
        KVector second = (KVector)allCPs.get(1);
        KVector v = new KVector(SplinesMath.portSideToDirection(srcPort.getSide()));
        v.scale(5.0);
        KVector v2 = second.clone().sub(first);
        KVector straightenBeginning = new KVector(this.absMin(v.x, v2.x), this.absMin(v.y, v2.y));
        straightenBeginning.add(first);
        allCPs.add(1, straightenBeginning);
        KVector last = (KVector)allCPs.getLast();
        KVector secondLast = (KVector)allCPs.get(allCPs.size() - 2);
        v = new KVector(SplinesMath.portSideToDirection(tgtPort.getSide()));
        v.scale(5.0);
        v2 = secondLast.clone().sub(last);
        KVector straightenEnding = new KVector(this.absMin(v.x, v2.x), this.absMin(v.y, v2.y));
        straightenEnding.add(last);
        allCPs.add(allCPs.size() - 1, straightenEnding);
    }

    private double absMin(double d1, double d2) {
        if (Math.abs(d1) < Math.abs(d2)) {
            return d1;
        }
        return d2;
    }

    private boolean segmentAllowsSloppyRouting(SplineSegment segment) {
        double t;
        LNode n;
        double nodeSegmentDistance;
        if (this.compactionStrategy == GraphCompactionStrategy.NONE) {
            return true;
        }
        double startXPos = segment.boundingBox.x;
        double endXPos = segment.boundingBox.x + segment.boundingBox.width;
        if (segment.initialSegment && (nodeSegmentDistance = startXPos - (n.getPosition().x + n.getSize().x)) > (t = this.segmentNodeDistanceThreshold(n = segment.sourceNode))) {
            return false;
        }
        return !segment.lastSegment || !((nodeSegmentDistance = n.getPosition().x - endXPos) > (t = this.segmentNodeDistanceThreshold(n = segment.targetNode)));
    }

    private double segmentNodeDistanceThreshold(LNode n) {
        return n.getLayer().getSize().x - n.getSize().x / 2.0;
    }
}

