/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.aggregations.CompositeValuesSource;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CompositeDateHistogramAggregationSource
extends CompositeValuesSource
implements ToCopyableBuilder<Builder, CompositeDateHistogramAggregationSource> {
    @Nullable
    private final Time calendarInterval;
    @Nullable
    private final Time fixedInterval;
    @Nullable
    private final String format;
    @Nullable
    private final Time offset;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<CompositeDateHistogramAggregationSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeDateHistogramAggregationSource::setupCompositeDateHistogramAggregationSourceDeserializer);

    private CompositeDateHistogramAggregationSource(Builder builder) {
        super(builder);
        this.calendarInterval = builder.calendarInterval;
        this.fixedInterval = builder.fixedInterval;
        this.format = builder.format;
        this.offset = builder.offset;
        this.timeZone = builder.timeZone;
    }

    public static CompositeDateHistogramAggregationSource of(Function<Builder, ObjectBuilder<CompositeDateHistogramAggregationSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time calendarInterval() {
        return this.calendarInterval;
    }

    @Nullable
    public final Time fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Time offset() {
        return this.offset;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.calendarInterval != null) {
            generator.writeKey("calendar_interval");
            this.calendarInterval.serialize(generator, mapper);
        }
        if (this.fixedInterval != null) {
            generator.writeKey("fixed_interval");
            this.fixedInterval.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            this.offset.serialize(generator, mapper);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCompositeDateHistogramAggregationSourceDeserializer(ObjectDeserializer<Builder> op) {
        CompositeDateHistogramAggregationSource.setupCompositeValuesSourceDeserializer(op);
        op.add(Builder::calendarInterval, Time._DESERIALIZER, "calendar_interval");
        op.add(Builder::fixedInterval, Time._DESERIALIZER, "fixed_interval");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::offset, Time._DESERIALIZER, "offset");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.calendarInterval);
        result = 31 * result + Objects.hashCode(this.fixedInterval);
        result = 31 * result + Objects.hashCode(this.format);
        result = 31 * result + Objects.hashCode(this.offset);
        result = 31 * result + Objects.hashCode(this.timeZone);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeDateHistogramAggregationSource other = (CompositeDateHistogramAggregationSource)o;
        return Objects.equals(this.calendarInterval, other.calendarInterval) && Objects.equals(this.fixedInterval, other.fixedInterval) && Objects.equals(this.format, other.format) && Objects.equals(this.offset, other.offset) && Objects.equals(this.timeZone, other.timeZone);
    }

    public static class Builder
    extends CompositeValuesSource.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CompositeDateHistogramAggregationSource> {
        @Nullable
        private Time calendarInterval;
        @Nullable
        private Time fixedInterval;
        @Nullable
        private String format;
        @Nullable
        private Time offset;
        @Nullable
        private String timeZone;

        public Builder() {
        }

        private Builder(CompositeDateHistogramAggregationSource o) {
            super(o);
            this.calendarInterval = o.calendarInterval;
            this.fixedInterval = o.fixedInterval;
            this.format = o.format;
            this.offset = o.offset;
            this.timeZone = o.timeZone;
        }

        private Builder(Builder o) {
            super(o);
            this.calendarInterval = o.calendarInterval;
            this.fixedInterval = o.fixedInterval;
            this.format = o.format;
            this.offset = o.offset;
            this.timeZone = o.timeZone;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder calendarInterval(@Nullable Time value) {
            this.calendarInterval = value;
            return this;
        }

        @Nonnull
        public final Builder calendarInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.calendarInterval(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder fixedInterval(@Nullable Time value) {
            this.fixedInterval = value;
            return this;
        }

        @Nonnull
        public final Builder fixedInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.fixedInterval(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Nonnull
        public final Builder offset(@Nullable Time value) {
            this.offset = value;
            return this;
        }

        @Nonnull
        public final Builder offset(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.offset(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        @Nonnull
        public CompositeDateHistogramAggregationSource build() {
            this._checkSingleUse();
            return new CompositeDateHistogramAggregationSource(this);
        }
    }
}

