/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstanceLimitPrice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstanceLimitPrice> {
    private static final SdkField<Double> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Amount").getter(ReservedInstanceLimitPrice.getter(ReservedInstanceLimitPrice::amount)).setter(ReservedInstanceLimitPrice.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").unmarshallLocationName("amount").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservedInstanceLimitPrice.getter(ReservedInstanceLimitPrice::currencyCodeAsString)).setter(ReservedInstanceLimitPrice.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").unmarshallLocationName("currencyCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, CURRENCY_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedInstanceLimitPrice.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double amount;
    private final String currencyCode;

    private ReservedInstanceLimitPrice(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    public final Double amount() {
        return this.amount;
    }

    public final CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstanceLimitPrice)) {
            return false;
        }
        ReservedInstanceLimitPrice other = (ReservedInstanceLimitPrice)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedInstanceLimitPrice").add("Amount", (Object)this.amount()).add("CurrencyCode", (Object)this.currencyCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Amount", AMOUNT_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstanceLimitPrice, T> g) {
        return obj -> g.apply((ReservedInstanceLimitPrice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double amount;
        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstanceLimitPrice model) {
            this.amount(model.amount);
            this.currencyCode(model.currencyCode);
        }

        public final Double getAmount() {
            return this.amount;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public ReservedInstanceLimitPrice build() {
            return new ReservedInstanceLimitPrice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstanceLimitPrice> {
        public Builder amount(Double var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);
    }
}

