RSpec.shared_examples 'TimeBasedBlind' do |sqli_class|
  let(:datastore) { instance_double(::Msf::DataStore) }
  let(:timebased_class) do
    sqli_class
  end
  let(:datastore) do
    { 'SqliDelay' => 1.0 }
  end
  let(:query_proc) do
    proc do |payload|
      delay = payload[/\d+(?:.?\d*)?/].to_f
      Timecop.travel(Time.now + delay)
    end
  end
  let(:sqli_obj) do
    timebased_class.new(datastore, {}, {}, &query_proc)
  end
  context '#blind_request' do
    it "Should return true if the block takes more than datastore['SqliDelay'] to run" do
      expect(sqli_obj.send(:blind_request, 'sleep(1.3)')).to eql true
      expect(sqli_obj.send(:blind_request, 'sleep(0.5)')).to eql false
      expect(sqli_obj.send(:blind_request, 'sleep(0)')).to eql false
    end
  end
end
