#!/bin/bash
#
#   zipkmod.sh - Compress kernel modules
#
#   Copyright (c) 2024 Pacman Development Team <pacman-dev@lists.archlinux.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

[[ -n "$LIBMAKEPKG_TIDY_ZIPKMOD_SH" ]] && return
LIBMAKEPKG_TIDY_ZIPKMOD_SH=1

MAKEPKG_LIBRARY=${MAKEPKG_LIBRARY:-'/usr/share/makepkg'}

source "$MAKEPKG_LIBRARY/util/message.sh"
source "$MAKEPKG_LIBRARY/util/option.sh"


packaging_options+=('zipkmod')
tidy_modify+=('tidy_zipkmod')

tidy_zipkmod() {
    if check_option "zipkmod" "y" && [ -e "$PWD/usr/lib/modules" ]; then
        msg2 "Compressing kernel modules..."
        ZSTD_CLEVEL=19 ZSTD_NBTHREADS="$NPROC" find ./usr/lib/modules  -type f -name '*.ko' -exec zstd --rm -f -q {} +
    fi
}
