/* SPDX-FileCopyrightText: 2025 - Sébastien Wilmet
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#ifndef TEPL_CODE_COMMENT_VIEW_H
#define TEPL_CODE_COMMENT_VIEW_H

#if !defined (TEPL_H_INSIDE) && !defined (TEPL_COMPILATION)
#error "Only <tepl/tepl.h> can be included directly."
#endif

#include <gtksourceview/gtksource.h>

G_BEGIN_DECLS

#define TEPL_TYPE_CODE_COMMENT_VIEW             (tepl_code_comment_view_get_type ())
#define TEPL_CODE_COMMENT_VIEW(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), TEPL_TYPE_CODE_COMMENT_VIEW, TeplCodeCommentView))
#define TEPL_CODE_COMMENT_VIEW_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), TEPL_TYPE_CODE_COMMENT_VIEW, TeplCodeCommentViewClass))
#define TEPL_IS_CODE_COMMENT_VIEW(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TEPL_TYPE_CODE_COMMENT_VIEW))
#define TEPL_IS_CODE_COMMENT_VIEW_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), TEPL_TYPE_CODE_COMMENT_VIEW))
#define TEPL_CODE_COMMENT_VIEW_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), TEPL_TYPE_CODE_COMMENT_VIEW, TeplCodeCommentViewClass))

typedef struct _TeplCodeCommentView         TeplCodeCommentView;
typedef struct _TeplCodeCommentViewClass    TeplCodeCommentViewClass;
typedef struct _TeplCodeCommentViewPrivate  TeplCodeCommentViewPrivate;

struct _TeplCodeCommentView
{
	GObject parent;

	TeplCodeCommentViewPrivate *priv;
};

struct _TeplCodeCommentViewClass
{
	GObjectClass parent_class;

	gpointer padding[12];
};

G_MODULE_EXPORT
GType			tepl_code_comment_view_get_type				(void);

G_MODULE_EXPORT
TeplCodeCommentView *	tepl_code_comment_view_new				(GtkSourceView *view);

G_MODULE_EXPORT
GtkSourceView *		tepl_code_comment_view_get_source_view			(TeplCodeCommentView *code_comment_view);

G_MODULE_EXPORT
gboolean		tepl_code_comment_view_code_comment_is_supported	(TeplCodeCommentView *code_comment_view);

G_MODULE_EXPORT
void			tepl_code_comment_view_comment_lines			(TeplCodeCommentView *code_comment_view,
										 const GtkTextIter   *start_iter,
										 const GtkTextIter   *end_iter);

G_MODULE_EXPORT
void			tepl_code_comment_view_comment_selected_lines		(TeplCodeCommentView *code_comment_view);

G_MODULE_EXPORT
void			tepl_code_comment_view_uncomment_selection		(TeplCodeCommentView *code_comment_view);

G_END_DECLS

#endif /* TEPL_CODE_COMMENT_VIEW_H */
