/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.RowsMapping;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SimpleGraphInfo<CommitId>
implements PermanentGraphInfo<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final GraphLayout myGraphLayout;
    @NotNull
    private final Set<Integer> myBranchNodeIds;
    @NotNull
    private final RowsMapping<CommitId> myRowsMapping;

    private SimpleGraphInfo(@NotNull LinearGraph linearGraph, @NotNull GraphLayout graphLayout, @NotNull Set<Integer> branchNodeIds, @NotNull RowsMapping<CommitId> rowsMapping) {
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(0);
        }
        if (graphLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(1);
        }
        if (branchNodeIds == null) {
            SimpleGraphInfo.$$$reportNull$$$0(2);
        }
        if (rowsMapping == null) {
            SimpleGraphInfo.$$$reportNull$$$0(3);
        }
        this.myLinearGraph = linearGraph;
        this.myGraphLayout = graphLayout;
        this.myBranchNodeIds = branchNodeIds;
        this.myRowsMapping = rowsMapping;
    }

    public static <CommitId> SimpleGraphInfo<CommitId> build(@NotNull LinearGraph linearGraph, @NotNull GraphLayout oldLayout, @NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int permanentGraphSize, @NotNull Set<Integer> branchNodeIds, int visibleRow, int visibleRange) {
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(4);
        }
        if (oldLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(5);
        }
        if (permanentCommitsInfo == null) {
            SimpleGraphInfo.$$$reportNull$$$0(6);
        }
        if (branchNodeIds == null) {
            SimpleGraphInfo.$$$reportNull$$$0(7);
        }
        int start = Math.max(0, visibleRow - visibleRange);
        int end = Math.min(linearGraph.nodesCount(), start + 2 * visibleRange);
        RowsMapping<CommitId> rowsMapping = new RowsMapping<CommitId>(end - start, permanentCommitsInfo.getCommitId(0) instanceof Integer);
        ArrayList<GraphCommit<CommitId>> graphCommits = new ArrayList<GraphCommit<CommitId>>(end - start);
        for (int row = start; row < end; ++row) {
            int nodeId = linearGraph.getNodeId(row);
            CommitId commit = permanentCommitsInfo.getCommitId(nodeId);
            SmartList parents = new SmartList();
            parents.addAll(ContainerUtil.mapNotNull(LinearGraphUtils.asLiteLinearGraph(linearGraph).getNodes(row, LiteLinearGraph.NodeFilter.DOWN), row1 -> {
                if (row1 < start || row1 >= end) {
                    return null;
                }
                return permanentCommitsInfo.getCommitId(linearGraph.getNodeId((int)row1));
            }));
            long timestamp = permanentCommitsInfo.getTimestamp(nodeId);
            rowsMapping.add(commit, timestamp);
            graphCommits.add(GraphCommitImpl.createCommit(commit, parents, timestamp));
        }
        PermanentLinearGraphImpl newLinearGraph = PermanentLinearGraphBuilder.newInstance(graphCommits).build();
        int[] layoutIndexes = new int[end - start];
        IntArrayList headNodeIndexes = new IntArrayList();
        Object2IntMap<CommitId> commitIdToInteger = SimpleGraphInfo.reverseCommitIdMap(permanentCommitsInfo, permanentGraphSize);
        for (int row = start; row < end; ++row) {
            int layoutIndex;
            Object commitId = ((GraphCommit)graphCommits.get(row - start)).getId();
            layoutIndexes[row - start] = layoutIndex = oldLayout.getLayoutIndex(commitIdToInteger.getInt(commitId));
            if (!LinearGraphUtils.asLiteLinearGraph(newLinearGraph).getNodes(row - start, LiteLinearGraph.NodeFilter.UP).isEmpty()) continue;
            headNodeIndexes.add(row - start);
        }
        ContainerUtil.sort((List)headNodeIndexes, Comparator.comparingInt(o -> layoutIndexes[o]));
        GraphLayoutImpl newLayout = new GraphLayoutImpl(layoutIndexes, (IntList)headNodeIndexes);
        return new SimpleGraphInfo(newLinearGraph, newLayout, LinearGraphUtils.convertIdsToNodeIndexes(linearGraph, branchNodeIds), rowsMapping);
    }

    @NotNull
    private static <CommitId> Object2IntMap<CommitId> reverseCommitIdMap(@NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int size) {
        if (permanentCommitsInfo == null) {
            SimpleGraphInfo.$$$reportNull$$$0(8);
        }
        Object2IntOpenHashMap result = new Object2IntOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            result.put(permanentCommitsInfo.getCommitId(i), i);
        }
        Object2IntOpenHashMap object2IntOpenHashMap = result;
        if (object2IntOpenHashMap == null) {
            SimpleGraphInfo.$$$reportNull$$$0(9);
        }
        return object2IntOpenHashMap;
    }

    @Override
    @NotNull
    public PermanentCommitsInfo<CommitId> getPermanentCommitsInfo() {
        return new PermanentCommitsInfo<CommitId>(){

            @Override
            @NotNull
            public CommitId getCommitId(int nodeId) {
                Object CommitId = SimpleGraphInfo.this.myRowsMapping.getCommitId(nodeId);
                if (CommitId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return CommitId;
            }

            @Override
            public long getTimestamp(int nodeId) {
                return SimpleGraphInfo.this.myRowsMapping.getTimestamp(nodeId);
            }

            @Override
            public int getNodeId(@NotNull CommitId commitId) {
                if (commitId == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!SimpleGraphInfo.this.myRowsMapping.getCommitId(id).equals(commitId)) continue;
                    return id;
                }
                return -1;
            }

            @Override
            @NotNull
            public Set<Integer> convertToNodeIds(@NotNull Collection<? extends CommitId> commitIds) {
                if (commitIds == null) {
                    1.$$$reportNull$$$0(2);
                }
                HashSet<Integer> result = new HashSet<Integer>();
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!commitIds.contains(SimpleGraphInfo.this.myRowsMapping.getCommitId(id))) continue;
                    result.add(id);
                }
                HashSet<Integer> hashSet = result;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(3);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commitId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commitIds";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommitId";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertToNodeIds";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getNodeId";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "convertToNodeIds";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Override
    @NotNull
    public LinearGraph getLinearGraph() {
        LinearGraph linearGraph = this.myLinearGraph;
        if (linearGraph == null) {
            SimpleGraphInfo.$$$reportNull$$$0(10);
        }
        return linearGraph;
    }

    @Override
    @NotNull
    public GraphLayout getPermanentGraphLayout() {
        GraphLayout graphLayout = this.myGraphLayout;
        if (graphLayout == null) {
            SimpleGraphInfo.$$$reportNull$$$0(11);
        }
        return graphLayout;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set = this.myBranchNodeIds;
        if (set == null) {
            SimpleGraphInfo.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphLayout";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNodeIds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowsMapping";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldLayout";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentCommitsInfo";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/SimpleGraphInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseCommitIdMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinearGraph";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentGraphLayout";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reverseCommitIdMap";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

