/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import com.intellij.internal.statistic.eventLog.validator.GroupValidators;
import com.intellij.internal.statistic.eventLog.validator.ValidationRuleStorage;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRulesFactory;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import com.jetbrains.fus.reporting.model.metadata.RecorderValidationData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BC\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010!\u001a\u00020\u0011H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010$\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020\u0011H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0005H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/SimpleValidationRuleStorage;", "T", "", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationRuleStorage;", "initialMetadata", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "buildParser", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventLogBuildParser;", "excludedFields", "", "", "utilRulesProducer", "Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/UtilRuleProducer;", "dictionaryStorage", "Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;", "(Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventLogBuildParser;Ljava/util/List;Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/UtilRuleProducer;Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;)V", "clientDataValidators", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidationRule;", "getDictionaryStorage", "()Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;", "eventsValidators", "", "Lcom/intellij/internal/statistic/eventLog/validator/rules/beans/EventGroupRules;", "filterRules", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventGroupsFilterRules;", "idsValidators", "lock", "", "getLock", "()Ljava/lang/Object;", "systemDataValidators", "validationRuleFactory", "Lcom/intellij/internal/statistic/eventLog/validator/rules/utils/ValidationSimpleRuleFactory;", "getClientDataRulesRevisions", "getGroupValidators", "Lcom/intellij/internal/statistic/eventLog/validator/GroupValidators;", "groupId", "getIdsRulesRevisions", "getSystemDataRulesRevisions", "internalUpdate", "", "descriptors", "isUnreachable", "", "update", "metadata", "ap-validation"})
public class SimpleValidationRuleStorage<T extends Comparable<? super T>>
implements ValidationRuleStorage<T> {
    @NotNull
    private final EventLogBuildParser<T> buildParser;
    @NotNull
    private final List<String> excludedFields;
    @Nullable
    private final DictionaryStorage dictionaryStorage;
    @NotNull
    private final ValidationSimpleRuleFactory validationRuleFactory;
    @NotNull
    private final Object lock;
    @NotNull
    private final Map<String, EventGroupRules> eventsValidators;
    private EventGroupsFilterRules<T> filterRules;
    private RecorderDataValidationRule clientDataValidators;
    private RecorderDataValidationRule systemDataValidators;
    private RecorderDataValidationRule idsValidators;

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser, @NotNull List<String> excludedFields, @NotNull UtilRuleProducer utilRulesProducer, @Nullable DictionaryStorage dictionaryStorage) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        Intrinsics.checkNotNullParameter(excludedFields, (String)"excludedFields");
        Intrinsics.checkNotNullParameter((Object)utilRulesProducer, (String)"utilRulesProducer");
        this.buildParser = buildParser;
        this.excludedFields = excludedFields;
        this.dictionaryStorage = dictionaryStorage;
        this.validationRuleFactory = new ValidationSimpleRuleFactory(utilRulesProducer);
        this.lock = new Object();
        this.eventsValidators = new HashMap();
        this.internalUpdate(initialMetadata);
    }

    public /* synthetic */ SimpleValidationRuleStorage(EventGroupRemoteDescriptors eventGroupRemoteDescriptors, EventLogBuildParser eventLogBuildParser, List list, UtilRuleProducer utilRuleProducer, DictionaryStorage dictionaryStorage, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            UtilRuleProducer utilRuleProducer2 = ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER;
            Intrinsics.checkNotNullExpressionValue((Object)utilRuleProducer2, (String)"REJECTING_UTIL_URL_PRODUCER");
            utilRuleProducer = utilRuleProducer2;
        }
        if ((n & 0x10) != 0) {
            dictionaryStorage = null;
        }
        this(eventGroupRemoteDescriptors, eventLogBuildParser, list, utilRuleProducer, dictionaryStorage);
    }

    @Override
    @Nullable
    public DictionaryStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @NotNull
    protected final Object getLock() {
        return this.lock;
    }

    public void update(@NotNull EventGroupRemoteDescriptors metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.internalUpdate(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public GroupValidators<T> getGroupValidators(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            EventGroupsFilterRules<T> eventGroupsFilterRules = this.filterRules;
            if (eventGroupsFilterRules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filterRules");
                eventGroupsFilterRules = null;
            }
            GroupValidators<T> groupValidators = new GroupValidators<T>(this.eventsValidators.get(groupId), eventGroupsFilterRules);
            return groupValidators;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RecorderDataValidationRule getClientDataRulesRevisions() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            RecorderDataValidationRule recorderDataValidationRule = this.clientDataValidators;
            if (recorderDataValidationRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clientDataValidators");
                recorderDataValidationRule = null;
            }
            RecorderDataValidationRule recorderDataValidationRule2 = recorderDataValidationRule;
            return recorderDataValidationRule2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RecorderDataValidationRule getSystemDataRulesRevisions() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            RecorderDataValidationRule recorderDataValidationRule = this.systemDataValidators;
            if (recorderDataValidationRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"systemDataValidators");
                recorderDataValidationRule = null;
            }
            RecorderDataValidationRule recorderDataValidationRule2 = recorderDataValidationRule;
            return recorderDataValidationRule2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RecorderDataValidationRule getIdsRulesRevisions() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            RecorderDataValidationRule recorderDataValidationRule = this.idsValidators;
            if (recorderDataValidationRule == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"idsValidators");
                recorderDataValidationRule = null;
            }
            RecorderDataValidationRule recorderDataValidationRule2 = recorderDataValidationRule;
            return recorderDataValidationRule2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalUpdate(EventGroupRemoteDescriptors descriptors) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.eventsValidators.clear();
            this.eventsValidators.putAll(this.createValidators(descriptors, this.validationRuleFactory, this.excludedFields));
            EventGroupsFilterRules<T> eventGroupsFilterRules = EventGroupsFilterRules.create(descriptors, this.buildParser);
            Intrinsics.checkNotNullExpressionValue(eventGroupsFilterRules, (String)"create(descriptors, buildParser)");
            this.filterRules = eventGroupsFilterRules;
            this.clientDataValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, (List<RecorderValidationData>)descriptors.client_data, descriptors.rules, this.getDictionaryStorage());
            this.systemDataValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, (List<RecorderValidationData>)descriptors.system_data, descriptors.rules, this.getDictionaryStorage());
            this.idsValidators = RecorderDataValidationRulesFactory.INSTANCE.create(this.validationRuleFactory, (List<RecorderValidationData>)descriptors.ids, descriptors.rules, this.getDictionaryStorage());
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean isUnreachable() {
        return false;
    }

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser, @NotNull List<String> excludedFields, @NotNull UtilRuleProducer utilRulesProducer) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        Intrinsics.checkNotNullParameter(excludedFields, (String)"excludedFields");
        Intrinsics.checkNotNullParameter((Object)utilRulesProducer, (String)"utilRulesProducer");
        this(initialMetadata, buildParser, excludedFields, utilRulesProducer, null, 16, null);
    }

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser, @NotNull List<String> excludedFields) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        Intrinsics.checkNotNullParameter(excludedFields, (String)"excludedFields");
        this(initialMetadata, buildParser, excludedFields, null, null, 24, null);
    }

    @JvmOverloads
    public SimpleValidationRuleStorage(@NotNull EventGroupRemoteDescriptors initialMetadata, @NotNull EventLogBuildParser<T> buildParser) {
        Intrinsics.checkNotNullParameter((Object)initialMetadata, (String)"initialMetadata");
        Intrinsics.checkNotNullParameter(buildParser, (String)"buildParser");
        this(initialMetadata, buildParser, null, null, null, 28, null);
    }
}

