/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.macros;

import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.idea.base.plugin.KotlinBasePluginBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.macros.KotlinBundledRefresher;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"downloadKotlinDistIfNeeded", "", "isKotlinBundledPotentiallyUsedInLibraries", "", "version", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
public final class KotlinDistAutomaticDownloaderForKotlinBundledKt {
    private static final void downloadKotlinDistIfNeeded(boolean isKotlinBundledPotentiallyUsedInLibraries, @NlsSafe String version, Project project) {
        if (!StringsKt.isBlank((CharSequence)version) && isKotlinBundledPotentiallyUsedInLibraries && !KotlinArtifactsDownloader.INSTANCE.isKotlinDistInitialized(version)) {
            String string = KotlinBasePluginBundle.message("progress.text.downloading.kotlinc.dist", new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, version, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $version;
                {
                    this.$project = $project;
                    this.$version = $version;
                    super($project, $super_call_param$1, true);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    File dist = KotlinArtifactsDownloader.INSTANCE.lazyDownloadAndUnpackKotlincDist(this.$project, this.$version, indicator);
                    if (dist == null) {
                        NotificationGroupManager.getInstance().getNotificationGroup("Kotlin dist downloading failed").createNotification(KotlinBasePluginBundle.message("kotlin.dist.downloading.failed", new Object[0]), KotlinArtifactsDownloader.INSTANCE.failedToDownloadUnbundledJpsMavenArtifact(this.$project, "kotlin-dist-for-jps-meta", this.$version), NotificationType.ERROR).setImportant(true).setIcon(AllIcons.Ide.FatalError).notify(this.$project);
                    } else {
                        Path path2 = dist.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                        KotlinBundledRefresher.Companion.requestKotlinDistRefresh(path2);
                    }
                }
            });
        }
    }

    public static final /* synthetic */ void access$downloadKotlinDistIfNeeded(boolean isKotlinBundledPotentiallyUsedInLibraries, String version, Project project) {
        KotlinDistAutomaticDownloaderForKotlinBundledKt.downloadKotlinDistIfNeeded(isKotlinBundledPotentiallyUsedInLibraries, version, project);
    }
}

