/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.pullUp;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaRenderer;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaErrorType;
import org.jetbrains.kotlin.analysis.api.types.KaSubstitutor;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a&\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0011H\u0000\u00a8\u0006\u0012"}, d2={"createSuperTypeEntryForAddition", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "delegator", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "substitutor", "Lorg/jetbrains/kotlin/analysis/api/types/KaSubstitutor;", "computeAndRenderReturnType", "", "originalCallableSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "copiedDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "makeAbstract", "", "member", "Lorg/jetbrains/kotlin/psi/KtClass;", "intellij.kotlin.refactorings"})
public final class PullUpUtilsKt {
    @Nullable
    public static final KtSuperTypeListEntry createSuperTypeEntryForAddition(@NotNull KaSession $this$createSuperTypeEntryForAddition, @NotNull KtSuperTypeListEntry delegator, @NotNull KtClassOrObject targetClass, @NotNull KaSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter((Object)$this$createSuperTypeEntryForAddition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Object object = delegator.getTypeReference();
        if (object == null || (object = $this$createSuperTypeEntryForAddition.getType((KtTypeReference)object)) == null) {
            return null;
        }
        Object referencedType = object;
        KaClassSymbol kaClassSymbol = $this$createSuperTypeEntryForAddition.getExpandedSymbol((KaType)referencedType);
        if (kaClassSymbol == null) {
            return null;
        }
        KaClassSymbol referencedClass = kaClassSymbol;
        KaDeclarationSymbol kaDeclarationSymbol = $this$createSuperTypeEntryForAddition.getSymbol((KtDeclaration)targetClass);
        KaClassSymbol kaClassSymbol2 = kaDeclarationSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaDeclarationSymbol : null;
        if (kaClassSymbol2 == null) {
            return null;
        }
        KaClassSymbol targetClassSymbol = kaClassSymbol2;
        if (Intrinsics.areEqual((Object)targetClassSymbol, (Object)referencedClass) || $this$createSuperTypeEntryForAddition.isDirectSubClassOf(targetClassSymbol, referencedClass)) {
            return null;
        }
        KaType typeInTargetClass = substitutor2.substitute((KaType)referencedType);
        if (typeInTargetClass instanceof KaErrorType) {
            return null;
        }
        String renderedType = KaRenderer.render$default($this$createSuperTypeEntryForAddition, typeInTargetClass, null, Variance.INVARIANT, 1, null);
        Project project = targetClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (KtSuperTypeListEntry)new KtPsiFactory(project, false, 2, null).createSuperTypeEntry(renderedType);
    }

    @Nullable
    public static final String computeAndRenderReturnType(@NotNull KaSession $this$computeAndRenderReturnType, @NotNull KaCallableSymbol originalCallableSymbol, @NotNull KtCallableDeclaration copiedDeclaration, @NotNull KaSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter((Object)$this$computeAndRenderReturnType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalCallableSymbol, (String)"originalCallableSymbol");
        Intrinsics.checkNotNullParameter((Object)copiedDeclaration, (String)"copiedDeclaration");
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        if (copiedDeclaration.getTypeReference() != null) {
            return null;
        }
        KaType returnType = originalCallableSymbol.getReturnType();
        returnType = returnType instanceof KaErrorType ? $this$computeAndRenderReturnType.getBuiltinTypes().getNullableAny() : substitutor2.substitute(returnType);
        return copiedDeclaration instanceof KtProperty || !$this$computeAndRenderReturnType.isUnitType(returnType) ? KaRenderer.render$default($this$computeAndRenderReturnType, returnType, null, Variance.INVARIANT, 1, null) : null;
    }

    public static final void makeAbstract(@NotNull KtCallableDeclaration member, @NotNull KtClass targetClass) {
        PsiElement deleteFrom;
        PsiElement psiElement;
        KtCallableDeclaration ktCallableDeclaration;
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        if (!targetClass.isInterface()) {
            member.addModifier(KtTokens.ABSTRACT_KEYWORD);
        }
        if ((ktCallableDeclaration = member) instanceof KtProperty) {
            psiElement = ((KtProperty)member).getEqualsToken();
            if (psiElement == null) {
                KtPropertyDelegate ktPropertyDelegate = ((KtProperty)member).getDelegate();
                if (ktPropertyDelegate != null) {
                    psiElement = (PsiElement)ktPropertyDelegate;
                } else {
                    List list2 = ((KtProperty)member).getAccessors();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
                    psiElement = (PsiElement)CollectionsKt.firstOrNull((List)list2);
                }
            }
        } else if (ktCallableDeclaration instanceof KtNamedFunction) {
            psiElement = ((KtNamedFunction)member).getEqualsToken();
            if (psiElement == null) {
                psiElement = (PsiElement)((KtNamedFunction)member).getBodyExpression();
            }
        } else {
            psiElement = null;
        }
        if ((deleteFrom = psiElement) != null) {
            member.deleteChildRange(deleteFrom, member.getLastChild());
        }
    }
}

