/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror;

import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0011\u0012B\u0013\b\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J3\u0010\t\u001a\u0004\u0018\u00018\u00002\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", "T", "", "method", "Lcom/sun/jdi/Method;", "<init>", "(Lcom/sun/jdi/Method;)V", "getMethod", "()Lcom/sun/jdi/Method;", "value", "Lcom/sun/jdi/ObjectReference;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "values", "", "Lcom/sun/jdi/Value;", "(Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;[Lcom/sun/jdi/Value;)Ljava/lang/Object;", "DefaultMethodEvaluator", "MirrorMethodEvaluator", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator$DefaultMethodEvaluator;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator$MirrorMethodEvaluator;", "intellij.kotlin.jvm.debugger.coroutines"})
public abstract sealed class MethodEvaluator<T> {
    @Nullable
    private final Method method;

    private MethodEvaluator(Method method) {
        this.method = method;
    }

    @Nullable
    public final Method getMethod() {
        return this.method;
    }

    @Nullable
    public final T value(@Nullable ObjectReference value, @NotNull DefaultExecutionContext context2, Value ... values2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Method method = this.method;
        if (method != null) {
            Object object;
            Method it = method;
            boolean bl = false;
            if (this.method.isStatic()) {
                List args = value != null ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)value), (Iterable)ArraysKt.toList((Object[])values2)) : ArraysKt.toList((Object[])values2);
                object = context2.getEvaluationContext().computeAndKeep(() -> MethodEvaluator.value$lambda$0$0(context2, this, args));
            } else if (value != null) {
                object = context2.getEvaluationContext().computeAndKeep(() -> MethodEvaluator.value$lambda$0$1(context2, value, this, values2));
            } else {
                throw new IllegalArgumentException("Exception while calling method " + this.method.signature() + " with an empty value.");
            }
            return (T)object;
        }
        return null;
    }

    private static final Value value$lambda$0$0(DefaultExecutionContext $context, MethodEvaluator this$0, List $args) {
        ReferenceType referenceType = this$0.method.declaringType();
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
        return $context.invokeMethod((ClassType)referenceType, this$0.method, $args, true);
    }

    private static final Value value$lambda$0$1(DefaultExecutionContext $context, ObjectReference $value, MethodEvaluator this$0, Value[] $values) {
        return BaseExecutionContext.invokeMethod$default($context, $value, this$0.method, ArraysKt.toList((Object[])$values), 0, true, 8, null);
    }

    public /* synthetic */ MethodEvaluator(Method method, DefaultConstructorMarker $constructor_marker) {
        this(method);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator$DefaultMethodEvaluator;", "T", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", "method", "Lcom/sun/jdi/Method;", "<init>", "(Lcom/sun/jdi/Method;)V", "intellij.kotlin.jvm.debugger.coroutines"})
    public static final class DefaultMethodEvaluator<T>
    extends MethodEvaluator<T> {
        public DefaultMethodEvaluator(@Nullable Method method) {
            super(method, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\n\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator$MirrorMethodEvaluator;", "T", "F", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MethodEvaluator;", "method", "Lcom/sun/jdi/Method;", "mirrorProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorProvider;", "<init>", "(Lcom/sun/jdi/Method;Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorProvider;)V", "mirror", "ref", "Lcom/sun/jdi/ObjectReference;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "values", "", "Lcom/sun/jdi/Value;", "(Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;[Lcom/sun/jdi/Value;)Ljava/lang/Object;", "isCompatible", "", "value", "(Ljava/lang/Object;)Z", "intellij.kotlin.jvm.debugger.coroutines"})
    public static final class MirrorMethodEvaluator<T, F>
    extends MethodEvaluator<T> {
        @NotNull
        private final MirrorProvider<T, F> mirrorProvider;

        public MirrorMethodEvaluator(@Nullable Method method, @NotNull MirrorProvider<T, F> mirrorProvider) {
            Intrinsics.checkNotNullParameter(mirrorProvider, (String)"mirrorProvider");
            super(method, null);
            this.mirrorProvider = mirrorProvider;
        }

        @Nullable
        public final F mirror(@NotNull ObjectReference ref, @NotNull DefaultExecutionContext context2, Value ... values2) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            return this.mirrorProvider.mirror(this.value(ref, context2, Arrays.copyOf(values2, values2.length)), context2);
        }

        public final boolean isCompatible(T value) {
            return this.mirrorProvider.isCompatible(value);
        }
    }
}

