/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.indices.KotlinPackageIndexUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.util.K1ModeProjectStructureApi;
import org.jetbrains.kotlin.idea.caches.ImplicitPackagePrefixCache;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheServiceKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.NotNullableUserDataProperty;

@Service(value={Service.Level.PROJECT})
@K1ModeProjectStructureApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0007\u0018\u0000 52\u00020\u0001:\u0003567B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0002J,\u0010\u001d\u001a&\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00070\u00070\u0007H\u0002J\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b J\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\tH\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J/\u0010$\u001a\u00020\u001b\"\u0004\b\u0000\u0010%*\b\u0012\u0004\u0012\u0002H%0&2\u0014\b\u0004\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u001b0(H\u0082\bJ\u0014\u0010)\u001a\u00020\u000b*\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\tJ\u000e\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020*J\u001a\u00102\u001a\u00020\u001b2\u0006\u00101\u001a\u00020*2\b\u00103\u001a\u0004\u0018\u00010\nH\u0007J\b\u00104\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0006\u001a(\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00070\u0007\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000Rn\u0010\f\u001ab\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00000\u0000\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u000e*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \u000e*0\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00000\u0000\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u000e*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cacheInstance", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/name/FqName;", "", "cacheInstanceUpdater", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "kotlin.jvm.PlatformType", "implicitPackagePrefixCache", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "useStrongMapForCaching", "pendingVFileChanges", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "pendingKtFileChanges", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtFile;", "projectScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "onTooComplexChange", "", "clear", "cache", "notifyPackageChange", "file", "notifyPackageChange$intellij_kotlin_base_analysis", "invalidateCacheForModuleSourceInfo", "moduleSourceInfo", "checkPendingChanges", "processPending", "T", "", "body", "Lkotlin/Function1;", "containedInOrContains", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "", "packageExists", "packageFqName", "moduleInfo", "getImplicitPackagePrefix", "sourceRoot", "setImplicitPackagePrefix", "fqName", "dispose", "Companion", "PackageCacheBulkFileListener", "PackageCacheModuleRootListener", "intellij.kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nPerModulePackageCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,530:1\n382#1:532\n394#1:533\n382#1:534\n394#1:535\n1#2:531\n1#2:538\n1#2:541\n1#2:544\n72#3,2:536\n72#3,2:539\n72#3,2:542\n*S KotlinDebug\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService\n*L\n333#1:532\n333#1:533\n362#1:534\n362#1:535\n405#1:538\n408#1:541\n413#1:544\n405#1:536,2\n408#1:539,2\n413#1:542,2\n*E\n"})
public final class PerModulePackageCacheService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private volatile ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> cacheInstance;
    private final AtomicReferenceFieldUpdater<PerModulePackageCacheService, ConcurrentMap<?, ?>> cacheInstanceUpdater;
    @NotNull
    private final ImplicitPackagePrefixCache implicitPackagePrefixCache;
    private final boolean useStrongMapForCaching;
    @NotNull
    private final Set<VFileEvent> pendingVFileChanges;
    @NotNull
    private final Set<SmartPsiElementPointer<KtFile>> pendingKtFileChanges;
    @NotNull
    private final GlobalSearchScope projectScope;
    public static final int FULL_DROP_THRESHOLD = 1000;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final NotNullableUserDataProperty<? super Project, Boolean> DEBUG_LOG_ENABLE_PerModulePackageCache$delegate;

    public PerModulePackageCacheService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cacheInstanceUpdater = AtomicReferenceFieldUpdater.newUpdater(PerModulePackageCacheService.class, ConcurrentMap.class, "cacheInstance");
        this.implicitPackagePrefixCache = new ImplicitPackagePrefixCache(this.project);
        this.useStrongMapForCaching = Registry.Companion.is("kotlin.cache.packages.strong.map", false);
        this.pendingVFileChanges = new LinkedHashSet();
        this.pendingKtFileChanges = new LinkedHashSet();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        this.projectScope = globalSearchScope;
    }

    public final void onTooComplexChange() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clear() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            boolean bl = false;
            this.pendingVFileChanges.clear();
            this.pendingKtFileChanges.clear();
            this.cacheInstance = null;
            this.implicitPackagePrefixCache.clear$intellij_kotlin_base_analysis();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> cache() {
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap;
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap2 = this.cacheInstance;
        if (concurrentMap2 != null) {
            ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> it = concurrentMap2;
            boolean bl = false;
            return it;
        }
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap3 = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap3, (String)"createConcurrentWeakMap(...)");
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> map2 = concurrentMap3;
        if (this.cacheInstanceUpdater.compareAndSet(this, null, map2)) {
            concurrentMap = map2;
        } else {
            ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap4 = this.cacheInstance;
            concurrentMap = concurrentMap4;
            Intrinsics.checkNotNull(concurrentMap4);
        }
        return concurrentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$intellij_kotlin_base_analysis(@NotNull VFileEvent file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            boolean bl = false;
            ((Collection)this.pendingVFileChanges).add(file);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$intellij_kotlin_base_analysis(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            boolean bl = false;
            ((Collection)this.pendingKtFileChanges).add(SmartPointerManager.getInstance((Project)this.project).createSmartPsiElementPointer((PsiElement)file, (PsiFile)file));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void invalidateCacheForModuleSourceInfo(ModuleSourceInfo moduleSourceInfo) {
        PerModulePackageCacheServiceKt.debugIfEnabled$default(LOG, this.project, false, () -> PerModulePackageCacheService.invalidateCacheForModuleSourceInfo$lambda$0(moduleSourceInfo), 2, null);
        ConcurrentMap cache2 = this.cacheInstance;
        ConcurrentMap concurrentMap = cache2;
        if (concurrentMap == null || (concurrentMap = (ConcurrentMap)concurrentMap.get(moduleSourceInfo.getModule())) == null) {
            return;
        }
        ConcurrentMap perSourceInfoData = concurrentMap;
        ConcurrentMap concurrentMap2 = (ConcurrentMap)perSourceInfoData.get(moduleSourceInfo);
        if (concurrentMap2 == null) {
            return;
        }
        ConcurrentMap dataForSourceInfo = concurrentMap2;
        dataForSourceInfo.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkPendingChanges() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            boolean bl = false;
            if (this.pendingVFileChanges.size() + this.pendingKtFileChanges.size() >= 1000) {
                this.onTooComplexChange();
            } else {
                ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> cache2 = this.cacheInstance;
                PerModulePackageCacheService perModulePackageCacheService2 = this;
                Collection $this$processPending$iv = this.pendingVFileChanges;
                boolean $i$f$processPending = false;
                Function1 function1 = (Function1)new Function1<VFileEvent, Boolean>(cache2, this){
                    final /* synthetic */ ConcurrentMap $cache$inlined;
                    final /* synthetic */ PerModulePackageCacheService this$0;
                    {
                        this.$cache$inlined = concurrentMap;
                        this.this$0 = perModulePackageCacheService;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Boolean invoke(Object value) {
                        block10: {
                            try {
                                VFileEvent event = (VFileEvent)value;
                                boolean bl = false;
                                VirtualFile virtualFile = event.getFile();
                                if (virtualFile == null) break block10;
                                VirtualFile vfile = virtualFile;
                                if (vfile.isDirectory() || !vfile.isValid()) {
                                    if (this.$cache$inlined != null) {
                                        ConcurrentMap cache2 = this.$cache$inlined;
                                        boolean bl2 = false;
                                        for (Map.Entry<K, V> entry : ((Map)cache2).entrySet()) {
                                            boolean bl3;
                                            ConcurrentMap data;
                                            Module module;
                                            block11: {
                                                String[] sourceRootUrls;
                                                module = (Module)entry.getKey();
                                                data = (ConcurrentMap)entry.getValue();
                                                Intrinsics.checkNotNull((Object)module);
                                                Intrinsics.checkNotNullExpressionValue((Object)ProjectUtil.getRootManager((Module)module).getSourceRootUrls(), (String)"getSourceRootUrls(...)");
                                                String[] $this$any$iv = sourceRootUrls;
                                                boolean $i$f$any = false;
                                                int n = $this$any$iv.length;
                                                for (int j = 0; j < n; ++j) {
                                                    String element$iv;
                                                    String url = element$iv = $this$any$iv[j];
                                                    boolean bl4 = false;
                                                    Intrinsics.checkNotNull((Object)url);
                                                    if (!PerModulePackageCacheService.access$containedInOrContains(this.this$0, vfile, url)) continue;
                                                    bl3 = true;
                                                    break block11;
                                                }
                                                bl3 = false;
                                            }
                                            if (!bl3) continue;
                                            PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(module){
                                                final /* synthetic */ Module $module;
                                                {
                                                    this.$module = $module;
                                                }

                                                public final String invoke() {
                                                    return "Invalidated cache for " + this.$module;
                                                }
                                            }, 2, null);
                                            data.clear();
                                        }
                                    }
                                } else {
                                    IdeaModuleInfo infoByVirtualFile = ModuleInfoProviderUtils.firstOrNull(ModuleInfoProvider.Companion.getInstance(PerModulePackageCacheService.access$getProject$p(this.this$0)), vfile);
                                    if (infoByVirtualFile == null || !(infoByVirtualFile instanceof ModuleSourceInfo)) {
                                        PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(vfile, infoByVirtualFile){
                                            final /* synthetic */ VirtualFile $vfile;
                                            final /* synthetic */ IdeaModuleInfo $infoByVirtualFile;
                                            {
                                                this.$vfile = $vfile;
                                                this.$infoByVirtualFile = $infoByVirtualFile;
                                            }

                                            public final String invoke() {
                                                return "Skip " + this.$vfile + " as it has mismatched ModuleInfo=" + this.$infoByVirtualFile;
                                            }
                                        }, 2, null);
                                    }
                                    ModuleSourceInfo moduleSourceInfo = infoByVirtualFile instanceof ModuleSourceInfo ? (ModuleSourceInfo)infoByVirtualFile : null;
                                    if (moduleSourceInfo != null) {
                                        ModuleSourceInfo it = moduleSourceInfo;
                                        boolean bl5 = false;
                                        PerModulePackageCacheService.access$invalidateCacheForModuleSourceInfo(this.this$0, it);
                                    }
                                }
                                PerModulePackageCacheService.access$getImplicitPackagePrefixCache$p(this.this$0).update$intellij_kotlin_base_analysis(event);
                            }
                            catch (ProcessCanceledException pce) {
                                throw pce;
                            }
                            catch (Exception exc) {
                                PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                            }
                        }
                        return true;
                    }
                };
                $this$processPending$iv.removeIf(new Predicate(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ boolean test(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                });
                PerModulePackageCacheService this_$iv = this;
                $this$processPending$iv = this.pendingKtFileChanges;
                $i$f$processPending = false;
                function1 = (Function1)new Function1<SmartPsiElementPointer<KtFile>, Boolean>(this){
                    final /* synthetic */ PerModulePackageCacheService this$0;
                    {
                        this.this$0 = perModulePackageCacheService;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Boolean invoke(Object value) {
                        block6: {
                            try {
                                SmartPsiElementPointer filePointer = (SmartPsiElementPointer)value;
                                boolean bl = false;
                                KtFile file = (KtFile)filePointer.getElement();
                                if (file == null || file.getVirtualFile() != null && !PerModulePackageCacheService.access$getProjectScope$p(this.this$0).contains(file.getVirtualFile())) {
                                    PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(file, this.this$0){
                                        final /* synthetic */ KtFile $file;
                                        final /* synthetic */ PerModulePackageCacheService this$0;
                                        {
                                            this.$file = $file;
                                            this.this$0 = $receiver;
                                        }

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final String invoke() {
                                            Boolean bl;
                                            KtFile ktFile2 = this.$file;
                                            KtFile ktFile3 = this.$file;
                                            if (ktFile3 != null && (ktFile3 = ktFile3.getVirtualFile()) != null) {
                                                void it;
                                                KtFile ktFile4 = ktFile3;
                                                PerModulePackageCacheService perModulePackageCacheService = this.this$0;
                                                KtFile ktFile5 = ktFile4;
                                                KtFile ktFile6 = ktFile2;
                                                boolean bl2 = false;
                                                bl = !PerModulePackageCacheService.access$getProjectScope$p(perModulePackageCacheService).contains((VirtualFile)it);
                                                ktFile2 = ktFile6;
                                            } else {
                                                bl = null;
                                            }
                                            return "Skip " + ktFile2 + " without vFile, or not in scope: " + bl;
                                        }
                                    }, 2, null);
                                    break block6;
                                }
                                IdeaModuleInfo nullableModuleInfo = ModuleInfoProviderUtils.getModuleInfoOrNull((PsiElement)file);
                                ModuleSourceInfo moduleSourceInfo = nullableModuleInfo instanceof ModuleSourceInfo ? (ModuleSourceInfo)nullableModuleInfo : null;
                                if (moduleSourceInfo != null) {
                                    ModuleSourceInfo it = moduleSourceInfo;
                                    boolean bl2 = false;
                                    PerModulePackageCacheService.access$invalidateCacheForModuleSourceInfo(this.this$0, it);
                                }
                                if (nullableModuleInfo == null || !(nullableModuleInfo instanceof ModuleSourceInfo)) {
                                    PerModulePackageCacheServiceKt.debugIfEnabled$default(PerModulePackageCacheService.access$getLOG$cp(), PerModulePackageCacheService.access$getProject$p(this.this$0), false, (Function0)new Function0<String>(file, nullableModuleInfo){
                                        final /* synthetic */ KtFile $file;
                                        final /* synthetic */ IdeaModuleInfo $nullableModuleInfo;
                                        {
                                            this.$file = $file;
                                            this.$nullableModuleInfo = $nullableModuleInfo;
                                        }

                                        public final String invoke() {
                                            return "Skip " + this.$file + " as it has mismatched ModuleInfo=" + this.$nullableModuleInfo;
                                        }
                                    }, 2, null);
                                }
                                PerModulePackageCacheService.access$getImplicitPackagePrefixCache$p(this.this$0).update$intellij_kotlin_base_analysis(file);
                            }
                            catch (ProcessCanceledException pce) {
                                throw pce;
                            }
                            catch (Exception exc) {
                                PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                            }
                        }
                        return true;
                    }
                };
                $this$processPending$iv.removeIf(new /* invalid duplicate definition of identical inner class */);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T> void processPending(Collection<T> $this$processPending, Function1<? super T, Unit> body2) {
        boolean $i$f$processPending = false;
        Function1 function1 = new Function1<T, Boolean>(body2){
            final /* synthetic */ Function1<T, Unit> $body;
            {
                this.$body = $body;
            }

            public final Boolean invoke(T value) {
                try {
                    this.$body.invoke(value);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Exception exc) {
                    PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                }
                return true;
            }
        };
        $this$processPending.removeIf(new /* invalid duplicate definition of identical inner class */);
    }

    private final boolean containedInOrContains(VirtualFile $this$containedInOrContains, String root) {
        return VfsUtilCore.isEqualOrAncestor((String)$this$containedInOrContains.getUrl(), (String)root) || $this$containedInOrContains.isDirectory() && VfsUtilCore.isEqualOrAncestor((String)root, (String)$this$containedInOrContains.getUrl());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean packageExists(@NotNull FqName packageFqName, @NotNull ModuleSourceInfo moduleInfo) {
        boolean bl;
        ConcurrentMap $this$getOrPut$iv;
        ConcurrentMap default$iv;
        void $this$getOrPut$iv2;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Module module = moduleInfo.getModule();
        this.checkPendingChanges();
        ConcurrentMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> concurrentMap = this.cache();
        Object key$iv = module;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv2.get(key$iv);
        if (object == null) {
            boolean bl2 = false;
            ConcurrentMap concurrentMap2 = this.useStrongMapForCaching ? (ConcurrentMap)new ConcurrentHashMap() : CollectionFactory.createConcurrentSoftMap();
            Intrinsics.checkNotNull((Object)concurrentMap2);
            default$iv = concurrentMap2;
            boolean bl3 = false;
            object = $this$getOrPut$iv2.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ConcurrentMap perSourceInfoCache = (ConcurrentMap)object;
        key$iv = perSourceInfoCache;
        ModuleSourceInfo key$iv2 = moduleInfo;
        boolean $i$f$getOrPut2 = false;
        Object object2 = $this$getOrPut$iv.get(key$iv2);
        if (object2 == null) {
            boolean bl4 = false;
            default$iv = this.useStrongMapForCaching ? (ConcurrentMap)new ConcurrentHashMap() : CollectionFactory.createConcurrentSoftMap();
            Intrinsics.checkNotNull((Object)default$iv);
            ConcurrentMap default$iv2 = default$iv;
            bl = false;
            object2 = $this$getOrPut$iv.putIfAbsent(key$iv2, default$iv2);
            if (object2 == null) {
                object2 = default$iv2;
            }
        }
        ConcurrentMap cacheForCurrentModuleInfo = (ConcurrentMap)object2;
        if (!DumbService.Companion.isDumb(this.project) || FileBasedIndex.getInstance().getCurrentDumbModeAccessType(this.project) == null) {
            try {
                $this$getOrPut$iv = cacheForCurrentModuleInfo;
                key$iv2 = packageFqName;
                $i$f$getOrPut2 = false;
                Object object3 = $this$getOrPut$iv.get(key$iv2);
                if (object3 == null) {
                    boolean bl5 = false;
                    boolean packageExists = KotlinPackageIndexUtils.INSTANCE.packageExists(packageFqName, moduleInfo.getContentScope());
                    PerModulePackageCacheServiceKt.debugIfEnabled$default(LOG, this.project, false, () -> PerModulePackageCacheService.packageExists$lambda$2$0(packageFqName, moduleInfo, packageExists), 2, null);
                    Boolean default$iv3 = packageExists;
                    bl = false;
                    object3 = $this$getOrPut$iv.putIfAbsent(key$iv2, default$iv3);
                    if (object3 == null) {
                        object3 = default$iv3;
                    }
                }
                return (Boolean)object3;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        Object object4 = DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> PerModulePackageCacheService.packageExists$lambda$3(packageFqName, moduleInfo));
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"ignoreDumbMode(...)");
        return (Boolean)object4;
    }

    @NotNull
    public final FqName getImplicitPackagePrefix(@NotNull VirtualFile sourceRoot) {
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        this.checkPendingChanges();
        return this.implicitPackagePrefixCache.getPrefix(sourceRoot);
    }

    @TestOnly
    public final void setImplicitPackagePrefix(@NotNull VirtualFile sourceRoot, @Nullable FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        this.checkPendingChanges();
        if (fqName2 != null) {
            this.implicitPackagePrefixCache.setPrefix(sourceRoot, fqName2);
        } else {
            this.clear();
        }
    }

    public void dispose() {
        this.clear();
    }

    private static final String invalidateCacheForModuleSourceInfo$lambda$0(ModuleSourceInfo $moduleSourceInfo) {
        return "Invalidated cache for " + $moduleSourceInfo;
    }

    private static final String packageExists$lambda$2$0(FqName $packageFqName, ModuleSourceInfo $moduleInfo, boolean $packageExists) {
        return "Computed cache value for " + $packageFqName + " in " + $moduleInfo + " is " + $packageExists;
    }

    private static final Boolean packageExists$lambda$3(FqName $packageFqName, ModuleSourceInfo $moduleInfo) {
        return KotlinPackageIndexUtils.INSTANCE.packageExists($packageFqName, $moduleInfo.getContentScope());
    }

    public static final /* synthetic */ Project access$getProject$p(PerModulePackageCacheService $this) {
        return $this.project;
    }

    public static final /* synthetic */ ImplicitPackagePrefixCache access$getImplicitPackagePrefixCache$p(PerModulePackageCacheService $this) {
        return $this.implicitPackagePrefixCache;
    }

    public static final /* synthetic */ boolean access$containedInOrContains(PerModulePackageCacheService $this, VirtualFile $receiver, String root) {
        return $this.containedInOrContains($receiver, root);
    }

    public static final /* synthetic */ void access$invalidateCacheForModuleSourceInfo(PerModulePackageCacheService $this, ModuleSourceInfo moduleSourceInfo) {
        $this.invalidateCacheForModuleSourceInfo(moduleSourceInfo);
    }

    public static final /* synthetic */ GlobalSearchScope access$getProjectScope$p(PerModulePackageCacheService $this) {
        return $this.projectScope;
    }

    static {
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"debug.PerModulePackageCache");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DEBUG_LOG_ENABLE_PerModulePackageCache$delegate = new NotNullableUserDataProperty(key, (Object)false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u000f\u001a\u00020\u000e*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion;", "", "<init>", "()V", "FULL_DROP_THRESHOLD", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "project", "Lcom/intellij/openapi/project/Project;", "<set-?>", "", "DEBUG_LOG_ENABLE_PerModulePackageCache", "getDEBUG_LOG_ENABLE_PerModulePackageCache", "(Lcom/intellij/openapi/project/Project;)Z", "setDEBUG_LOG_ENABLE_PerModulePackageCache", "(Lcom/intellij/openapi/project/Project;Z)V", "DEBUG_LOG_ENABLE_PerModulePackageCache$delegate", "Lorg/jetbrains/kotlin/psi/NotNullableUserDataProperty;", "intellij.kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nPerModulePackageCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,530:1\n30#2,2:531\n*S KotlinDebug\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion\n*L\n449#1:531,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final PerModulePackageCacheService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PerModulePackageCacheService> serviceClass$iv = PerModulePackageCacheService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PerModulePackageCacheService)object;
        }

        public final boolean getDEBUG_LOG_ENABLE_PerModulePackageCache(@NotNull Project $this$DEBUG_LOG_ENABLE_PerModulePackageCache) {
            Intrinsics.checkNotNullParameter((Object)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, (String)"<this>");
            return (Boolean)DEBUG_LOG_ENABLE_PerModulePackageCache$delegate.getValue((UserDataHolder)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, $$delegatedProperties[0]);
        }

        public final void setDEBUG_LOG_ENABLE_PerModulePackageCache(@NotNull Project $this$DEBUG_LOG_ENABLE_PerModulePackageCache, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, (String)"<this>");
            DEBUG_LOG_ENABLE_PerModulePackageCache$delegate.setValue((UserDataHolder)$this$DEBUG_LOG_ENABLE_PerModulePackageCache, $$delegatedProperties[0], (Object)bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "DEBUG_LOG_ENABLE_PerModulePackageCache", "getDEBUG_LOG_ENABLE_PerModulePackageCache(Lcom/intellij/openapi/project/Project;)Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u000b\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001e\u0010\u000f\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheBulkFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "before", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "after", "isRelevant", "", "event", "onEvents", "isAfter", "intellij.kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nPerModulePackageCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheBulkFileListener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,530:1\n1321#2,2:531\n*S KotlinDebug\n*F\n+ 1 PerModulePackageCacheService.kt\norg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheBulkFileListener\n*L\n507#1:531,2\n*E\n"})
    public static final class PackageCacheBulkFileListener
    implements BulkFileListener {
        @NotNull
        private final Project project;

        public PackageCacheBulkFileListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.onEvents(events, false);
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.onEvents(events, true);
        }

        private final boolean isRelevant(VFileEvent event) {
            boolean bl;
            VFileEvent vFileEvent = event;
            if (vFileEvent instanceof VFilePropertyChangeEvent) {
                bl = false;
            } else if (vFileEvent instanceof VFileCreateEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileMoveEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileDeleteEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileContentChangeEvent) {
                bl = true;
            } else if (vFileEvent instanceof VFileCopyEvent) {
                bl = true;
            } else {
                LOG.warn("Unknown vfs event: " + event.getClass());
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final void onEvents(List<? extends VFileEvent> events, boolean isAfter) {
            if (!this.project.isInitialized() || this.project.isDisposed()) {
                return;
            }
            PerModulePackageCacheService service2 = Companion.getInstance(this.project);
            FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.project).getFileManager();
            Intrinsics.checkNotNullExpressionValue((Object)fileManager, (String)"getFileManager(...)");
            FileManager fileManager2 = fileManager;
            if (events.size() >= 1000) {
                service2.onTooComplexChange();
            } else {
                void $this$forEach$iv;
                FileTypeManager fileTypeManager = FileTypeManager.getInstance();
                Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)events), (Function1)((Function1)new Function1<VFileEvent, Boolean>((Object)this){

                    public final Boolean invoke(VFileEvent p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return PackageCacheBulkFileListener.access$isRelevant((PackageCacheBulkFileListener)this.receiver, p0);
                    }
                })), PackageCacheBulkFileListener::onEvents$lambda$0), arg_0 -> PackageCacheBulkFileListener.onEvents$lambda$1(fileTypeManager, arg_0)), arg_0 -> PackageCacheBulkFileListener.onEvents$lambda$2(isAfter, fileManager2, arg_0)), arg_0 -> PackageCacheBulkFileListener.onEvents$lambda$3(this, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VFileEvent event = (VFileEvent)element$iv;
                    boolean bl = false;
                    service2.notifyPackageChange$intellij_kotlin_base_analysis(event);
                }
            }
        }

        private static final boolean onEvents$lambda$0(VFileEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (it.isValid() || !(it instanceof VFileCreateEvent)) && it.getFile() != null;
        }

        private static final boolean onEvents$lambda$1(FileTypeManager $fileTypeManager, VFileEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            VirtualFile virtualFile = it.getFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile vFile = virtualFile;
            return vFile.isDirectory() || Intrinsics.areEqual((Object)KotlinFileType.INSTANCE, (Object)$fileTypeManager.getFileTypeByFileName(vFile.getName()));
        }

        private static final boolean onEvents$lambda$2(boolean $isAfter, FileManager $fileManager, VFileEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof VFileContentChangeEvent ? $isAfter && $fileManager.findCachedViewProvider(((VFileContentChangeEvent)it).getFile()) == null : true;
        }

        private static final boolean onEvents$lambda$3(PackageCacheBulkFileListener this$0, VFileEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object origin = it.getRequestor();
            return origin instanceof Project ? Intrinsics.areEqual((Object)origin, (Object)this$0.project) : (origin instanceof PsiManager ? Intrinsics.areEqual((Object)((PsiManager)origin).getProject(), (Object)this$0.project) : true);
        }

        public static final /* synthetic */ boolean access$isRelevant(PackageCacheBulkFileListener $this, VFileEvent event) {
            return $this.isRelevant(event);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$PackageCacheModuleRootListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "rootsChanged", "", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "intellij.kotlin.base.analysis"})
    public static final class PackageCacheModuleRootListener
    implements ModuleRootListener {
        @NotNull
        private final Project project;

        public PackageCacheModuleRootListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Companion.getInstance(this.project).onTooComplexChange();
        }
    }
}

