/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.en.QuantifierNounCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.Set;

enum SemCompatibility {
    Unlikely,
    Unknown,
    Possible,
    Likely;

    static final NodePattern needsHumanSubject;
    static final NodePattern prefersAnimalSubject;
    static final NodePattern needsAnimateSubject;
    static final NodePattern needsInanimateSubject;
    static final NodePattern needsAnimateObject;
    private static final NodePattern considerAsPlural;
    private static final NodePattern needsInanimateObject;
    static final NodePattern nominalPredicate;
    private static final NodePattern inSomeCondition;
    private static final NodePattern betweenArg;

    static SemCompatibility forSubject(Node predicate, Node subject) {
        if (needsInanimateSubject.matches(predicate)) {
            return SemCompatibility.expectInanimate(subject);
        }
        if (needsAnimateSubject.matches(predicate)) {
            return SemCompatibility.expectAnimate(subject);
        }
        if (needsHumanSubject.matches(predicate)) {
            return SemCompatibility.expectHumanLike(subject);
        }
        if (prefersAnimalSubject.matches(predicate)) {
            return SemCompatibility.preferAnimal(subject);
        }
        if (nominalPredicate.matches(predicate)) {
            Semantics.Animacy predAnimacy = Semantics.animacy(predicate);
            if (predAnimacy == Semantics.Animacy.inanimate) {
                return SemCompatibility.expectInanimate(subject);
            }
            if (predAnimacy == Semantics.Animacy.humanLike) {
                if (QuantifierNounCompatibility.definitelySg.matches(predicate) && subject.hasForm("they")) {
                    return Unlikely;
                }
                return SemCompatibility.expectHumanLike(subject);
            }
            if (predAnimacy == Semantics.Animacy.animal) {
                return SemCompatibility.preferAnimal(subject);
            }
        }
        if (inSomeCondition.matches(predicate)) {
            for (Node amod : predicate.findDependents("amod")) {
                SemCompatibility compatibility = SemCompatibility.forSubject(amod, subject);
                if (compatibility == Unknown) continue;
                return compatibility;
            }
        }
        return Unknown;
    }

    private static SemCompatibility preferAnimal(Node node) {
        Semantics.Animacy animacy = Semantics.animacy(node);
        return animacy == Semantics.Animacy.animal ? Likely : (animacy == Semantics.Animacy.humanLike ? Possible : (animacy != null ? Unlikely : Unknown));
    }

    private static SemCompatibility expectHumanLike(Node node) {
        Semantics.Animacy animacy = Semantics.animacy(node);
        return animacy == Semantics.Animacy.humanLike ? Likely : (animacy != null || node.hasForm("it") ? Unlikely : Unknown);
    }

    private static SemCompatibility forObject(Node predicate, Node obj) {
        if (needsAnimateObject.matches(predicate)) {
            return SemCompatibility.expectAnimate(obj);
        }
        if (needsInanimateObject.matches(predicate)) {
            return SemCompatibility.expectInanimate(obj);
        }
        if (considerAsPlural.matches(predicate)) {
            return QuantifierNounCompatibility.definitelySg.matches(obj) ? Unlikely : Unknown;
        }
        return Unknown;
    }

    private static SemCompatibility expectInanimate(Node noun) {
        Semantics.Animacy animacy = Semantics.animacy(noun);
        return animacy == Semantics.Animacy.inanimate ? Likely : (animacy != null ? Unlikely : Unknown);
    }

    private static SemCompatibility expectAnimate(Node noun) {
        Semantics.Animacy animacy = Semantics.animacy(noun);
        return animacy == Semantics.Animacy.inanimate ? Unlikely : (animacy != null ? Likely : Unknown);
    }

    private static SemCompatibility forNodes(Relation relation, Node predicate, Node arg) {
        return switch (relation.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> SemCompatibility.forSubject(predicate, arg);
            case 1 -> SemCompatibility.forObject(predicate, arg);
        };
    }

    NodePattern between(Relation rel, NodePointer predicate, NodePointer arg) {
        return NodePattern.custom((__, match) -> SemCompatibility.forNodes(rel, predicate.findNode(match), arg.findNode(match)) == this ? match : null);
    }

    static boolean isPrepositionApplicable(String preposition, Node noun) {
        if (preposition.equals("between")) {
            return betweenArg.matches(noun);
        }
        return true;
    }

    static {
        needsHumanSubject = NodePattern.or(NodePattern.N.lemma("pay|tell|study|harass"), NodePattern.N.lemma("drive").noDependents("obj"), NodePattern.N.lemma("take").withDependent("obj", NodePattern.N.lemma("medicine|exam")), NodePattern.N.lemma("do|take").withDependent("obj", NodePattern.N.lemma("exercise")));
        prefersAnimalSubject = NodePattern.N.lemma("bite");
        needsAnimateSubject = NodePattern.or(NodePattern.N.lemma(Set.of("eat", "feel", "think", "thank", "coach", "consider", "young", "elderly", "experienced", "inexperienced", "outgoing", "happy", "sad", "angry")), NodePattern.N.lemma("regret|drink|feel|wonder|escape|book").onlyPos("VB.*"), NodePattern.N.form("living"));
        needsInanimateSubject = NodePattern.or(NodePattern.N.lemma(Set.of("costly", "dilapidated", "gripping", "stimulating", "grave", "rapid", "consist", "contain", "belong", "comprise", "occur", "entail")), NodePattern.N.form("live"));
        needsAnimateObject = NodePattern.N.lemma("scare|vaccinate|bore|inform|force");
        considerAsPlural = NodePattern.N.lemma("consider").withDependent("obl", NodePattern.N.pos("NNS").withDependent("case", NodePattern.N.form("as")));
        needsInanimateObject = NodePattern.N.lemma("fray|buy");
        nominalPredicate = NodePattern.N.pos("NN.*").noDependents("case|obl|i?obj").noPotentialPos("VBG").noPos("RB.*");
        inSomeCondition = NodePattern.N.form("condition").withDependent("case", NodePattern.N.form("in")).withDependent("amod");
        betweenArg = NodePattern.or(NodePattern.N.pos("NNP?S"), NodePattern.N.withDependent("conj"));
    }

    static enum Relation {
        Subject,
        Object;

    }
}

